/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.folder.repository;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.folder.repository.Folders$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand$;
import com.xebialabs.xlrelease.repository.ReleaseMoveCommand;
import com.xebialabs.xlrelease.repository.ReleasesDeleteUnderFolderCommand;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.repository.XlrRepositoryCommand;
import com.xebialabs.xlrelease.repository.spi.RepositoryQueries;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Repository
@ScalaSignature(bytes="\u0006\u0001\rUr!B\u0001\u0003\u0011\u0003i\u0011a\u0002$pY\u0012,'o\u001d\u0006\u0003\u0007\u0011\t!B]3q_NLGo\u001c:z\u0015\t)a!\u0001\u0004g_2$WM\u001d\u0006\u0003\u000f!\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"a\u0002$pY\u0012,'o]\n\u0003\u001fI\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007\"B\r\u0010\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u001darB1A\u0005\u0002u\tQ\u0002R#G\u0003VcEk\u0018#F!RCU#\u0001\u0010\u0011\u0005My\u0012B\u0001\u0011\u0015\u0005\rIe\u000e\u001e\u0005\u0007E=\u0001\u000b\u0011\u0002\u0010\u0002\u001d\u0011+e)Q+M)~#U\t\u0015+IA!9Ae\u0004b\u0001\n\u0003i\u0012!\b#F!RCuLR(M\t\u0016\u0013vlV%U\u0011~\u0003VIU'J'NKuJT*\t\r\u0019z\u0001\u0015!\u0003\u001f\u0003y!U\t\u0015+I?\u001a{E\nR#S?^KE\u000bS0Q\u000bJk\u0015jU*J\u001f:\u001b\u0006\u0005C\u0004)\u001f\t\u0007I\u0011A\u0015\u0002\u0019\u0011+e)Q+M)~\u0003\u0016iR#\u0016\u0003)\u0002\"aE\u0016\n\u00051\"\"\u0001\u0002'p]\u001eDaAL\b!\u0002\u0013Q\u0013!\u0004#F\r\u0006+F\nV0Q\u0003\u001e+\u0005\u0005C\u00041\u001f\t\u0007I\u0011A\u0015\u00021\u0011+e)Q+M)~\u0013ViU+M)N{\u0006+\u0012*`!\u0006;U\t\u0003\u00043\u001f\u0001\u0006IAK\u0001\u001a\t\u00163\u0015)\u0016'U?J+5+\u0016'U'~\u0003VIU0Q\u0003\u001e+\u0005\u0005C\u00045\u001f\t\u0007I\u0011A\u001b\u0002\u001fA\u0013v\nU#S)f{6\u000bV!U+N+\u0012A\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nA\u0001\\1oO*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u0019\u0019FO]5oO\"1qh\u0004Q\u0001\nY\n\u0001\u0003\u0015*P!\u0016\u0013F+W0T)\u0006#Vk\u0015\u0011\t\u000f\u0005{!\u0019!C\u0001k\u0005\u0001\u0002KU(Q\u000bJ#\u0016lX#O\u0003\ncU\t\u0012\u0005\u0007\u0007>\u0001\u000b\u0011\u0002\u001c\u0002#A\u0013v\nU#S)f{VIT!C\u0019\u0016#\u0005\u0005C\u0004F\u001f\t\u0007I\u0011\u0001$\u0002'\u0005\u001bE+\u0013,F?N#\u0016\tV+T\u000bN{6+\u0012+\u0016\u0003\u001d\u00032\u0001S&O\u001d\t\u0019\u0012*\u0003\u0002K)\u00051\u0001K]3eK\u001aL!\u0001T'\u0003\u0007M+GO\u0003\u0002K)A\u0011\u0001jT\u0005\u0003{5Ca!U\b!\u0002\u00139\u0015\u0001F!D)&3ViX*U\u0003R+6+R*`'\u0016#\u0006E\u0002\u0003\u0011\u0005\u0001\u00196c\u0001*\u0013)B\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u0006g24GG\u001b\u0006\u00023\u0006AqM]5{u2,G-\u0003\u0002\\-\n9Aj\\4hS:<\u0007\u0002C/S\u0005\u0003\u0005\u000b\u0011\u00020\u0002#I,\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW\r\u0005\u0002`G6\t\u0001M\u0003\u0002\u0004C*\u0011!\rC\u0001\tI\u0016\u0004Hn\\=ji&\u0011A\r\u0019\u0002\u0012%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0007\u0002\u00034S\u0005\u0003\u0005\u000b\u0011B4\u0002\u0017\rL\u0017\nZ*feZL7-\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u001a\tqa]3sm&\u001cW-\u0003\u0002mS\nY1)[%e'\u0016\u0014h/[2f\u0011!q'K!A!\u0002\u0013y\u0017\u0001\u0006:fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW\r\u0005\u0002ia&\u0011\u0011/\u001b\u0002\u0015%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\t\u0011M\u0014&\u0011!Q\u0001\nQ\f\u0001\u0003Z3d_J\fGo\u001c:TKJ4\u0018nY3\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005e4\u0011aA1qS&\u00111P\u001e\u0002!\u0013:$XM\u001d8bY6+G/\u00193bi\u0006$UmY8sCR|'oU3sm&\u001cW\r\u0003\u0005~%\n\u0005\t\u0015!\u0003\u007f\u0003-\u0001XM]7jgNLwN\\:\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0004\u0002\u0011M,7-\u001e:jifLA!a\u0002\u0002\u0002\t\t\u0002+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\t\u0015\u0005-!K!A!\u0002\u0013\ti!A\u0003uK\u0006l7\u000f\u0005\u0003\u0002\u0010\u0005MQBAA\t\u0015\t\u0019a!\u0003\u0003\u0002\u0016\u0005E!!\u0002+fC6\u001c\bBCA\r%\n\u0005\t\u0015!\u0003\u0002\u001c\u0005)A/Y:lgB!\u0011qBA\u000f\u0013\u0011\ty\"!\u0005\u0003\u000bQ\u000b7o[:\t\u0015\u0005\r\"K!A!\u0002\u0013\t)#A\tsKB|7/\u001b;pef\fV/\u001a:jKN\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\t\t\"A\u0002ta&LA!a\f\u0002*\t\t\"+\u001a9pg&$xN]=Rk\u0016\u0014\u0018.Z:\t\u0015\u0005M\"K!A!\u0002\u0013\t)$\u0001\u0005fm\u0016tGOQ;t!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e\r\u00051QM^3oiNLA!a\u0010\u0002:\t\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\t\u0015\u0005\r#K!A!\u0002\u0013\t)%A\u0007yYJ\u0014V\r]8tSR|'/\u001f\t\u0005\u0003\u001f\t9%\u0003\u0003\u0002J\u0005E!!\u0004-meJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0004\u001a%\u0012\u0005\u0011Q\n\u000b\u0017\u0003\u001f\n\t&a\u0015\u0002V\u0005]\u0013\u0011LA.\u0003;\ny&!\u0019\u0002dA\u0011aB\u0015\u0005\u0007;\u0006-\u0003\u0019\u00010\t\r\u0019\fY\u00051\u0001h\u0011\u0019q\u00171\na\u0001_\"11/a\u0013A\u0002QDa!`A&\u0001\u0004q\b\u0002CA\u0006\u0003\u0017\u0002\r!!\u0004\t\u0011\u0005e\u00111\na\u0001\u00037A\u0001\"a\t\u0002L\u0001\u0007\u0011Q\u0005\u0005\t\u0003g\tY\u00051\u0001\u00026!A\u00111IA&\u0001\u0004\t)\u0005\u000b\u0003\u0002L\u0005\u001d\u0004\u0003BA5\u0003\u007fj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u000bC:tw\u000e^1uS>t'\u0002BA9\u0003g\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002v\u0005]\u0014!\u00022fC:\u001c(\u0002BA=\u0003w\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003{\n1a\u001c:h\u0013\u0011\t\t)a\u001b\u0003\u0013\u0005+Ho\\<je\u0016$\u0007bBAC%\u0012\u0005\u0011qQ\u0001\tM&tGMQ=JIR1\u0011\u0011RAL\u00037\u0003B!a#\u0002\u00146\u0011\u0011Q\u0012\u0006\u0004\u000b\u0005=%bAAI\r\u00051Am\\7bS:LA!!&\u0002\u000e\n1ai\u001c7eKJDq!!'\u0002\u0004\u0002\u0007a*\u0001\u0005g_2$WM]%e\u0011!\ti*a!A\u0002\u0005}\u0015!\u00023faRD\u0007#BAQ\u0003OsRBAAR\u0015\r\t)KO\u0001\u0005kRLG.\u0003\u0003\u0002*\u0006\r&\u0001C(qi&|g.\u00197\t\u000f\u0005\u0015%\u000b\"\u0001\u0002.R1\u0011\u0011RAX\u0003cCq!!'\u0002,\u0002\u0007a\n\u0003\u0006\u0002\u001e\u0006-\u0006\u0013!a\u0001\u0003g\u0003BaEA[=%\u0019\u0011q\u0017\u000b\u0003\r=\u0003H/[8o\u0011\u001d\tYL\u0015C\u0001\u0003{\u000b!BZ5oI\nK\b+\u0019;i)\u0019\tI)a0\u0002D\"9\u0011\u0011YA]\u0001\u0004q\u0015\u0001\u00029bi\"D\u0001\"!(\u0002:\u0002\u0007\u0011q\u0014\u0005\b\u0003w\u0013F\u0011AAd)\u0019\tI)!3\u0002L\"9\u0011\u0011YAc\u0001\u0004q\u0005\u0002CAO\u0003\u000b\u0004\r!a-\t\u000f\u0005='\u000b\"\u0001\u0002R\u0006aa-\u001b8e\u0013\u0012\u0014\u0015\u0010U1uQR\u0019a*a5\t\u000f\u0005\u0005\u0017Q\u001aa\u0001\u001d\"9\u0011q\u001b*\u0005\n\u0005e\u0017AE2sK\u0006$X\rR3gCVdG\u000fV3b[N$b!a7\u0002b\u0006\r\bcA\n\u0002^&\u0019\u0011q\u001c\u000b\u0003\tUs\u0017\u000e\u001e\u0005\b\u000b\u0005U\u0007\u0019AAE\u0011\u001d\t)/!6A\u00029\u000b\u0001\u0002]1sK:$\u0018\n\u001a\u0005\b\u0003S\u0014F\u0011AAv\u0003\u0019\u0019'/Z1uKR1\u0011\u0011RAw\u0003_Dq!!:\u0002h\u0002\u0007a\nC\u0004\u0006\u0003O\u0004\r!!#\t\u000f\u0005M(\u000b\"\u0001\u0002v\u00061A-\u001a7fi\u0016$B!a7\u0002x\"9\u0011\u0011TAy\u0001\u0004q\u0005bBA~%\u0012\u0005\u0011Q`\u0001\u0007e\u0016t\u0017-\\3\u0015\r\u0005%\u0015q B\u0001\u0011\u001d\tI*!?A\u00029CqAa\u0001\u0002z\u0002\u0007a*A\u0004oK^t\u0015-\\3\t\u000f\t\u001d!\u000b\"\u0001\u0003\n\u0005!Qn\u001c<f)\u0019\tIIa\u0003\u0003\u000e!9\u0011\u0011\u0014B\u0003\u0001\u0004q\u0005b\u0002B\b\u0005\u000b\u0001\rAT\u0001\f]\u0016<\b+\u0019:f]RLE\rC\u0004\u0003\u0014I#\tA!\u0006\u0002\u00171L7\u000f\u001e$pY\u0012,'o\u001d\u000b\r\u0005/\u0011iB!\t\u0003(\t-\"Q\u0006\t\u0007\u0003C\u0013I\"!#\n\t\tm\u00111\u0015\u0002\u0005\u0019&\u001cH\u000f\u0003\u0005\u0002f\nE\u0001\u0019\u0001B\u0010!\u0011\u0019\u0012Q\u0017(\t\u0011\t\r\"\u0011\u0003a\u0001\u0005K\tA\u0001]1hKB!1#!.+\u0011!\u0011IC!\u0005A\u0002\t\u0015\u0012!\u0004:fgVdG\u000fU3s!\u0006<W\r\u0003\u0005\u0002\u001e\nE\u0001\u0019AAZ\u0011!\u0011yC!\u0005A\u0002\tE\u0012a\u00063fG>\u0014\u0018\r^3XSRD\u0007+\u001a:nSN\u001c\u0018n\u001c8t!\u0015\u0019\u0012Q\u0017B\u001a!\r\u0019\"QG\u0005\u0004\u0005o!\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005w\u0011F\u0011\u0001B\u001f\u0003Ma\u0017n\u001d;Tk\n4w\u000e\u001c3feN\fV/\u001a:z)\u0011\u0011yD!\u0012\u0011\u0007}\u0013\t%C\u0002\u0003D\u0001\u0014Q\"U;fef$V-\u001c9mCR,\u0007\u0002CAs\u0005s\u0001\rAa\b\t\u000f\t%#\u000b\"\u0001\u0003L\u0005IB-Z2pe\u0006$XMR8mI\u0016\u0014\b+\u001a:nSN\u001c\u0018n\u001c8t)\u0011\u0011iE!\u001a\u0011\r\t=#qLAE\u001d\u0011\u0011\tFa\u0017\u000f\t\tM#\u0011L\u0007\u0003\u0005+R1Aa\u0016\r\u0003\u0019a$o\\8u}%\tQ#C\u0002\u0003^Q\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003b\t\r$aA*fc*\u0019!Q\f\u000b\t\u0011\t\u001d$q\ta\u0001\u0005\u001b\nqAZ8mI\u0016\u00148\u000fC\u0004\u0003lI#\tA!\u001c\u0002\u001fM,\u0017M]2i)\u0016l\u0007\u000f\\1uKN$\"Ba\u001c\u0003z\tm$Q\u0010B@!\u0019\t\tK!\u0007\u0003rA!!1\u000fB;\u001b\t\ty)\u0003\u0003\u0003x\u0005=%a\u0002*fY\u0016\f7/\u001a\u0005\b\u00033\u0013I\u00071\u0001O\u0011!\u0011\u0019C!\u001bA\u0002\t\u0015\u0002\u0002\u0003B\u0015\u0005S\u0002\rA!\n\t\u0011\u0005u%\u0011\u000ea\u0001\u0003gCqAa!S\t\u0003\u0011))\u0001\btK\u0006\u00148\r\u001b*fY\u0016\f7/Z:\u0015\u0019\t\u001d%1\u0013BK\u0005K\u00139Ka+\u0011\t\t%%qR\u0007\u0003\u0005\u0017S1A!$\u0007\u0003\u0019\u0019X-\u0019:dQ&!!\u0011\u0013BF\u0005M\u0011V\r\\3bg\u0016\u001cV-\u0019:dQJ+7/\u001e7u\u0011\u001d\tIJ!!A\u00029C\u0001Ba&\u0003\u0002\u0002\u0007!\u0011T\u0001\bM&dG/\u001a:t!\u0011\u0011YJ!)\u000e\u0005\tu%b\u0001BP\r\u0005)a/[3xg&!!1\u0015BO\u0005=\u0011V\r\\3bg\u0016\u001ch)\u001b7uKJ\u001c\b\u0002\u0003B\u0012\u0005\u0003\u0003\rA!\n\t\u0011\t%&\u0011\u0011a\u0001\u0005K\taB]3tk2$8\u000fU3s!\u0006<W\r\u0003\u0005\u0002\u001e\n\u0005\u0005\u0019AAZ\u0011\u001d\u0011yK\u0015C\u0001\u0005c\u000bA\"\\8wKR+W\u000e\u001d7bi\u0016$RA\u0014BZ\u0005kCq!!'\u0003.\u0002\u0007a\nC\u0004\u00038\n5\u0006\u0019\u0001(\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\rC\u0004\u0003<J#\tA!0\u0002\r\u0015D\u0018n\u001d;t)\u0011\u0011\u0019Da0\t\u000f\u0005e%\u0011\u0018a\u0001\u001d\"9!1\u0019*\u0005\u0002\t\u0015\u0017!E2iK\u000e\\gi\u001c7eKJ,\u00050[:ugR!\u00111\u001cBd\u0011\u001d\tIJ!1A\u00029CqAa3S\t\u0013\u0011i-A\fdQ\u0016\u001c7\u000eV3na2\fG/Z\"b]\n+Wj\u001c<fIR!\u00111\u001cBh\u0011\u001d\u00119L!3A\u00029CqAa5S\t\u0013\u0011).A\u000bdQ\u0016\u001c7NR8mI\u0016\u00148)\u00198CK6{g/\u001a3\u0015\r\u0005m'q\u001bBm\u0011\u001d\tIJ!5A\u00029CqAa7\u0003R\u0002\u0007a*A\u0005pa\u0016\u0014\u0018\r^5p]\"9!q\u001c*\u0005\n\t\u0005\u0018AE4fiJ+hN\\5oOJ+G.Z1tKN$BAa9\u0003lB1!q\nB0\u0005K\u00042a\u0018Bt\u0013\r\u0011I\u000f\u0019\u0002\u0016\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016lG)\u0019;b\u0011\u001d\tIJ!8A\u00029CqAa<S\t\u0013\u0011\t0\u0001\nhKR,e.\u00192mK\u0012$&/[4hKJ\u001cH\u0003\u0002Br\u0005gDqA!>\u0003n\u0002\u0007a*\u0001\u0006b]\u000e,7\u000f^8s\u0013\u0012DqA!?S\t\u0013\u0011Y0A\tdQ\u0016\u001c7NT1nK&\u001bXK\\5rk\u0016$b!a7\u0003~\n}\bbBAs\u0005o\u0004\rA\u0014\u0005\b\u0007\u0003\u00119\u00101\u0001O\u0003\u0015!\u0018\u000e\u001e7f\u0011\u001d\u0019)A\u0015C\u0005\u0007\u000f\tACZ5oIN+(MZ8mI\u0016\u0014()\u001f+ji2,GCBB\u0005\u0007\u0017\u0019i\u0001E\u0003\u0014\u0003k\u000bI\tC\u0004\u0002f\u000e\r\u0001\u0019\u0001(\t\u000f\r\u000511\u0001a\u0001\u001d\"I1\u0011\u0003*\u0012\u0002\u0013\u000511C\u0001\u0013M&tGMQ=JI\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\u0016)\"\u00111WB\fW\t\u0019I\u0002\u0005\u0003\u0004\u001c\r\rRBAB\u000f\u0015\u0011\u0019yb!\t\u0002\u0013Ut7\r[3dW\u0016$'bAA7)%!1QEB\u000f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0004%\u000e%\u0002\u0003BB\u0016\u0007ci!a!\f\u000b\t\r=\u0012qO\u0001\u000bgR,'/Z8usB,\u0017\u0002BB\u001a\u0007[\u0011!BU3q_NLGo\u001c:z\u0001")
public class Folders
implements Logging {
    private final RepositoryService repositoryService;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    public final InternalMetadataDecoratorService com$xebialabs$xlrelease$folder$repository$Folders$$decoratorService;
    private final Teams teams;
    private final RepositoryQueries repositoryQueries;
    private final XLReleaseEventBus eventBus;
    private final XlrRepository xlrRepository;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public static Set<String> ACTIVE_STATUSES_SET() {
        return Folders$.MODULE$.ACTIVE_STATUSES_SET();
    }

    public static String PROPERTY_ENABLED() {
        return Folders$.MODULE$.PROPERTY_ENABLED();
    }

    public static String PROPERTY_STATUS() {
        return Folders$.MODULE$.PROPERTY_STATUS();
    }

    public static long DEFAULT_RESULTS_PER_PAGE() {
        return Folders$.MODULE$.DEFAULT_RESULTS_PER_PAGE();
    }

    public static long DEFAULT_PAGE() {
        return Folders$.MODULE$.DEFAULT_PAGE();
    }

    public static int DEPTH_FOLDER_WITH_PERMISSIONS() {
        return Folders$.MODULE$.DEPTH_FOLDER_WITH_PERMISSIONS();
    }

    public static int DEFAULT_DEPTH() {
        return Folders$.MODULE$.DEFAULT_DEPTH();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Folders folders = this;
        synchronized (folders) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, (Marker)mkr, msg, t);
    }

    public Folder findById(String folderId, Optional<Object> depth) {
        return this.findById(folderId, (Option<Object>)Option$.MODULE$.apply(depth.orElse(BoxesRunTime.boxToInteger((int)Folders$.MODULE$.DEPTH_FOLDER_WITH_PERMISSIONS()))));
    }

    /*
     * WARNING - void declaration
     */
    public Folder findById(String folderId, Option<Object> depth) {
        void var3_3;
        Folder folder = (Folder)this.repositoryService.read(folderId, BoxesRunTime.unboxToInt((Object)depth.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Folders$.MODULE$.DEPTH_FOLDER_WITH_PERMISSIONS();
            }
        })));
        this.com$xebialabs$xlrelease$folder$repository$Folders$$decoratorService.decorate((ConfigurationItem)folder, JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))));
        return var3_3;
    }

    public Option<Object> findById$default$2() {
        return None$.MODULE$;
    }

    public Folder findByPath(String path, Optional<Object> depth) {
        return this.findById(path, (Option<Object>)Option$.MODULE$.apply(depth.orElse(BoxesRunTime.boxToInteger((int)Folders$.MODULE$.DEFAULT_DEPTH()))));
    }

    public Folder findByPath(String path, Option<Object> depth) {
        String foundFolderId = this.findIdByPath(path);
        return (Folder)this.repositoryService.read(foundFolderId, BoxesRunTime.unboxToInt((Object)depth.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Folders$.MODULE$.DEFAULT_DEPTH();
            }
        })));
    }

    public String findIdByPath(String path) {
        String foundFolderId;
        if (Strings.isEmpty((String)path)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find folder by empty path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), new Object[0]);
        }
        String pathFromRoot = path.startsWith("/") ? path.substring(1) : path;
        this.logger().debug((Function0)new Serializable(this, pathFromRoot){
            public static final long serialVersionUID = 0L;
            private final String pathFromRoot$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finding folder by path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathFromRoot$1}));
            }
            {
                this.pathFromRoot$1 = pathFromRoot$1;
            }
        });
        String[] pathElements = pathFromRoot.split("/");
        String string = foundFolderId = (String)Predef$.MODULE$.refArrayOps((Object[])pathElements).foldLeft((Object)Folder.ROOT_FOLDER_ID, (Function2)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Folders $outer;
            public final String path$1;

            public final String apply(String folderId, String pathElement) {
                String string;
                if (Strings.isEmpty((String)pathElement)) {
                    string = folderId;
                } else {
                    Option<Folder> childByName = this.$outer.com$xebialabs$xlrelease$folder$repository$Folders$$findSubfolderByTitle(folderId, pathElement);
                    string = (String)childByName.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Folder x$2) {
                            return x$2.getId();
                        }
                    }).getOrElse((Function0)new Serializable(this, pathElement){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$6 $outer;
                        private final String pathElement$1;

                        public final Nothing$ apply() {
                            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find folder [", "] in path [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathElement$1, this.$outer.path$1})), new Object[0]);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.pathElement$1 = pathElement$1;
                        }
                    });
                }
                return string;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.path$1 = path$1;
            }
        });
        String string2 = Folder.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("No folder path specified, the root path is not supported");
        }
        return foundFolderId;
    }

    private void createDefaultTeams(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = this.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions(XLReleasePermissions.getFolderPermissions());
        Team templateOwner = this.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        Team releaseAdmin = this.newTeam$1();
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.setPermissions(XLReleasePermissions.getReleasePermissions());
        releaseAdmin.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        this.teams.saveTeamsToPlatform(folder.getId(), JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{folderOwner, templateOwner, releaseAdmin}))));
    }

    public Folder create(String parentId, Folder folder) {
        this.checkFolderExists(parentId);
        this.checkNameIsUnique(parentId, folder.getTitle());
        this.logger().info((Function0)new Serializable(this, folder){
            public static final long serialVersionUID = 0L;
            private final Folder folder$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.folder$1.getTitle()}));
            }
            {
                this.folder$1 = folder$1;
            }
        });
        if (!Ids.isNullId((String)folder.getId()) && Ids.isFolderId((String)folder.getId())) {
            folder.setId(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentId, Ids.getName((String)folder.getId())})));
        } else {
            folder.setId(this.ciIdService.getGloballyUniqueId(Type.valueOf(Folder.class), parentId));
        }
        this.repositoryService.create((ConfigurationItem[])new Folder[]{folder});
        String string = parentId;
        String string2 = Folder.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.createDefaultTeams(folder, parentId);
        }
        return folder;
    }

    public void delete(String folderId) {
        String string = Folder.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, "delete");
        this.logger().info((Function0)new Serializable(this, folderId){
            public static final long serialVersionUID = 0L;
            private final String folderId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.folderId$1}));
            }
            {
                this.folderId$1 = folderId$1;
            }
        });
        this.xlrRepository.handle((XlrRepositoryCommand)new ReleasesDeleteUnderFolderCommand(folderId));
        this.repositoryService.delete(new String[]{folderId});
    }

    public Folder rename(String folderId, String newName) {
        String string = Folder.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        this.checkNameIsUnique(Ids.getParentId((String)folderId), newName);
        Folder folder = (Folder)this.repositoryService.read(folderId, 1);
        this.logger().info((Function0)new Serializable(this, folderId, newName, folder){
            public static final long serialVersionUID = 0L;
            private final String folderId$3;
            private final String newName$1;
            private final Folder folder$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Renaming folder ", " from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.folderId$3, this.folder$2.getTitle(), this.newName$1}));
            }
            {
                this.folderId$3 = folderId$3;
                this.newName$1 = newName$1;
                this.folder$2 = folder$2;
            }
        });
        folder.setTitle(newName);
        this.repositoryService.update((ConfigurationItem[])new Folder[]{folder});
        return folder;
    }

    public Folder move(String folderId, String newParentId) {
        String string = Folder.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkFolderCanBeMoved(folderId, "move");
        Folder folder = (Folder)this.repositoryService.read(folderId, 1);
        this.checkNameIsUnique(newParentId, folder.getTitle());
        String newId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newParentId, Ids.getName((String)folderId)}));
        this.logger().info((Function0)new Serializable(this, folderId, newParentId, newId){
            public static final long serialVersionUID = 0L;
            private final String folderId$4;
            private final String newParentId$1;
            private final String newId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Moving '", "' under: '", "' with new id: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.folderId$4, this.newParentId$1, this.newId$1}));
            }
            {
                this.folderId$4 = folderId$4;
                this.newParentId$1 = newParentId$1;
                this.newId$1 = newId$1;
            }
        });
        this.repositoryService.move(folderId, newId);
        return (Folder)this.repositoryService.read(newId, 1);
    }

    public List<Folder> listFolders(Option<String> parentId, Option<Object> page, Option<Object> resultPerPage, Option<Object> depth, Option<Object> decorateWithPermissions) {
        parentId.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Folders $outer;

            public final void apply(String folderId) {
                this.$outer.checkFolderExists(folderId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.logger().debug((Function0)new Serializable(this, parentId, page, resultPerPage){
            public static final long serialVersionUID = 0L;
            private final Option parentId$1;
            private final Option page$1;
            private final Option resultPerPage$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing folders in parent: ", ", page: ", ", resultPerPage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentId$1, this.page$1, this.resultPerPage$1}));
            }
            {
                this.parentId$1 = parentId$1;
                this.page$1 = page$1;
                this.resultPerPage$1 = resultPerPage$1;
            }
        });
        QueryTemplate query = this.listSubfoldersQuery(parentId);
        query.setPage(BoxesRunTime.unboxToLong((Object)page.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Folders$.MODULE$.DEFAULT_PAGE();
            }
        })));
        query.setResultsPerPage(BoxesRunTime.unboxToLong((Object)resultPerPage.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Folders$.MODULE$.DEFAULT_RESULTS_PER_PAGE();
            }
        })));
        query.setDepth(BoxesRunTime.unboxToInt((Object)depth.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Folders$.MODULE$.DEFAULT_DEPTH();
            }
        })));
        List folders = this.repositoryService.listEntities(query);
        return BoxesRunTime.unboxToBoolean((Object)decorateWithPermissions.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        })) ? JavaConversions$.MODULE$.seqAsJavaList(this.decorateFolderPermissions((Seq<Folder>)JavaConversions$.MODULE$.asScalaBuffer(folders))) : folders;
    }

    public QueryTemplate listSubfoldersQuery(Option<String> parentId) {
        return this.repositoryQueries.listSubfoldersQuery((String)parentId.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return Folder.ROOT_FOLDER_ID;
            }
        }));
    }

    public Seq<Folder> decorateFolderPermissions(Seq<Folder> folders) {
        return (Seq)folders.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Folders $outer;

            public final Folder apply(Folder folder) {
                this.$outer.com$xebialabs$xlrelease$folder$repository$Folders$$decoratorService.decorate((ConfigurationItem)folder, JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))));
                this.$outer.decorateFolderPermissions((Seq<Folder>)JavaConversions$.MODULE$.asScalaSet(folder.getChildren()).toSeq());
                return folder;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public List<Release> searchTemplates(String folderId, Option<Object> page, Option<Object> resultPerPage, Option<Object> depth) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        ReleaseSearchResult results = this.releaseSearchService.searchTemplates(filters, BoxesRunTime.unboxToLong((Object)page.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Folders$.MODULE$.DEFAULT_PAGE();
            }
        })), BoxesRunTime.unboxToLong((Object)resultPerPage.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Folders$.MODULE$.DEFAULT_RESULTS_PER_PAGE();
            }
        })), BoxesRunTime.unboxToInt((Object)depth.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Folders$.MODULE$.DEFAULT_DEPTH();
            }
        })));
        return results.getReleases();
    }

    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Option<Object> page, Option<Object> resultsPerPage, Option<Object> depth) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, BoxesRunTime.unboxToLong((Object)page.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Folders$.MODULE$.DEFAULT_PAGE();
            }
        })), BoxesRunTime.unboxToLong((Object)resultsPerPage.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Folders$.MODULE$.DEFAULT_RESULTS_PER_PAGE();
            }
        })), BoxesRunTime.unboxToInt((Object)depth.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Folders$.MODULE$.DEFAULT_DEPTH();
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    public String moveTemplate(String folderId, String templateId) {
        void var3_3;
        String newTemplateId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId, Ids.getName((String)templateId)}));
        this.checkTemplateCanBeMoved(templateId);
        this.logger().info((Function0)new Serializable(this, folderId, templateId){
            public static final long serialVersionUID = 0L;
            private final String folderId$5;
            private final String templateId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Moving template ", " into folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.templateId$1, this.folderId$5}));
            }
            {
                this.folderId$5 = folderId$5;
                this.templateId$1 = templateId$1;
            }
        });
        this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseMoveCommand(templateId, newTemplateId));
        this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
        return var3_3;
    }

    public boolean exists(String folderId) {
        return this.repositoryService.exists(folderId);
    }

    public void checkFolderExists(String folderId) {
        if (this.exists(folderId)) {
            return;
        }
        throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Folder '", "' does not exist in the repository"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})), new Object[0]);
    }

    private void checkTemplateCanBeMoved(String templateId) {
        Release template = (Release)this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseGetCommand(templateId, Predef$.MODULE$.int2Integer(2), true, ReleaseGetCommand$.MODULE$.apply$default$4()));
        Buffer enabledTriggers = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(template.getReleaseTriggers()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ReleaseTrigger x$3) {
                return x$3.isEnabled();
            }
        });
        if (enabledTriggers.nonEmpty()) {
            this.logger().warn((Function0)new Serializable(this, templateId, enabledTriggers){
                public static final long serialVersionUID = 0L;
                private final String templateId$2;
                private final Buffer enabledTriggers$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to move template ", " with enabled triggers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.templateId$2, ((TraversableOnce)this.enabledTriggers$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(ReleaseTrigger x$4) {
                            return x$4.getId();
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).mkString(", ")}));
                }
                {
                    this.templateId$2 = templateId$2;
                    this.enabledTriggers$1 = enabledTriggers$1;
                }
            });
            throw new ItemInUseException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You can't move this template because it has one or more enabled triggers: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)enabledTriggers.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ReleaseTrigger x$5) {
                    return x$5.getTitle();
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(", ")}))).toString(), new Object[0]);
        }
    }

    private void checkFolderCanBeMoved(String folderId, String operation) {
        Seq<ConfigurationItemData> activeReleases = this.getRunningReleases(folderId);
        Seq<ConfigurationItemData> enabledTriggers = this.getEnabledTriggers(folderId);
        if (activeReleases.nonEmpty() || enabledTriggers.nonEmpty()) {
            this.logger().warn((Function0)new Serializable(this, folderId, operation, activeReleases, enabledTriggers){
                public static final long serialVersionUID = 0L;
                private final String folderId$2;
                private final String operation$1;
                private final Seq activeReleases$1;
                private final Seq enabledTriggers$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to ", " folder ", ", which has running releases ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.operation$1, this.folderId$2, ((TraversableOnce)this.activeReleases$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(ConfigurationItemData x$6) {
                            return x$6.getId();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or enabled triggers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.enabledTriggers$2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(ConfigurationItemData x$7) {
                            return x$7.getId();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).toString();
                }
                {
                    this.folderId$2 = folderId$2;
                    this.operation$1 = operation$1;
                    this.activeReleases$1 = activeReleases$1;
                    this.enabledTriggers$2 = enabledTriggers$2;
                }
            });
            List releases = this.repositoryService.read(JavaConversions$.MODULE$.seqAsJavaList((Seq)activeReleases.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ConfigurationItemData x$8) {
                    return x$8.getId();
                }
            }, Seq$.MODULE$.canBuildFrom())), 1, true);
            List triggers = this.repositoryService.read(JavaConversions$.MODULE$.seqAsJavaList((Seq)enabledTriggers.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ConfigurationItemData x$9) {
                    return x$9.getId();
                }
            }, Seq$.MODULE$.canBuildFrom())), 2, true);
            String releasesMessage = JavaConversions$.MODULE$.asScalaBuffer(releases).nonEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Active releases: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(releases).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Release x$10) {
                    return x$10.getTitle();
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(", ")})) : "";
            String triggersMessage = JavaConversions$.MODULE$.asScalaBuffer(triggers).nonEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Enabled triggers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(triggers).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ReleaseTrigger t) {
                    return new StringBuilder().append((Object)t.getTemplate().getTitle()).append((Object)"/").append((Object)t.getTitle()).toString();
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(", ")})) : "";
            throw new ItemInUseException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You can't ", " this folder because it has active releases or templates with enabled triggers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation}))).append((Object)releasesMessage).append((Object)triggersMessage).toString(), new Object[0]);
        }
    }

    private Seq<ConfigurationItemData> getRunningReleases(String folderId) {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setType(Type.valueOf(Release.class));
        searchParameters.setAncestor(folderId);
        searchParameters.addOrPropertiesExpression(Folders$.MODULE$.PROPERTY_STATUS(), JavaConversions$.MODULE$.setAsJavaSet(Folders$.MODULE$.ACTIVE_STATUSES_SET()));
        return JavaConversions$.MODULE$.asScalaBuffer(this.repositoryService.list(searchParameters));
    }

    private Seq<ConfigurationItemData> getEnabledTriggers(String ancestorId) {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setType(Type.valueOf(ReleaseTrigger.class));
        searchParameters.setAncestor(ancestorId);
        searchParameters.addProperty(Folders$.MODULE$.PROPERTY_ENABLED(), "true");
        return JavaConversions$.MODULE$.asScalaBuffer(this.repositoryService.list(searchParameters));
    }

    private void checkNameIsUnique(String parentId, String title) {
        if (this.com$xebialabs$xlrelease$folder$repository$Folders$$findSubfolderByTitle(parentId, title).isDefined()) {
            throw new ItemConflictException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Folder with title '", "' already exists under folder by ID '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{title, parentId})), new Object[0]);
        }
    }

    public Option<Folder> com$xebialabs$xlrelease$folder$repository$Folders$$findSubfolderByTitle(String parentId, String title) {
        int depthFoldersWithTitles = 1;
        SearchParameters subfolderByNameQuery = new SearchParameters().setType(Type.valueOf(Folder.class)).setParent(parentId).setDepth(depthFoldersWithTitles).addProperty("title", title);
        List childrenByName = this.repositoryService.listEntities(subfolderByNameQuery);
        return JavaConversions$.MODULE$.asScalaBuffer(childrenByName).headOption();
    }

    private final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    @Autowired
    public Folders(RepositoryService repositoryService, CiIdService ciIdService, ReleaseSearchService releaseSearchService, InternalMetadataDecoratorService decoratorService, PermissionChecker permissions, Teams teams, Tasks tasks, RepositoryQueries repositoryQueries, XLReleaseEventBus eventBus, XlrRepository xlrRepository) {
        this.repositoryService = repositoryService;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.com$xebialabs$xlrelease$folder$repository$Folders$$decoratorService = decoratorService;
        this.teams = teams;
        this.repositoryQueries = repositoryQueries;
        this.eventBus = eventBus;
        this.xlrRepository = xlrRepository;
        Logging.class.$init$((Logging)this);
    }
}

