/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.TeamFacade;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.folder.repository.Folders;
import com.xebialabs.xlrelease.folder.service.FolderSearchService;
import com.xebialabs.xlrelease.folder.service.FolderService;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Option;

@Api(value="folders", description="Folders API")
@Path(value="/api/v1/folders")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@AllCILevels
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class FolderApi
implements ApiService {
    private final String EXPRESSION_FOLDER_ID = "/{folderId:.*(Folder[^/]*|Applications)}";
    private final Folders folders;
    private final FolderSearchService folderSearchService;
    private final PermissionChecker permissions;
    private final FolderService folderService;
    private TeamFacade teamFacade;

    @Autowired
    public FolderApi(Folders folders, FolderSearchService folderSearchService, PermissionChecker permissions, FolderService folderService, TeamFacade teamFacade) {
        this.folders = folders;
        this.folderSearchService = folderSearchService;
        this.permissions = permissions;
        this.folderService = folderService;
        this.teamFacade = teamFacade;
    }

    public String serviceName() {
        return "folderApi";
    }

    @GET
    @Path(value="/list")
    @ApiOperation(value="Returns a list of folders in the root directory", response=Folder.class, responseContainer="List")
    @PublicApiMember
    public List<Folder> listRoot(@QueryParam(value="page") @ApiParam(value="The (optional) page of results to return; defaults at 0") Long page, @QueryParam(value="resultsPerPage") @ApiParam(value="The (optional) the number of results per page; defaults at 50") Long resultPerPage, @QueryParam(value="depth") @ApiParam(value="The (optional) depth to search for; defaults at 1") Integer depth, @QueryParam(value="permissions") @ApiParam(value="The (optional) boolean to decorate the folders with the effective permissions; defaults with false") Boolean decorateWithPermissions) {
        return this.folderSearchService.listViewableFolders((Option<String>)Option.empty(), (Option<Object>)Option.apply((Object)page), (Option<Object>)Option.apply((Object)resultPerPage), (Option<Object>)Option.apply((Object)depth), (Option<Object>)Option.apply((Object)decorateWithPermissions));
    }

    @PublicApiMember
    public List<Folder> listRoot() {
        return this.listRoot(null, null, null, null);
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/list")
    @ApiOperation(value="Returns a list of folders inside a folder", response=Folder.class, responseContainer="List")
    @PublicApiMember
    public List<Folder> list(@PathParam(value="folderId") @ApiParam(value="The parent folder to retrieve from") String parentId, @QueryParam(value="page") @ApiParam(value="The (optional) page of results to return; defaults at 0") Long page, @QueryParam(value="resultsPerPage") @ApiParam(value="The (optional) the number of results per page; defaults at 50") Long resultPerPage, @QueryParam(value="depth") @ApiParam(value="The (optional) depth to search for; defaults at 1") Integer depth, @QueryParam(value="permissions") @ApiParam(value="The (optional) boolean to decorate the folders with the effective permissions; defaults with false") Boolean decorateWithPermissions) {
        return this.folderSearchService.listViewableFolders((Option<String>)Option.apply((Object)parentId), (Option<Object>)Option.apply((Object)page), (Option<Object>)Option.apply((Object)resultPerPage), (Option<Object>)Option.apply((Object)depth), (Option<Object>)Option.apply((Object)decorateWithPermissions));
    }

    @GET
    @Path(value="/find")
    @ApiOperation(value="Finds a folder from a given path", response=Folder.class)
    @PublicApiMember
    public Folder find(@QueryParam(value="byPath") @ApiParam(value="The path for the folder to search on") String path, @QueryParam(value="depth") @ApiParam(value="The (optional) depth to search for; defaults at 1") Integer depth) {
        String folderId = this.folders.findIdByPath(path);
        return this.getFolder(folderId, depth);
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}")
    @ApiOperation(value="Returns a folder", response=Folder.class)
    @PublicApiMember
    public Folder getFolder(@PathParam(value="folderId") @ApiParam(value="The id of the folder") String folderId, @QueryParam(value="depth") @ApiParam(value="The (optional) depth to search for; defaults at 1") Integer depth) {
        this.permissions.check(XLReleasePermissions.VIEW_FOLDER, folderId);
        return this.folders.findById(folderId, (Option<Object>)Option.apply((Object)depth));
    }

    @PublicApiMember
    public Folder getFolder(String folderId) {
        return this.getFolder(folderId, null);
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/templates")
    @ApiOperation(value="Returns a list of templates from folder", response=Release.class, responseContainer="List")
    @PublicApiMember
    public List<Release> getTemplates(@PathParam(value="folderId") @ApiParam(value="The id of the folder") String folderId, @QueryParam(value="page") @ApiParam(value="The (optional) page of results to return; defaults at 0") Long page, @QueryParam(value="resultsPerPage") @ApiParam(value="The (optional) the number of results per page; defaults at 50") Long resultPerPage, @QueryParam(value="depth") @ApiParam(value="The (optional) depth to search for; defaults at 1") Integer depth) {
        this.permissions.checkViewFolder(folderId);
        this.permissions.check(XLReleasePermissions.VIEW_TEMPLATE, folderId);
        return this.folders.searchTemplates(folderId, (Option<Object>)Option.apply((Object)page), (Option<Object>)Option.apply((Object)resultPerPage), (Option<Object>)Option.apply((Object)depth));
    }

    @PublicApiMember
    public List<Release> getTemplates(String folderId) {
        return this.getTemplates(folderId, null, null, null);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/releases")
    @ApiOperation(value="Searches for releases started from the folder", response=Release.class, responseContainer="List")
    @PublicApiMember
    public List<Release> searchReleases(@PathParam(value="folderId") @ApiParam(value="The id of the folder") String folderId, @QueryParam(value="page") @ApiParam(value="The (optional) page of results to return; defaults at 0") Long page, @QueryParam(value="numberbypage") @ApiParam(value="The (optional) number of results per page. Defaults at 50") Long resultPerPage, @QueryParam(value="depth") @ApiParam(value="The (optional) depth to search for; defaults at 1") Integer depth, ReleasesFilters releasesFilters) {
        this.permissions.checkViewFolder(folderId);
        this.permissions.check(XLReleasePermissions.VIEW_RELEASE, folderId);
        return this.folders.searchReleases(folderId, releasesFilters, (Option<Object>)Option.apply((Object)page), (Option<Object>)Option.apply((Object)resultPerPage), (Option<Object>)Option.apply((Object)depth)).getReleases();
    }

    @PublicApiMember
    public List<Release> searchReleases(String folderId, ReleasesFilters releasesFilters) {
        return this.searchReleases(folderId, null, null, null, releasesFilters);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/templates/{templateId:.*Release[^/]*}")
    @ApiOperation(value="Moves a template to another folder")
    @PublicApiMember
    public void moveTemplate(@PathParam(value="folderId") @ApiParam(value="The target folder the template will be moved to") String folderId, @ApiParam(value="The id of the template to be moved") @PathParam(value="templateId") String templateId, @ApiParam(value="The (optional) boolean value of whether to merge teams/permissions") @QueryParam(value="mergePermissions") Boolean mergeTeams) {
        this.permissions.checkEdit(templateId);
        this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, folderId);
        boolean shouldMergeTeams = Optional.ofNullable(mergeTeams).orElse(false);
        if (shouldMergeTeams) {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER_SECURITY, folderId);
        }
        this.folderService.moveTemplate(folderId, templateId, shouldMergeTeams);
    }

    @PublicApiMember
    public void moveTemplate(String folderId, String templateId) {
        this.moveTemplate(folderId, templateId, null);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}")
    @ApiOperation(value="Adds a new folder", response=Folder.class)
    @PublicApiMember
    public Folder addFolder(@PathParam(value="folderId") @ApiParam(value="The id of the folder to create the folder in") String parentId, @ApiParam(value="The folder to create the new folder in") Folder folder) {
        if (Folder.ROOT_FOLDER_ID.equals(parentId)) {
            this.permissions.check(XLReleasePermissions.CREATE_TOP_LEVEL_FOLDER);
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER, parentId);
        }
        return this.folders.create(parentId, folder);
    }

    @DELETE
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}")
    @ApiOperation(value="Deletes a folder")
    @PublicApiMember
    public void delete(@PathParam(value="folderId") @ApiParam(value="The id of the folder to delete") String folderId) {
        Checks.checkArgument((!Folder.ROOT_FOLDER_ID.equals(folderId) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, folderId);
        this.folders.delete(folderId);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/move")
    @ApiOperation(value="Moves a folder inside another folder", response=Folder.class)
    @PublicApiMember
    public void move(@PathParam(value="folderId") @ApiParam(value="The id of the folder to move") String folderId, @QueryParam(value="newParentId") @ApiParam(value="The id of the parent folder the folder will be moved under") String newParentId) {
        Checks.checkArgument((!Folder.ROOT_FOLDER_ID.equals(folderId) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, folderId);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, newParentId);
        this.folders.move(folderId, newParentId);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/rename")
    @ApiOperation(value="Renames a folder")
    @PublicApiMember
    public void rename(@PathParam(value="folderId") @ApiParam(value="The id of the folder to rename") String folderId, @QueryParam(value="newName") @ApiParam(value="The new name of the folder") String newName) {
        Checks.checkArgument((!Folder.ROOT_FOLDER_ID.equals(folderId) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, folderId);
        this.folders.rename(folderId, newName);
    }

    @GET
    @Path(value="/permissions")
    @PublicApiMember
    public List<String> getPermissions() {
        ArrayList<String> folderPermissions = new ArrayList<String>();
        folderPermissions.addAll(XLReleasePermissions.getFolderPermissions());
        folderPermissions.addAll(XLReleasePermissions.getTemplatePermissions());
        return folderPermissions;
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams")
    @ApiOperation(value="Returns effective teams of the folder")
    @PublicApiMember
    public List<TeamView> getTeams(@PathParam(value="folderId") String folderId) {
        return this.teamFacade.getTeams(folderId);
    }

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams")
    @ApiOperation(value="Sets teams, team members and permissions of the folder")
    @PublicApiMember
    public List<TeamView> setTeams(@PathParam(value="folderId") String folderId, List<TeamView> teamDtos) {
        return this.teamFacade.setTeams(folderId, teamDtos);
    }
}

