/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.type;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.cli.type.ValueType;

public class ValueTypeFactory {
    public static final ValueTypeFactory DEFAULT = new ValueTypeFactory();
    private final ValueType<?>[] types;

    private ValueTypeFactory() {
        this.types = new ValueType[]{ValueType.STRING, ValueType.INTEGER, ValueType.BOOLEAN, ValueType.ENUM, ValueType.PROPERTIES, ValueType.OBJECT_NAME, ValueType.THREAD, ValueType.FILE};
    }

    public ValueTypeFactory(ClassLoader loader) throws NullPointerException {
        if (loader == null) {
            throw new NullPointerException("No null loader accepted");
        }
        LinkedHashSet<ValueType> types = new LinkedHashSet<ValueType>();
        Collections.addAll(types, ValueTypeFactory.DEFAULT.types);
        Iterator<ValueType> sl = ServiceLoader.load(ValueType.class, loader).iterator();
        while (sl.hasNext()) {
            try {
                ValueType type = sl.next();
                types.add(type);
            }
            catch (ServiceConfigurationError e) {
                Logger logger = Logger.getLogger(ValueTypeFactory.class.getName());
                logger.log(Level.WARNING, "Could not load value type factory", e);
            }
        }
        this.types = types.toArray(new ValueType[types.size()]);
    }

    public <T, S extends T> ValueType<T> get(Class<S> clazz) {
        ValueType<S> bestType = null;
        int bestDegree = Integer.MAX_VALUE;
        for (ValueType<S> valueType : this.types) {
            int degree = valueType.getDistance(clazz);
            if (degree == -1 || degree >= bestDegree) continue;
            bestType = valueType;
            bestDegree = degree;
        }
        return bestType;
    }
}

