/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.transport;

import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.smbj.common.SMBBuffer;
import com.hierynomus.smbj.transport.TransportException;
import com.hierynomus.smbj.transport.TransportLayer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTransport
implements TransportLayer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected InputStream in;
    protected OutputStream out;
    private final ReentrantLock writeLock = new ReentrantLock();

    @Override
    public void init(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public void write(SMB2Packet packet) throws TransportException {
        this.logger.trace("Acquiring write lock to send packet << {} >>", (Object)packet.getHeader().getMessage());
        this.writeLock.lock();
        try {
            try {
                SMBBuffer buffer = new SMBBuffer();
                packet.write(buffer);
                this.logger.debug("Writing packet << {} >>, sequence number << {} >>", (Object)packet.getHeader().getMessage(), (Object)packet.getSequenceNumber());
                this.doWrite(buffer);
                this.out.flush();
            }
            catch (IOException ioe) {
                throw new TransportException(ioe);
            }
        }
        finally {
            this.writeLock.unlock();
            this.logger.trace("Packet << {} >> sent, lock released.", (Object)packet.getHeader().getMessage());
        }
    }

    protected abstract void doWrite(SMBBuffer var1) throws IOException;
}

