/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.messages.SMB2ReadRequest;
import com.hierynomus.mssmb2.messages.SMB2ReadResponse;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.ProgressListener;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.connection.NegotiatedProtocol;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.File;
import com.hierynomus.smbj.share.TreeConnect;
import com.hierynomus.smbj.transport.TransportException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInputStream
extends InputStream {
    protected TreeConnect treeConnect;
    private Session session;
    private Connection connection;
    private SMB2FileId fileId;
    private long offset = 0L;
    private int curr = 0;
    private byte[] buf;
    private ProgressListener progressListener;
    private boolean isClosed;
    private Future<SMB2ReadResponse> nextResponse;
    private static final Logger logger = LoggerFactory.getLogger(FileInputStream.class);

    public FileInputStream(File file, ProgressListener progressListener) {
        this.treeConnect = file.treeConnect;
        this.fileId = file.fileId;
        this.session = this.treeConnect.getSession();
        this.connection = this.session.getConnection();
        this.progressListener = progressListener;
    }

    @Override
    public int read() throws IOException {
        if (this.buf == null || this.curr >= this.buf.length) {
            this.loadBuffer();
        }
        if (this.isClosed) {
            return -1;
        }
        ++this.curr;
        return this.buf[this.curr - 1] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buf == null || this.curr >= this.buf.length) {
            this.loadBuffer();
        }
        if (this.isClosed) {
            return -1;
        }
        int l = this.buf.length - this.curr > len ? len : this.buf.length - this.curr;
        System.arraycopy(this.buf, this.curr, b, off, l);
        this.curr += l;
        return l;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.session = null;
        this.connection = null;
        this.buf = null;
    }

    @Override
    public int available() throws IOException {
        throw new IOException("Available not supported");
    }

    private void loadBuffer() throws IOException {
        SMB2ReadResponse res;
        if (this.nextResponse == null) {
            this.nextResponse = this.sendRequest();
        }
        if ((res = Futures.get(this.nextResponse, TransportException.Wrapper)).getHeader().getStatus() == NtStatus.STATUS_SUCCESS) {
            this.buf = res.getData();
            this.curr = 0;
            this.offset += (long)res.getDataLength();
            if (this.progressListener != null) {
                this.progressListener.onProgressChanged(this.offset, -1L);
            }
        }
        if (res.getHeader().getStatus() == NtStatus.STATUS_END_OF_FILE) {
            logger.debug("EOF, {} bytes read", (Object)this.offset);
            this.isClosed = true;
            return;
        }
        if (res.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
            throw new SMBApiException(res.getHeader(), "Read failed for " + this);
        }
        this.nextResponse = this.sendRequest();
    }

    private Future<SMB2ReadResponse> sendRequest() throws IOException {
        NegotiatedProtocol negotiatedProtocol = this.connection.getNegotiatedProtocol();
        SMB2ReadRequest rreq = new SMB2ReadRequest(negotiatedProtocol.getDialect(), this.fileId, this.session.getSessionId(), this.treeConnect.getTreeId(), this.offset, negotiatedProtocol.getMaxReadSize());
        return this.session.send(rreq);
    }
}

