/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.connection;

import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.protocol.commons.concurrent.Promise;
import com.hierynomus.smbj.common.SMBRuntimeException;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Request {
    private final Promise<SMB2Packet, SMBRuntimeException> promise;
    private final long messageId;
    private final UUID cancelId;
    private SMB2Packet requestPacket;
    private final Date timestamp;
    private long asyncId;

    public long getAsyncId() {
        return this.asyncId;
    }

    public void setAsyncId(long asyncId) {
        this.asyncId = asyncId;
    }

    public Request(long messageId, UUID cancelId, SMB2Packet requestPacket) {
        this.messageId = messageId;
        this.cancelId = cancelId;
        this.requestPacket = requestPacket;
        this.timestamp = new Date();
        this.promise = new Promise(String.valueOf(messageId), SMBRuntimeException.Wrapper);
    }

    Promise<SMB2Packet, SMBRuntimeException> getPromise() {
        return this.promise;
    }

    SMB2Packet getRequestPacket() {
        return this.requestPacket;
    }

    long getMessageId() {
        return this.messageId;
    }

    <T extends SMB2Packet> Future<T> getFuture(final CancelCallback callback) {
        return new Future<T>(){
            private final Logger logger = LoggerFactory.getLogger(Request.class);
            private final AtomicBoolean cancelled = new AtomicBoolean(false);
            private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                this.lock.writeLock().lock();
                try {
                    if (this.isDone() || this.cancelled.getAndSet(true)) {
                        boolean bl = false;
                        return bl;
                    }
                    callback.cancel(Request.this.messageId);
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable t) {
                    this.cancelled.set(false);
                    throw SMBRuntimeException.Wrapper.wrap(t);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }

            @Override
            public boolean isCancelled() {
                this.lock.readLock().lock();
                try {
                    boolean bl = this.cancelled.get();
                    return bl;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }

            @Override
            public boolean isDone() {
                this.lock.readLock().lock();
                try {
                    boolean bl = this.cancelled.get() || Request.this.promise.isDelivered();
                    return bl;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                this.logger.debug("Retrieving value for Future << {} >>", (Object)Request.this.messageId);
                return (SMB2Packet)Request.this.promise.retrieve();
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return (SMB2Packet)Request.this.promise.retrieve(timeout, unit);
            }
        };
    }

    UUID getCancelId() {
        return this.cancelId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    static interface CancelCallback {
        public void cancel(long var1);
    }
}

