/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.mssmb2.messages;

import com.hierynomus.msfscc.FileInformationClass;
import com.hierynomus.mssmb2.SMB2Dialect;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2MessageCommandCode;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.smbj.common.SMBBuffer;
import java.util.EnumSet;

public class SMB2QueryDirectoryRequest
extends SMB2Packet {
    long MAX_OUTPUT_BUFFER_LENGTH = 65536L;
    private FileInformationClass fileInformationClass;
    private final EnumSet<SMB2QueryDirectoryFlags> flags;
    private final long fileIndex;
    private final SMB2FileId fileId;
    private final String searchPattern;

    public SMB2QueryDirectoryRequest(SMB2Dialect smbDialect, long sessionId, long treeId, SMB2FileId fileId, FileInformationClass fileInformationClass, EnumSet<SMB2QueryDirectoryFlags> flags, long fileIndex, String searchPattern) {
        super(33, smbDialect, SMB2MessageCommandCode.SMB2_QUERY_DIRECTORY, sessionId, treeId);
        this.fileInformationClass = fileInformationClass;
        this.flags = flags;
        this.fileIndex = fileIndex;
        this.fileId = fileId;
        this.searchPattern = searchPattern == null ? "*" : searchPattern;
    }

    @Override
    protected void writeTo(SMBBuffer buffer) {
        buffer.putUInt16(this.structureSize);
        buffer.putByte((byte)this.fileInformationClass.getValue());
        buffer.putByte((byte)EnumWithValue.EnumUtils.toLong(this.flags));
        buffer.putUInt32(this.fileIndex);
        this.fileId.write(buffer);
        int offset = 96;
        buffer.putUInt16(offset);
        buffer.putUInt16(this.searchPattern.length() * 2);
        buffer.putUInt32(this.MAX_OUTPUT_BUFFER_LENGTH);
        buffer.putString(this.searchPattern);
    }

    public static enum SMB2QueryDirectoryFlags implements EnumWithValue<SMB2QueryDirectoryFlags>
    {
        SMB2_RESTART_SCANS(1L),
        SMB2_RETURN_SINGLE_ENTRY(2L),
        SMB2_INDEX_SPECIFIED(4L),
        SMB2_REOPEN(16L);

        private long value;

        private SMB2QueryDirectoryFlags(long value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }
}

