/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdtyp.ace;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msdtyp.SID;
import com.hierynomus.msdtyp.ace.ACE;
import com.hierynomus.msdtyp.ace.AceFlags;
import com.hierynomus.msdtyp.ace.AceObjectFlags;
import com.hierynomus.msdtyp.ace.AceType;
import com.hierynomus.msdtyp.ace.AceType1;
import com.hierynomus.msdtyp.ace.AceType2;
import com.hierynomus.msdtyp.ace.AceType3;
import com.hierynomus.msdtyp.ace.AceType4;
import java.util.EnumSet;
import java.util.UUID;

public class AceTypes {
    private AceTypes() {
    }

    public static ACE accessAllowedAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, SID sid) {
        return new AceType1(AceType.ACCESS_ALLOWED_ACE_TYPE, aceFlags, accessMask, sid);
    }

    public static ACE accessAllowedObjectAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, EnumSet<AceObjectFlags> flags, UUID objectType, UUID inheritedObjectType, SID sid) {
        return new AceType2(AceType.ACCESS_ALLOWED_OBJECT_ACE_TYPE, aceFlags, accessMask, flags, objectType, inheritedObjectType, sid);
    }

    public static ACE accessDeniedAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, SID sid) {
        return new AceType1(AceType.ACCESS_DENIED_ACE_TYPE, aceFlags, accessMask, sid);
    }

    public static ACE accessDeniedObjectAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, EnumSet<AceObjectFlags> flags, UUID objectType, UUID inheritedObjectType, SID sid) {
        return new AceType2(AceType.ACCESS_DENIED_OBJECT_ACE_TYPE, aceFlags, accessMask, flags, objectType, inheritedObjectType, sid);
    }

    public static ACE accessAllowedCallbackAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, SID sid, byte[] applicationData) {
        return new AceType3(AceType.ACCESS_ALLOWED_CALLBACK_ACE_TYPE, aceFlags, accessMask, sid, applicationData);
    }

    public static ACE accessDeniedCallbackAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, SID sid, byte[] applicationData) {
        return new AceType3(AceType.ACCESS_DENIED_CALLBACK_ACE_TYPE, aceFlags, accessMask, sid, applicationData);
    }

    public static ACE accessAllowedCallbackObjectAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, EnumSet<AceObjectFlags> flags, UUID objectType, UUID inheritedObjectType, SID sid, byte[] applicationData) {
        return new AceType4(AceType.ACCESS_ALLOWED_CALLBACK_OBJECT_ACE_TYPE, aceFlags, accessMask, flags, objectType, inheritedObjectType, sid, applicationData);
    }

    public static ACE accessDeniedCallbackObjectAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, EnumSet<AceObjectFlags> flags, UUID objectType, UUID inheritedObjectType, SID sid, byte[] applicationData) {
        return new AceType4(AceType.ACCESS_DENIED_CALLBACK_OBJECT_ACE_TYPE, aceFlags, accessMask, flags, objectType, inheritedObjectType, sid, applicationData);
    }

    public static ACE systemAuditAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, SID sid) {
        return new AceType1(AceType.SYSTEM_AUDIT_ACE_TYPE, aceFlags, accessMask, sid);
    }

    public static ACE systemAuditObjectAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, EnumSet<AceObjectFlags> flags, UUID objectType, UUID inheritedObjectType, SID sid, byte[] applicationData) {
        return new AceType4(AceType.SYSTEM_AUDIT_OBJECT_ACE_TYPE, aceFlags, accessMask, flags, objectType, inheritedObjectType, sid, applicationData);
    }

    public static ACE systemAuditCallbackAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, SID sid, byte[] applicationData) {
        return new AceType3(AceType.SYSTEM_AUDIT_CALLBACK_ACE_TYPE, aceFlags, accessMask, sid, applicationData);
    }

    public static ACE systemMandatoryLabelAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, SID sid) {
        return new AceType1(AceType.SYSTEM_MANDATORY_LABEL_ACE_TYPE, aceFlags, accessMask, sid);
    }

    public static ACE systemAuditCallbackObjectAce(EnumSet<AceFlags> aceFlags, EnumSet<AccessMask> accessMask, EnumSet<AceObjectFlags> flags, UUID objectType, UUID inheritedObjectType, SID sid, byte[] applicationData) {
        return new AceType4(AceType.SYSTEM_AUDIT_CALLBACK_OBJECT_ACE_TYPE, aceFlags, accessMask, flags, objectType, inheritedObjectType, sid, applicationData);
    }

    public static ACE systemResourceAttributeAce(EnumSet<AceFlags> aceFlags, byte[] attributeData) {
        return new AceType3(AceType.SYSTEM_RESOURCE_ATTRIBUTE_ACE_TYPE, aceFlags, EnumSet.noneOf(AccessMask.class), SID.EVERYONE, attributeData);
    }

    public static ACE systemScopedPolicyIdAce(EnumSet<AceFlags> aceFlags, SID sid) {
        return new AceType1(AceType.SYSTEM_SCOPED_POLICY_ID_ACE_TYPE, aceFlags, EnumSet.noneOf(AccessMask.class), sid);
    }
}

