/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.smb;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.smbj.Config;
import com.hierynomus.smbj.DefaultConfig;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.Share;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.proxy.ProxyConnection;
import com.xebialabs.overthere.smb.SmbConnectionBuilder;
import com.xebialabs.overthere.smb.SmbFile;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbConnection
extends BaseOverthereConnection {
    private final SMBClient client;
    private final String hostname;
    private final int smbPort;
    private Connection connection;
    private Session session;
    private int port;
    protected final String password;
    protected CifsConnectionType cifsConnectionType;
    protected final String username;
    private static Logger logger;

    protected SmbConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper, boolean canStartProcess) {
        super(protocol, options, mapper, canStartProcess);
        this.cifsConnectionType = options.getEnum("connectionType", CifsConnectionType.class);
        if (mapper instanceof ProxyConnection) {
            throw new IllegalArgumentException("Cannot open a smb:" + this.cifsConnectionType.toString().toLowerCase() + ": connection through an HTTP proxy");
        }
        String unmappedAddress = (String)options.get("address");
        int unmappedPort = options.get("port", this.cifsConnectionType.getDefaultPort(options));
        InetSocketAddress addressPort = mapper.map(InetSocketAddress.createUnresolved(unmappedAddress, unmappedPort));
        this.hostname = addressPort.getHostName();
        this.port = addressPort.getPort();
        int unmappedSmbPort = options.getInteger("smbPort", 445);
        InetSocketAddress smbAddressPort = mapper.map(InetSocketAddress.createUnresolved(unmappedAddress, unmappedSmbPort));
        this.smbPort = smbAddressPort.getPort();
        this.username = (String)options.get("username");
        this.password = (String)options.get(ConnectionOptions.PASSWORD);
        this.client = new SMBClient((Config)new DefaultConfig());
    }

    public void connect() {
        this.createConnection();
        this.connected();
    }

    private void createConnection() {
        try {
            UserAndDomain ud = this.getUserNameAndDomain(this.username);
            String user = ud.getUsername();
            String domain = ud.getDomain();
            this.connection = this.client.connect(this.hostname);
            AuthenticationContext authContext = new AuthenticationContext(user, this.password.toCharArray(), domain);
            this.session = this.connection.authenticate(authContext);
        }
        catch (SMBApiException smbApi) {
            if (smbApi.getStatus() == NtStatus.STATUS_LOGON_FAILURE) {
                throw new RuntimeIOException(smbApi);
            }
            throw smbApi;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public OverthereFile getFile(String hostPath) {
        Map pathMappings = this.options.get("pathShareMappings", SmbConnectionBuilder.PATH_SHARE_MAPPINGS_DEFAULT);
        return new SmbFile(this, hostPath, pathMappings);
    }

    @Override
    public OverthereFile getFile(OverthereFile parent, String child) {
        return parent.getFile(child);
    }

    @Override
    protected void doClose() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (IOException e) {
            logger.warn("Exception while trying to close smb session", (Throwable)e);
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                logger.warn("Exception while trying to close smb connection", (Throwable)e);
            }
        }
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        return this.getFile(parent, name);
    }

    @Override
    public String toString() {
        return "smb:" + this.cifsConnectionType.toString().toLowerCase() + "://" + this.username + "@" + this.hostname + ":" + this.smbPort + ":" + this.port;
    }

    protected DiskShare getShare(String shareName) {
        Share share = this.session.connectShare(shareName);
        if (!(share instanceof DiskShare)) {
            this.close();
            throw new RuntimeIOException("The share " + shareName + " is not a disk share");
        }
        return (DiskShare)share;
    }

    private UserAndDomain getUserNameAndDomain(String user) {
        if (user.contains("\\")) {
            String[] split = user.split("\\\\");
            return new UserAndDomain(split[1], split[0]);
        }
        if (user.contains("@")) {
            String[] split = user.split("@");
            return new UserAndDomain(split[0], split[1]);
        }
        return new UserAndDomain(user, "");
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        logger = LoggerFactory.getLogger(SmbConnection.class);
    }

    private static class UserAndDomain {
        String username;
        String domain;

        private UserAndDomain(String username, String domain) {
            this.username = username;
            this.domain = domain;
        }

        private String getUsername() {
            return this.username;
        }

        private String getDomain() {
            return this.domain;
        }
    }
}

