/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.client.ClusterClientReceptionist$;
import akka.cluster.client.ClusterReceptionist$;
import akka.cluster.client.ClusterReceptionistSettings$;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSub$;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.cluster.pubsub.DistributedPubSubMediator$Subscribe$;
import akka.cluster.pubsub.DistributedPubSubMediator$Unsubscribe$;
import com.typesafe.config.Config;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015q!B\u0001\u0003\u0011\u0003I\u0011!G\"mkN$XM]\"mS\u0016tGOU3dKB$\u0018n\u001c8jgRT!a\u0001\u0003\u0002\r\rd\u0017.\u001a8u\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0003\u001d\tA!Y6lC\u000e\u0001\u0001C\u0001\u0006\f\u001b\u0005\u0011a!\u0002\u0007\u0003\u0011\u0003i!!G\"mkN$XM]\"mS\u0016tGOU3dKB$\u0018n\u001c8jgR\u001cBa\u0003\b\u0015]B\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u00042!\u0006\r\u001b\u001b\u00051\"BA\f\u0007\u0003\u0015\t7\r^8s\u0013\tIbCA\u0006FqR,gn]5p]&#\u0007C\u0001\u0006\u001c\r\u0011a!A\u0001\u000f\u0014\u0007mqQ\u0004\u0005\u0002\u0016=%\u0011qD\u0006\u0002\n\u000bb$XM\\:j_:D\u0001\"I\u000e\u0003\u0002\u0003\u0006IAI\u0001\u0007gf\u001cH/Z7\u0011\u0005U\u0019\u0013B\u0001\u0013\u0017\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0011\u001513\u0004\"\u0001(\u0003\u0019a\u0014N\\5u}Q\u0011!\u0004\u000b\u0005\u0006C\u0015\u0002\rA\t\u0005\bUm\u0011\r\u0011\"\u0003,\u0003\u0019\u0019wN\u001c4jOV\tA\u0006\u0005\u0002.g5\taF\u0003\u0002+_)\u0011\u0001'M\u0001\tif\u0004Xm]1gK*\t!'A\u0002d_6L!\u0001\u000e\u0018\u0003\r\r{gNZ5h\u0011\u001914\u0004)A\u0005Y\u000591m\u001c8gS\u001e\u0004\u0003b\u0002\u001d\u001c\u0005\u0004%I!O\u0001\u0005e>dW-F\u0001;!\ry1(P\u0005\u0003yA\u0011aa\u00149uS>t\u0007C\u0001 B\u001d\tyq(\u0003\u0002A!\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001\u0005\u0003\u0003\u0004F7\u0001\u0006IAO\u0001\u0006e>dW\r\t\u0005\u0006\u000fn!\t\u0001S\u0001\rSN$VM]7j]\u0006$X\rZ\u000b\u0002\u0013B\u0011qBS\u0005\u0003\u0017B\u0011qAQ8pY\u0016\fg\u000eC\u0003N7\u0011%a*\u0001\bqk\n\u001cVOY'fI&\fGo\u001c:\u0016\u0003=\u0003\"!\u0006)\n\u0005E3\"\u0001C!di>\u0014(+\u001a4\t\u000bM[B\u0011\u0001+\u0002\u001fI,w-[:uKJ\u001cVM\u001d<jG\u0016$\"!\u0016-\u0011\u0005=1\u0016BA,\u0011\u0005\u0011)f.\u001b;\t\u000b]\u0011\u0006\u0019A(\t\u000bi[B\u0011A.\u0002#Ut'/Z4jgR,'oU3sm&\u001cW\r\u0006\u0002V9\")q#\u0017a\u0001\u001f\")al\u0007C\u0001?\u0006\u0011\"/Z4jgR,'oU;cg\u000e\u0014\u0018NY3s)\r)\u0006M\u0019\u0005\u0006Cv\u0003\r!P\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0006/u\u0003\ra\u0014\u0005\u0006In!\t!Z\u0001\u0015k:\u0014XmZ5ti\u0016\u00148+\u001e2tGJL'-\u001a:\u0015\u0007U3w\rC\u0003bG\u0002\u0007Q\bC\u0003\u0018G\u0002\u0007q\nC\u0004j7\t\u0007I\u0011\u0002(\u0002\u0019I,7-\u001a9uS>t\u0017n\u001d;\t\r-\\\u0002\u0015!\u0003P\u00035\u0011XmY3qi&|g.[:uA!)Qn\u0007C\u0001\u001d\u0006QQO\u001c3fe2L\u0018N\\4\u0011\u0005Uy\u0017B\u00019\u0017\u0005M)\u0005\u0010^3og&|g.\u00133Qe>4\u0018\u000eZ3s\u0011\u001513\u0002\"\u0001s)\u0005I\u0001\"\u0002;\f\t\u0003*\u0018aA4fiR\u0011!D\u001e\u0005\u0006CM\u0004\ra\u001e\t\u0003+aL!!\u001f\f\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\u0006w.!\t\u0005`\u0001\u0007Y>|7.\u001e9\u0015\u0003ut!A\u0003\u0001\t\r}\\A\u0011IA\u0001\u0003=\u0019'/Z1uK\u0016CH/\u001a8tS>tGc\u0001\u000e\u0002\u0004!)\u0011E a\u0001E\u0001")
public final class ClusterClientReceptionist
implements Extension {
    private final ExtendedActorSystem system;
    private final Config config;
    private final Option<String> role;
    private final ActorRef receptionist;

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.apply(actorSystem);
    }

    public static ClusterClientReceptionist createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterClientReceptionist$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterClientReceptionist$ lookup() {
        return ClusterClientReceptionist$.MODULE$.lookup();
    }

    public static ClusterClientReceptionist get(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.get(actorSystem);
    }

    private Config config() {
        return this.config;
    }

    private Option<String> role() {
        return this.role;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminated() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).isTerminated()) return true;
        Set set = ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).selfRoles();
        if (!this.role().forall((Function1)new Serializable(this, set){
            public static final long serialVersionUID = 0L;
            private final Set eta$0$1$1;

            public final boolean apply(String elem) {
                return this.eta$0$1$1.contains((Object)elem);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        })) return true;
        return false;
    }

    private ActorRef pubSubMediator() {
        return ((DistributedPubSub)DistributedPubSub$.MODULE$.apply((ActorSystem)this.system)).mediator();
    }

    public void registerService(ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Put x$47 = new DistributedPubSubMediator.Put(actor);
        ActorRef x$48 = qual$1.$bang$default$2((Object)x$47);
        qual$1.$bang((Object)x$47, x$48);
    }

    public void unregisterService(ActorRef actor) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Remove x$49 = new DistributedPubSubMediator.Remove(actor.path().toStringWithoutAddress());
        ActorRef x$50 = qual$2.$bang$default$2((Object)x$49);
        qual$2.$bang((Object)x$49, x$50);
    }

    public void registerSubscriber(String topic, ActorRef actor) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Subscribe x$51 = DistributedPubSubMediator$Subscribe$.MODULE$.apply(topic, actor);
        ActorRef x$52 = qual$3.$bang$default$2((Object)x$51);
        qual$3.$bang((Object)x$51, x$52);
    }

    public void unregisterSubscriber(String topic, ActorRef actor) {
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Unsubscribe x$53 = DistributedPubSubMediator$Unsubscribe$.MODULE$.apply(topic, actor);
        ActorRef x$54 = qual$4.$bang$default$2((Object)x$53);
        qual$4.$bang((Object)x$53, x$54);
    }

    private ActorRef receptionist() {
        return this.receptionist;
    }

    public ActorRef underlying() {
        return this.receptionist();
    }

    public ClusterClientReceptionist(ExtendedActorSystem system) {
        ActorRef actorRef;
        this.system = system;
        this.config = system.settings().config().getConfig("akka.cluster.client.receptionist");
        String string = this.config().getString("role");
        Object object = "".equals(string) ? None$.MODULE$ : new Some((Object)string);
        this.role = object;
        if (this.isTerminated()) {
            actorRef = system.deadLetters();
        } else {
            String name = this.config().getString("name");
            String string2 = this.config().getString("use-dispatcher");
            String string3 = "".equals(string2) ? "akka.actor.default-dispatcher" : string2;
            String dispatcher = string3;
            ActorRef mediator = this.pubSubMediator();
            actorRef = system.systemActorOf(ClusterReceptionist$.MODULE$.props(mediator, ClusterReceptionistSettings$.MODULE$.apply(this.config())).withDispatcher(dispatcher), name);
        }
        this.receptionist = actorRef;
    }
}

