/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.variable;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class VariableHelper$ {
    public static final VariableHelper$ MODULE$;
    private final String VARIABLE_PATTERN;
    private final Pattern VARIABLE_NAME_PATTERN;
    private final Pattern ONLY_ONE_VARIABLE_NAME_PATTERN;
    private final Pattern CI_PROPERTY_VARIABLE_NAME_PATTERN;
    private final Pattern GLOBAL_VARIABLE_NAME_PATTERN;

    static {
        new VariableHelper$();
    }

    private String VARIABLE_PATTERN() {
        return this.VARIABLE_PATTERN;
    }

    private Pattern VARIABLE_NAME_PATTERN() {
        return this.VARIABLE_NAME_PATTERN;
    }

    private Pattern ONLY_ONE_VARIABLE_NAME_PATTERN() {
        return this.ONLY_ONE_VARIABLE_NAME_PATTERN;
    }

    private Pattern CI_PROPERTY_VARIABLE_NAME_PATTERN() {
        return this.CI_PROPERTY_VARIABLE_NAME_PATTERN;
    }

    private Pattern GLOBAL_VARIABLE_NAME_PATTERN() {
        return this.GLOBAL_VARIABLE_NAME_PATTERN;
    }

    public String replaceAll(String raw, Map<String, String> replacements) {
        return (String)Option$.MODULE$.apply((Object)raw).map((Function1)new Serializable(replacements){
            public static final long serialVersionUID = 0L;
            private final Map replacements$1;

            public final String apply(String x$1) {
                return (String)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaSet(this.replacements$1.entrySet()).foldLeft((Object)x$1, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String s, Map.Entry<String, String> entry) {
                        return s.replace(entry.getKey(), entry.getValue());
                    }
                });
            }
            {
                this.replacements$1 = replacements$1;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public String replaceAll(String raw, Map<String, String> replacements, java.util.Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        return (String)Option$.MODULE$.apply((Object)this.replaceAll(raw, package$.MODULE$.wrapAll().mutableMapAsJavaMap((scala.collection.mutable.Map)((WrapAsScala)package$.MODULE$.wrapAll()).mapAsScalaMap(replacements).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$2) {
                return x$2._2() != null;
            }
        })))).map((Function1)new Serializable(unresolvedVariables, freezeEvenIfUnresolved){
            public static final long serialVersionUID = 0L;
            private final java.util.Set unresolvedVariables$1;
            private final boolean freezeEvenIfUnresolved$1;

            public final String apply(String replaced) {
                java.util.Set<String> remainingVariables = VariableHelper$.MODULE$.collectVariables(replaced);
                this.unresolvedVariables$1.addAll(remainingVariables);
                return this.freezeEvenIfUnresolved$1 ? (String)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaSet(remainingVariables).foldLeft((Object)replaced, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String s, String remainingVariable) {
                        return VariableHelper$.MODULE$.freezeUnresolvedVariable(s, remainingVariable);
                    }
                }) : replaced;
            }
            {
                this.unresolvedVariables$1 = unresolvedVariables$1;
                this.freezeEvenIfUnresolved$1 = freezeEvenIfUnresolved$1;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public Object replaceAll(Object raw, Map<String, String> replacements, java.util.Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        return Option$.MODULE$.apply(raw).map((Function1)new Serializable(replacements, unresolvedVariables, freezeEvenIfUnresolved){
            public static final long serialVersionUID = 0L;
            public final Map replacements$2;
            public final java.util.Set unresolvedVariables$2;
            public final boolean freezeEvenIfUnresolved$2;

            public final Object apply(Object x0$1) {
                Object object;
                Object object2 = x0$1;
                if (object2 instanceof String) {
                    String string = (String)object2;
                    object = VariableHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariableHelper$$replaceInValue$1(string, this.replacements$2, this.unresolvedVariables$2, this.freezeEvenIfUnresolved$2);
                } else if (object2 instanceof java.util.List) {
                    java.util.List list = (java.util.List)object2;
                    object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(list).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.replaceAll.4 $outer;

                        public final String apply(String value) {
                            return VariableHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariableHelper$$replaceInValue$1(value, this.$outer.replacements$2, this.$outer.unresolvedVariables$2, this.$outer.freezeEvenIfUnresolved$2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
                } else if (object2 instanceof java.util.Set) {
                    java.util.Set set = (java.util.Set)object2;
                    object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaSet(set).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.replaceAll.4 $outer;

                        public final String apply(String value) {
                            return VariableHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariableHelper$$replaceInValue$1(value, this.$outer.replacements$2, this.$outer.unresolvedVariables$2, this.$outer.freezeEvenIfUnresolved$2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Set$.MODULE$.canBuildFrom())).toSet()).asJava();
                } else if (object2 instanceof Map) {
                    Map map = (Map)object2;
                    object = JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((WrapAsScala)package$.MODULE$.wrapAll()).mapAsScalaMap(map).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.replaceAll.4 $outer;

                        public final Tuple2<String, String> apply(Tuple2<String, String> t) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VariableHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariableHelper$$replaceInValue$1((String)t._1(), this.$outer.replacements$2, this.$outer.unresolvedVariables$2, this.$outer.freezeEvenIfUnresolved$2)), (Object)VariableHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariableHelper$$replaceInValue$1((String)t._2(), this.$outer.replacements$2, this.$outer.unresolvedVariables$2, this.$outer.freezeEvenIfUnresolved$2));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Map$.MODULE$.canBuildFrom())).asJava();
                } else {
                    object = object2;
                }
                return object;
            }
            {
                this.replacements$2 = replacements$2;
                this.unresolvedVariables$2 = unresolvedVariables$2;
                this.freezeEvenIfUnresolved$2 = freezeEvenIfUnresolved$2;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public String safeReplace(String input, String key, String replacement) {
        return input == null ? input : input.replace(key, replacement);
    }

    public boolean isCiPropertyVariable(String variableName) {
        return this.CI_PROPERTY_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isGlobalVariable(String variableName) {
        return this.GLOBAL_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public java.util.Set<String> collectVariables(Object input) {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Option$.MODULE$.apply(input).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<String> apply(Object x0$2) {
                scala.collection.immutable.Set set;
                Object object = x0$2;
                if (object instanceof String) {
                    String string = (String)object;
                    set = VariableHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariableHelper$$collectVariablesFromValue(string);
                } else if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    set = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(collection).asScala()).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final scala.collection.immutable.Set<String> apply(Object value) {
                            return VariableHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariableHelper$$collectVariablesFromValue(value);
                        }
                    }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
                } else if (object instanceof Map) {
                    Map map = (Map)object;
                    set = ((TraversableOnce)((WrapAsScala)package$.MODULE$.wrapAll()).mapAsScalaMap(map).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final scala.collection.immutable.Set<String> apply(Tuple2<Object, Object> x0$3) {
                            Tuple2<Object, Object> tuple2 = x0$3;
                            if (tuple2 != null) {
                                Object k = tuple2._1();
                                Object v = tuple2._2();
                                scala.collection.immutable.Set set = (scala.collection.immutable.Set)VariableHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariableHelper$$collectVariablesFromValue(k).$plus$plus(VariableHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariableHelper$$collectVariablesFromValue(v));
                                return set;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toSet();
                } else {
                    set = Predef$.MODULE$.Set().empty();
                }
                return set;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<String> apply() {
                return Predef$.MODULE$.Set().empty();
            }
        })).asJava();
    }

    public scala.collection.immutable.Set<String> com$xebialabs$xlrelease$variable$VariableHelper$$collectVariablesFromValue(Object value) {
        scala.collection.mutable.Set result = Set$.MODULE$.empty();
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            Matcher matcher = this.VARIABLE_NAME_PATTERN().matcher(string);
            while (matcher.find()) {
                result.add((Object)matcher.group());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return result.toSet();
    }

    public boolean containsVariables(String input) {
        return input != null && this.VARIABLE_NAME_PATTERN().matcher(input).find();
    }

    public String formatVariableIfNeeded(String variableName) {
        return Strings.isNullOrEmpty((String)variableName) || this.containsOnlyVariable(variableName) ? variableName : this.withVariableSyntax(variableName);
    }

    public boolean containsOnlyVariable(String input) {
        return !Strings.isNullOrEmpty((String)input) && this.ONLY_ONE_VARIABLE_NAME_PATTERN().matcher(input).find();
    }

    public String withVariableSyntax(String variableName) {
        return new StringBuilder().append((Object)"${").append((Object)variableName).append((Object)"}").toString();
    }

    public String withoutVariableSyntax(String variableKey) {
        String string;
        if (this.containsOnlyVariable(variableKey)) {
            Matcher matcher = this.ONLY_ONE_VARIABLE_NAME_PATTERN().matcher(variableKey);
            matcher.find();
            string = matcher.group(1);
        } else {
            string = variableKey;
        }
        return string;
    }

    public void checkVariable(Variable variable) {
        Preconditions.checkNotNull((Object)variable);
        variable.checkValidity();
    }

    public void checkVariables(java.util.List<Variable> variables) {
        Preconditions.checkNotNull(variables);
        ((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(variables).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Variable variable) {
                VariableHelper$.MODULE$.checkVariable(variable);
            }
        });
        Buffer keys = (Buffer)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(variables).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Variable x$3) {
                return x$3.getKey();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        scala.collection.mutable.Set uniqueKeys = Set$.MODULE$.empty();
        keys.foreach((Function1)new Serializable(uniqueKeys){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Set uniqueKeys$1;

            public final void apply(String key) {
                Preconditions.checkNotNull((Object)key);
                Preconditions.checkArgument((boolean)this.uniqueKeys$1.add((Object)key), (String)"The variables list contains duplicate keys: '%s'", (Object[])new Object[]{key});
            }
            {
                this.uniqueKeys$1 = uniqueKeys$1;
            }
        });
    }

    public Map<String, String> getStringVariableValues(java.util.List<Variable> vars) {
        return this.getVariableValuesAsStrings((List<Variable>)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(vars).toList(), false);
    }

    public Map<String, String> getPasswordStringVariableValues(java.util.List<Variable> vars) {
        return this.getVariableValuesAsStrings((List<Variable>)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(vars).toList(), true);
    }

    private Map<String, String> getVariableValuesAsStrings(List<Variable> variables, boolean passwords) {
        return package$.MODULE$.wrapAll().mutableMapAsJavaMap((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)((List)variables.filter((Function1)new Serializable(passwords){
            public static final long serialVersionUID = 0L;
            private final boolean passwords$1;

            public final boolean apply(Variable x$4) {
                return x$4.isPassword() == this.passwords$1;
            }
            {
                this.passwords$1 = passwords$1;
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<String, String>> apply(Variable x$5) {
                return Option$.MODULE$.option2Iterable(VariableHelper$.MODULE$.com$xebialabs$xlrelease$variable$VariableHelper$$VariableExtensions(x$5).asKeyValue());
            }
        }, List$.MODULE$.canBuildFrom())));
    }

    public Map<String, Variable> indexByKey(java.util.List<Variable> variables) {
        LinkedHashMap m = new LinkedHashMap();
        Option$.MODULE$.apply(variables).foreach((Function1)new Serializable(m){
            public static final long serialVersionUID = 0L;
            public final LinkedHashMap m$1;

            public final void apply(java.util.List<Variable> x$6) {
                ((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(x$6).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.indexByKey.1 $outer;

                    public final Option<Variable> apply(Variable v) {
                        return this.$outer.m$1.put((Object)v.getKey(), (Object)v);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.m$1 = m$1;
            }
        });
        return package$.MODULE$.wrapAll().mutableMapAsJavaMap((scala.collection.mutable.Map)m);
    }

    public void checkVariableIdsAreTheSame(String requestVariableId, String bodyVariableId) {
        String string = bodyVariableId;
        String string2 = requestVariableId;
        Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Request to update variable [%s] contains an object with different ID: [%s]", (Object[])new Object[]{requestVariableId, bodyVariableId});
    }

    public boolean isGlobalVariableId(String id) {
        return id.startsWith("Configuration/variables/global/") || id.startsWith("/Configuration/variables/global/");
    }

    public java.util.List<Variable> fillVariableValues(java.util.List<Variable> target, java.util.List<Variable> source) {
        Map<String, Variable> sourceVariables = this.indexByKey(source);
        ((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(target).foreach((Function1)new Serializable(sourceVariables){
            public static final long serialVersionUID = 0L;
            private final Map sourceVariables$1;

            public final void apply(Variable targetVariable) {
                String key = targetVariable.getKey();
                if (this.sourceVariables$1.containsKey(key)) {
                    Variable sourceVariable = (Variable)this.sourceVariables$1.get(key);
                    if (targetVariable.getType().equals((Object)sourceVariable.getType())) {
                        targetVariable.setUntypedValue(sourceVariable.getValue());
                    } else {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot set value of type [", "] into "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceVariable.getType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"variable ", " of type [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{VariableHelper$.MODULE$.withVariableSyntax(sourceVariable.getKey()), targetVariable.getType()}))).toString());
                    }
                }
            }
            {
                this.sourceVariables$1 = sourceVariables$1;
            }
        });
        return target;
    }

    public String freezeUnresolvedVariable(String input, String variableName) {
        String string;
        if (this.containsVariables(variableName)) {
            String dollarLessName = variableName.substring(1);
            string = input.replace(variableName, new StringBuilder().append((Object)"$~").append((Object)dollarLessName).toString());
        } else {
            string = input;
        }
        return string;
    }

    public VariableHelper.VariableExtensions com$xebialabs$xlrelease$variable$VariableHelper$$VariableExtensions(Variable variable) {
        return new VariableHelper.VariableExtensions(variable);
    }

    public final String com$xebialabs$xlrelease$variable$VariableHelper$$replaceInValue$1(String value, Map replacements$2, java.util.Set unresolvedVariables$2, boolean freezeEvenIfUnresolved$2) {
        return this.replaceAll(value, (Map<String, String>)replacements$2, (java.util.Set<String>)unresolvedVariables$2, freezeEvenIfUnresolved$2);
    }

    private VariableHelper$() {
        MODULE$ = this;
        this.VARIABLE_PATTERN = "\\$\\{[^}]+\\}";
        this.VARIABLE_NAME_PATTERN = Pattern.compile(this.VARIABLE_PATTERN());
        this.ONLY_ONE_VARIABLE_NAME_PATTERN = Pattern.compile("^\\$\\{([^}]+)\\}$");
        this.CI_PROPERTY_VARIABLE_NAME_PATTERN = Pattern.compile("^release\\..*$", 2);
        this.GLOBAL_VARIABLE_NAME_PATTERN = Pattern.compile("^global\\..*$", 2);
    }
}

