/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.plugin.api.udm.Metadata;

public class Ids {
    public static final String ROOT_FOLDER_ID = Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName();
    public static final String SEPARATOR = "/";
    private static final String RELEASE_PREFIX = "Release";
    private static final String PHASE_PREFIX = "Phase";
    private static final String TASK_PREFIX = "Task";
    private static final String VARIABLE_PREFIX = "Variable";
    private static final String DEPENDENCY_PREFIX = "Dependency";
    private static final String FOLDER_PREFIX = "Folder";
    private static final String ATTACHMENT_PREFIX = "Attachment";

    private Ids() {
    }

    public static String getParentId(String id) {
        if (Ids.isRoot(id)) {
            throw new IllegalArgumentException("Not a proper ID for a children: " + id);
        }
        return id.substring(0, id.lastIndexOf(SEPARATOR));
    }

    public static boolean isRoot(String id) {
        return !id.contains(SEPARATOR);
    }

    public static String releaseIdFrom(String id) {
        return Ids.findInAncestry(id, RELEASE_PREFIX);
    }

    public static String phaseIdFrom(String id) {
        return Ids.findInAncestry(id, PHASE_PREFIX);
    }

    public static String taskIdFrom(String id) {
        return Ids.findInAncestry(id, TASK_PREFIX);
    }

    public static boolean isNullId(String id) {
        return id == null || id.trim().isEmpty() || "null".equals(id.trim().toLowerCase());
    }

    public static boolean isPlanItemId(String id) {
        return Ids.isReleaseId(id) || Ids.isPhaseId(id) || Ids.isTaskId(id);
    }

    public static boolean isReleaseId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(RELEASE_PREFIX);
    }

    public static boolean isPhaseId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(PHASE_PREFIX);
    }

    public static boolean isAttachmentId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(ATTACHMENT_PREFIX);
    }

    public static boolean isTaskId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(TASK_PREFIX);
    }

    public static boolean isVariableId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(VARIABLE_PREFIX);
    }

    public static boolean isDependencyId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(DEPENDENCY_PREFIX);
    }

    public static boolean isFolderId(String id) {
        Ids.checkIdNotNull(id);
        return Ids.getName(id).startsWith(FOLDER_PREFIX);
    }

    public static boolean isInFolder(String id) {
        return !Ids.isRoot(id) && Ids.isFolderId(Ids.getParentId(id));
    }

    public static boolean isInRootFolder(String id) {
        return !Ids.isNullId(id) && ROOT_FOLDER_ID.equals(Ids.getParentId(id));
    }

    public static boolean isInRelease(String id) {
        if (Ids.isReleaseId(id)) {
            return false;
        }
        try {
            return Ids.releaseIdFrom(id) != null;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private static String findInAncestry(String id, String prefix) {
        try {
            String ancestryId = id;
            while (!Ids.getName(ancestryId).startsWith(prefix)) {
                ancestryId = Ids.getParentId(ancestryId);
            }
            return ancestryId;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Unable to find ancestor ID of the following ID: '%s' and prefix: '%s'", id, prefix), ex);
        }
    }

    private static void checkIdNotNull(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID may not be null");
        }
    }

    public static String getName(String id) {
        if (!id.contains(SEPARATOR)) {
            return id;
        }
        return id.substring(id.lastIndexOf(SEPARATOR) + 1);
    }

    public static String getReleaselessChildId(String childId) {
        if (Ids.isReleaseId(childId)) {
            return null;
        }
        return childId.substring(Ids.releaseIdFrom(childId).length() + 1);
    }

    public static String getFullTaskName(String id) {
        return id.substring(Ids.phaseIdFrom(id).length() + 1);
    }

    public static String releasePathInRootFolder(String releaseId) {
        Ids.checkIdNotNull(releaseId);
        return releaseId.replace(ROOT_FOLDER_ID + SEPARATOR, "");
    }

    public static String findFolderId(String id) {
        String parentId = id;
        while (!Ids.isFolderId(parentId) && !Ids.isRoot(parentId)) {
            parentId = Ids.getParentId(parentId);
        }
        return parentId;
    }

    public static String normalizeId(String id) {
        if (id == null) {
            return null;
        }
        return id.startsWith(SEPARATOR) ? id.substring(1) : id;
    }
}

