/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.xlrelease.domain.Comment;
import java.util.Date;

public abstract class CommentsHelper {
    private CommentsHelper() {
    }

    public static void appendCommentText(Comment comment, String commentText, int maxCommentSize, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(CommentsHelper.removeExistingPrefixAndSuffix(comment.getText(), prefix, suffix));
        sb.append(commentText);
        if (maxCommentSize == 0) {
            sb = new StringBuilder();
        }
        if (maxCommentSize > 0 && sb.length() > maxCommentSize) {
            sb.delete(maxCommentSize, sb.length());
            sb.insert(0, prefix);
            sb.append(suffix);
        }
        String truncatedComment = sb.toString();
        comment.setText(truncatedComment);
        comment.setDate(new Date());
    }

    static void updateCommentText(Comment comment, String newText, int maxCommentSize, String prefix, String suffix) {
        if (!newText.equals(comment.getText())) {
            comment.setText("");
            CommentsHelper.appendCommentText(comment, CommentsHelper.removeExistingPrefixAndSuffix(newText, prefix, suffix), maxCommentSize, prefix, suffix);
        }
    }

    private static String removeExistingPrefixAndSuffix(String existingComment, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (null != existingComment) {
            sb.append(existingComment);
            if (existingComment.startsWith(prefix)) {
                sb.delete(0, prefix.length());
            }
            if (existingComment.endsWith(suffix)) {
                sb.delete(sb.length() - suffix.length(), sb.length());
            }
        }
        return sb.toString();
    }
}

