/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.status;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum PhaseStatus {
    PLANNED("planned"),
    IN_PROGRESS("in_progress"),
    COMPLETED("completed"),
    FAILING("failing"),
    FAILED("failed"),
    SKIPPED("skipped"),
    ABORTED("aborted");

    private final String value;

    private PhaseStatus(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static PhaseStatus fromValue(String v) {
        for (PhaseStatus c : PhaseStatus.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public boolean hasBeenStarted() {
        return this != PLANNED;
    }

    public boolean isActive() {
        return this.isOneOf(IN_PROGRESS, FAILED, FAILING);
    }

    public boolean isOneOf(PhaseStatus ... statuses) {
        for (PhaseStatus status : statuses) {
            if (this != status) continue;
            return true;
        }
        return false;
    }
}

