/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import java.util.ArrayList;
import java.util.List;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned=false)
public class Team
extends BaseConfigurationItem {
    public static final String FOLDER_OWNER_TEAMNAME = "Folder Owner";
    public static final String TEMPLATE_OWNER_TEAMNAME = "Template Owner";
    public static final String RELEASE_ADMIN_TEAMNAME = "Release Admin";
    @Property
    private String teamName;
    @Property(required=false)
    private List<String> members = new ArrayList<String>();
    @Property(required=false)
    private List<String> roles = new ArrayList<String>();
    @Property(required=false)
    private List<String> permissions = new ArrayList<String>();

    @PublicApiMember
    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public boolean hasMember(String username) {
        return this.members.contains(username);
    }

    public boolean hasPermission(String permission) {
        return this.permissions.contains(permission);
    }

    @PublicApiMember
    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public void addMember(String newMember) {
        for (String member : this.members) {
            if (!member.equals(newMember)) continue;
            return;
        }
        if (newMember != null) {
            this.members.add(newMember);
        }
    }

    @PublicApiMember
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void addRole(String newRole) {
        for (String role : this.roles) {
            if (!role.equals(newRole)) continue;
            return;
        }
        if (newRole != null) {
            this.roles.add(newRole);
        }
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    public boolean hasAnyRole(List<Role> roles) {
        for (Role role : roles) {
            if (!this.hasRole(role.getName())) continue;
            return true;
        }
        return false;
    }

    @PublicApiMember
    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(String permission) {
        if (!this.permissions.contains(permission) && permission != null) {
            this.permissions.add(permission);
        }
    }

    public boolean isSystemTeam() {
        return RELEASE_ADMIN_TEAMNAME.equals(this.teamName) || TEMPLATE_OWNER_TEAMNAME.equals(this.teamName) || FOLDER_OWNER_TEAMNAME.equals(this.teamName);
    }

    public void addMembers(String[] members) {
        for (String member : members) {
            this.addMember(member);
        }
    }

    public void addRoles(String[] roles) {
        for (String role : roles) {
            this.addRole(role);
        }
    }

    public void addPermissions(String[] permissions) {
        for (String permission : permissions) {
            this.addPermission(permission);
        }
    }
}

