/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;

public class PhaseBuilder {
    private String id;
    private String title;
    private PhaseStatus status;
    private List<Task> tasks;
    private Release release;
    private Date scheduledStartDate;
    private Date startDate;
    private Date dueDate;
    private Date endDate;
    private Integer plannedDuration;
    private String description;
    private String color;

    private PhaseBuilder() {
    }

    public static PhaseBuilder newPhase() {
        return new PhaseBuilder().withRelease(new Release());
    }

    public PhaseBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public PhaseBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public PhaseBuilder withIdAndTitle(String id) {
        this.id = id;
        this.title = id;
        return this;
    }

    public PhaseBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public PhaseBuilder withStatus(PhaseStatus status) {
        this.status = status;
        return this;
    }

    public PhaseBuilder withTasks(Task ... tasks) {
        this.tasks = Lists.newArrayList((Object[])tasks);
        return this;
    }

    public PhaseBuilder withRelease(Release release) {
        this.release = release;
        return this;
    }

    public PhaseBuilder withScheduledStartDate(Date date) {
        this.scheduledStartDate = date;
        return this;
    }

    public PhaseBuilder withStartDate(Date date) {
        this.startDate = date;
        return this;
    }

    public PhaseBuilder withStartDate(DateTime date) {
        this.startDate = date.toDate();
        return this;
    }

    public PhaseBuilder withDueDate(Date date) {
        this.dueDate = date;
        return this;
    }

    public PhaseBuilder withEndDate(DateTime date) {
        this.endDate = date.toDate();
        return this;
    }

    public PhaseBuilder completed() {
        if (this.startDate == null) {
            this.startDate = new Date();
        }
        if (this.endDate == null) {
            this.endDate = new Date();
        }
        this.status = PhaseStatus.COMPLETED;
        return this;
    }

    public PhaseBuilder withEndDate(Date date) {
        this.endDate = date;
        return this;
    }

    public PhaseBuilder withPlannedDuration(Integer plannedDuration) {
        this.plannedDuration = plannedDuration;
        return this;
    }

    public PhaseBuilder withColor(String color) {
        this.color = color;
        return this;
    }

    public Phase build() {
        Phase phase = (Phase)new Phase().getType().getDescriptor().newInstance(this.id);
        phase.setStatus(this.status);
        phase.setTitle(this.title);
        phase.setDescription(this.description);
        phase.setRelease(this.release);
        phase.setScheduledStartDate(this.scheduledStartDate != null ? this.scheduledStartDate : null);
        phase.setStartDate(this.startDate != null ? this.startDate : null);
        phase.setDueDate(this.dueDate != null ? this.dueDate : null);
        phase.setEndDate(this.endDate != null ? this.endDate : null);
        phase.setPlannedDuration(this.plannedDuration);
        phase.setColor(this.color);
        if (null != this.tasks) {
            for (Task task : this.tasks) {
                task.setContainer(phase);
            }
            phase.setTasks(this.tasks);
        }
        return phase;
    }
}

