/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.akka.extension.quartz.QuartzCalendars$;
import com.typesafe.akka.extension.quartz.QuartzCronSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedulerExtension$;
import com.typesafe.akka.extension.quartz.QuartzSchedules$;
import com.typesafe.akka.extension.quartz.SimpleActorMessageJob;
import com.typesafe.akka.extension.quartz.package$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\rw!B\u0001\u0003\u0011\u0003i\u0011\u0001G)vCJ$(pU2iK\u0012,H.\u001a:FqR,gn]5p]*\u00111\u0001B\u0001\u0007cV\f'\u000f\u001e>\u000b\u0005\u00151\u0011!C3yi\u0016t7/[8o\u0015\t9\u0001\"\u0001\u0003bW.\f'BA\u0005\u000b\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0011\u00059yQ\"\u0001\u0002\u0007\u000bA\u0011\u0001\u0012A\t\u00031E+\u0018M\u001d;{'\u000eDW\rZ;mKJ,\u0005\u0010^3og&|gn\u0005\u0002\u0010%A\u00191cF\r\u000e\u0003QQ!!\u0006\f\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003\u001dI!\u0001\u0007\u000b\u0003\u0019\u0015CH/\u001a8tS>t7*Z=\u0011\u00059Qb\u0001\u0002\t\u0003\u0001m\u00192A\u0007\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111cI\u0005\u0003IQ\u0011\u0011\"\u0012=uK:\u001c\u0018n\u001c8\t\u0011\u0019R\"\u0011!Q\u0001\n\u001d\naa]=ti\u0016l\u0007CA\n)\u0013\tICCA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W\u000eC\u0003,5\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u000335BQA\n\u0016A\u0002\u001dBqa\f\u000eC\u0002\u0013%\u0001'A\u0002m_\u001e,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003iY\tQ!\u001a<f]RL!AN\u001a\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;fe\"1\u0001H\u0007Q\u0001\nE\nA\u0001\\8hA!)!H\u0007C\u0001w\u0005i1o\u00195fIVdWM\u001d(b[\u0016,\u0012\u0001\u0010\t\u0003{\u0001s!!\b \n\u0005}r\u0012A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u0010\t\u000f\u0011S\"\u0019!C\t\u000b\u000611m\u001c8gS\u001e,\u0012A\u0012\t\u0003\u000f&k\u0011\u0001\u0013\u0006\u0003\t\"I!A\u0013%\u0003\r\r{gNZ5h\u0011\u0019a%\u0004)A\u0005\r\u000691m\u001c8gS\u001e\u0004\u0003\u0002\u0003(\u001b\u0011\u000b\u0007I\u0011A#\u0002\u001b\u0011,g-Y;mi\u000e{gNZ5h\u0011!\u0001&\u0004#A!B\u00131\u0015A\u00043fM\u0006,H\u000e^\"p]\u001aLw\r\t\u0005\b%j\u0011\r\u0011\"\u0001T\u0003-!\bN]3bI\u000e{WO\u001c;\u0016\u0003Q\u0003\"!H+\n\u0005Ys\"aA%oi\"1\u0001L\u0007Q\u0001\nQ\u000bA\u0002\u001e5sK\u0006$7i\\;oi\u0002BqA\u0017\u000eC\u0002\u0013\u00051+\u0001\buQJ,\u0017\r\u001a)sS>\u0014\u0018\u000e^=\t\rqS\u0002\u0015!\u0003U\u0003=!\bN]3bIB\u0013\u0018n\u001c:jif\u0004\u0003b\u00020\u001b\u0005\u0004%\taX\u0001\u0015I\u0006,Wn\u001c8UQJ,\u0017\rZ:`IEl\u0017M]6\u0016\u0003\u0001\u0004\"!H1\n\u0005\tt\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007Ij\u0001\u000b\u0011\u00021\u0002+\u0011\fW-\\8o)\"\u0014X-\u00193t?\u0012\nX.\u0019:lA!9aM\u0007b\u0001\n\u00039\u0017a\u00043fM\u0006,H\u000e\u001e+j[\u0016TxN\\3\u0016\u0003!\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\tU$\u0018\u000e\u001c\u0006\u0002[\u0006!!.\u0019<b\u0013\ty'N\u0001\u0005US6,'l\u001c8f\u0011\u0019\t(\u0004)A\u0005Q\u0006\u0001B-\u001a4bk2$H+[7fu>tW\r\t\u0005\bgj\u0001\r\u0011\"\u0001u\u0003%\u00198\r[3ek2,7/F\u0001v!\u001118\u0010P?\u000e\u0003]T!\u0001_=\u0002\u0013%lW.\u001e;bE2,'B\u0001>\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003y^\u00141!T1q!\tqa0\u0003\u0002\u0000\u0005\tq\u0011+^1sij\u001c6\r[3ek2,\u0007\"CA\u00025\u0001\u0007I\u0011AA\u0003\u00035\u00198\r[3ek2,7o\u0018\u0013fcR!\u0011qAA\u0007!\ri\u0012\u0011B\u0005\u0004\u0003\u0017q\"\u0001B+oSRD\u0011\"a\u0004\u0002\u0002\u0005\u0005\t\u0019A;\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0014i\u0001\u000b\u0015B;\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u001c\b\u0005C\u0005\u0002\u0018i\u0011\r\u0011\"\u0001\u0002\u001a\u0005Y!/\u001e8oS:<'j\u001c2t+\t\tY\u0002E\u0004\u0002\u001e\u0005\rB(!\n\u000e\u0005\u0005}!bAA\u0011s\u00069Q.\u001e;bE2,\u0017b\u0001?\u0002 A!\u0011qEA\u0018\u001b\t\tICC\u0002\u0004\u0003WQ!!!\f\u0002\u0007=\u0014x-\u0003\u0003\u00022\u0005%\"A\u0002&pE.+\u0017\u0010\u0003\u0005\u00026i\u0001\u000b\u0011BA\u000e\u00031\u0011XO\u001c8j]\u001eTuNY:!\u0011\u001d\tID\u0007C\u0001\u0003w\tqa\u001d;b]\u0012\u0014\u0017\u0010\u0006\u0002\u0002\b!1\u0011q\b\u000e\u0005\u0002}\u000bq\"[:J]N#\u0018M\u001c3cs6{G-\u001a\u0005\b\u0003\u0007RB\u0011AA#\u0003\u0015\u0019H/\u0019:u)\u0005\u0001\u0007BBA%5\u0011\u0005q,A\u0005jgN#\u0018M\u001d;fI\"9\u0011Q\n\u000e\u0005\u0002\u0005=\u0013a\u00038fqR$&/[4hKJ$B!!\u0015\u0002^A)Q$a\u0015\u0002X%\u0019\u0011Q\u000b\u0010\u0003\r=\u0003H/[8o!\rI\u0017\u0011L\u0005\u0004\u00037R'\u0001\u0002#bi\u0016Dq!a\u0018\u0002L\u0001\u0007A(\u0001\u0003oC6,\u0007bBA25\u0011\u0005\u00111H\u0001\u000bgV\u001c\b/\u001a8e\u00032d\u0007bBA45\u0011\u0005\u0011\u0011N\u0001\tg\",H\u000fZ8x]R!\u0011qAA6\u0011%\ti'!\u001a\u0011\u0002\u0003\u0007\u0001-A\u000bxC&$hi\u001c:K_\n\u001cHk\\\"p[BdW\r^3\t\u000f\u0005E$\u0004\"\u0001\u0002t\u0005Q1/^:qK:$'j\u001c2\u0015\u0007\u0001\f)\bC\u0004\u0002`\u0005=\u0004\u0019\u0001\u001f\t\u000f\u0005e$\u0004\"\u0001\u0002|\u0005I!/Z:v[\u0016TuN\u0019\u000b\u0004A\u0006u\u0004bBA0\u0003o\u0002\r\u0001\u0010\u0005\b\u0003\u0003SB\u0011AA\u001e\u0003%\u0011Xm];nK\u0006cG\u000eC\u0004\u0002\u0006j!\t!a\"\u0002\u0013\r\fgnY3m\u0015>\u0014Gc\u00011\u0002\n\"9\u0011qLAB\u0001\u0004a\u0004bBAG5\u0011\u0005\u0011qR\u0001\u000fGJ,\u0017\r^3TG\",G-\u001e7f)1\t9!!%\u0002\u0014\u0006e\u0015QTAQ\u0011\u001d\ty&a#A\u0002qB!\"!&\u0002\fB\u0005\t\u0019AAL\u0003-!Wm]2sSB$\u0018n\u001c8\u0011\tu\t\u0019\u0006\u0010\u0005\b\u00037\u000bY\t1\u0001=\u00039\u0019'o\u001c8FqB\u0014Xm]:j_:D!\"a(\u0002\fB\u0005\t\u0019AAL\u0003!\u0019\u0017\r\\3oI\u0006\u0014\b\"CAR\u0003\u0017\u0003\n\u00111\u0001i\u0003!!\u0018.\\3{_:,\u0007bBAT5\u0011\u0005\u0011\u0011V\u0001\u000ee\u0016\u001c8\r[3ek2,'j\u001c2\u0015!\u0005]\u00131VAW\u0003o\u000bY,!0\u0002@\u0006\u0005\u0007bBA0\u0003K\u0003\r\u0001\u0010\u0005\t\u0003_\u000b)\u000b1\u0001\u00022\u0006A!/Z2fSZ,'\u000fE\u0002\u0014\u0003gK1!!.\u0015\u0005!\t5\r^8s%\u00164\u0007bBA]\u0003K\u0003\r\u0001H\u0001\u0004[N<\u0007BCAK\u0003K\u0003\n\u00111\u0001\u0002\u0018\"9\u00111TAS\u0001\u0004a\u0004BCAP\u0003K\u0003\n\u00111\u0001\u0002\u0018\"I\u00111UAS!\u0003\u0005\r\u0001\u001b\u0005\b\u0003\u000bTB\u0011BAd\u00039\u0011X-\\8wKN\u001b\u0007.\u001a3vY\u0016$B!a\u0002\u0002J\"9\u0011qLAb\u0001\u0004a\u0004bBAg5\u0011\u0005\u0011qZ\u0001\tg\u000eDW\rZ;mKRA\u0011qKAi\u0003'\f)\u000eC\u0004\u0002`\u0005-\u0007\u0019\u0001\u001f\t\u0011\u0005=\u00161\u001aa\u0001\u0003cCq!!/\u0002L\u0002\u0007A\u0004C\u0004\u0002Nj!\t!!7\u0015\u0011\u0005]\u00131\\Ao\u0003KDq!a\u0018\u0002X\u0002\u0007A\b\u0003\u0005\u00020\u0006]\u0007\u0019AAp!\r\u0019\u0012\u0011]\u0005\u0004\u0003G$\"AD!di>\u00148+\u001a7fGRLwN\u001c\u0005\b\u0003s\u000b9\u000e1\u0001\u001d\u0011\u001d\tiM\u0007C\u0001\u0003S$\u0002\"a\u0016\u0002l\u00065\u0018Q\u001f\u0005\b\u0003?\n9\u000f1\u0001=\u0011!\ty+a:A\u0002\u0005=\bc\u0001\u001a\u0002r&\u0019\u00111_\u001a\u0003\u0017\u00153XM\u001c;TiJ,\u0017-\u001c\u0005\b\u0003s\u000b9\u000f1\u0001\u001d\u0011\u001d\tiM\u0007C\u0001\u0003s$\"\"a\u0016\u0002|\u0006u\u0018q B\u0001\u0011\u001d\ty&a>A\u0002qB\u0001\"a,\u0002x\u0002\u0007\u0011\u0011\u0017\u0005\b\u0003s\u000b9\u00101\u0001\u001d\u0011!\u0011\u0019!a>A\u0002\u0005E\u0013!C:uCJ$H)\u0019;f\u0011\u001d\tiM\u0007C\u0001\u0005\u000f!\"\"a\u0016\u0003\n\t-!Q\u0002B\b\u0011\u001d\tyF!\u0002A\u0002qB\u0001\"a,\u0003\u0006\u0001\u0007\u0011q\u001c\u0005\b\u0003s\u0013)\u00011\u0001\u001d\u0011!\u0011\u0019A!\u0002A\u0002\u0005E\u0003bBAg5\u0011\u0005!1\u0003\u000b\u000b\u0003/\u0012)Ba\u0006\u0003\u001a\tm\u0001bBA0\u0005#\u0001\r\u0001\u0010\u0005\t\u0003_\u0013\t\u00021\u0001\u0002p\"9\u0011\u0011\u0018B\t\u0001\u0004a\u0002\u0002\u0003B\u0002\u0005#\u0001\r!!\u0015\t\u000f\t}!\u0004\"\u0003\u0003\"\u0005\u00012o\u00195fIVdW-\u00138uKJt\u0017\r\u001c\u000b\u000b\u0003/\u0012\u0019C!\n\u0003(\t%\u0002bBA0\u0005;\u0001\r\u0001\u0010\u0005\b\u0003_\u0013i\u00021\u0001\u001d\u0011\u001d\tIL!\bA\u0002qA\u0001Ba\u0001\u0003\u001e\u0001\u0007\u0011\u0011\u000b\u0005\b\u0005[QB\u0011\u0003B\u0018\u0003-\u00198\r[3ek2,'j\u001c2\u0015\u0015\tE\"Q\u0007B\u001c\u0005s\u0011Y\u0004\u0006\u0003\u0002X\tM\u0002bBAg\u0005W\u0001\r! \u0005\b\u0003?\u0012Y\u00031\u0001=\u0011\u001d\tyKa\u000bA\u0002qAq!!/\u0003,\u0001\u0007A\u0004\u0003\u0005\u0003\u0004\t-\u0002\u0019AA)\u0011\u001d\u0011yD\u0007C\t\u0003w\t1#\u001b8ji&\fG.[:f\u0007\u0006dWM\u001c3beND!Ba\u0011\u001b\u0011\u000b\u0007I\u0011\u0003B#\u0003)!\bN]3bIB{w\u000e\\\u000b\u0003\u0005\u000f\u0002BA!\u0013\u0003P5\u0011!1\n\u0006\u0005\u0005\u001b\nI#A\u0003tS6\u0004H.\u0003\u0003\u0003R\t-#\u0001E*j[BdW\r\u00165sK\u0006$\u0007k\\8m\u0011)\u0011)F\u0007E\u0001B\u0003&!qI\u0001\fi\"\u0014X-\u00193Q_>d\u0007\u0005\u0003\u0006\u0003ZiA)\u0019!C\t\u00057\n\u0001B[8c'R|'/Z\u000b\u0003\u0005;\u0002BA!\u0013\u0003`%!!\u0011\rB&\u0005-\u0011\u0016)\u0014&pEN#xN]3\t\u0015\t\u0015$\u0004#A!B\u0013\u0011i&A\u0005k_\n\u001cFo\u001c:fA!Q!\u0011\u000e\u000e\t\u0006\u0004%\tBa\u001b\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XC\u0001B7!\u0011\t9Ca\u001c\n\t\tE\u0014\u0011\u0006\u0002\n'\u000eDW\rZ;mKJD!B!\u001e\u001b\u0011\u0003\u0005\u000b\u0015\u0002B7\u0003)\u00198\r[3ek2,'\u000f\t\u0005\n\u0005sR\u0012\u0013!C\u0001\u0005w\n!c\u001d5vi\u0012|wO\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u0010\u0016\u0004A\n}4F\u0001BA!\u0011\u0011\u0019I!$\u000e\u0005\t\u0015%\u0002\u0002BD\u0005\u0013\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-e$\u0001\u0006b]:|G/\u0019;j_:LAAa$\u0003\u0006\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\tM%$%A\u0005\u0002\tU\u0015\u0001G2sK\u0006$XmU2iK\u0012,H.\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0013\u0016\u0005\u0003/\u0013y\bC\u0005\u0003\u001cj\t\n\u0011\"\u0001\u0003\u0016\u0006A2M]3bi\u0016\u001c6\r[3ek2,G\u0005Z3gCVdG\u000f\n\u001b\t\u0013\t}%$%A\u0005\u0002\t\u0005\u0016\u0001G2sK\u0006$XmU2iK\u0012,H.\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\u0015\u0016\u0004Q\n}\u0004\"\u0003BT5E\u0005I\u0011\u0001BK\u0003]\u0011Xm]2iK\u0012,H.\u001a&pE\u0012\"WMZ1vYR$C\u0007C\u0005\u0003,j\t\n\u0011\"\u0001\u0003\u0016\u00069\"/Z:dQ\u0016$W\u000f\\3K_\n$C-\u001a4bk2$HE\u000e\u0005\n\u0005_S\u0012\u0013!C\u0001\u0005C\u000bqC]3tG\",G-\u001e7f\u0015>\u0014G\u0005Z3gCVdG\u000fJ\u001c\t\r-zA\u0011\u0001BZ)\u0005i\u0001b\u0002B\\\u001f\u0011\u0005#\u0011X\u0001\u0004O\u0016$HcA\r\u0003<\"9aE!.A\u0002\tu\u0006cA\n\u0003@&\u0019!\u0011\u0019\u000b\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c")
public class QuartzSchedulerExtension
implements Extension {
    private final ExtendedActorSystem system;
    private final LoggingAdapter com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log;
    private final Config config;
    private Config defaultConfig;
    private final int threadCount;
    private final int threadPriority;
    private final boolean daemonThreads_$qmark;
    private final TimeZone defaultTimezone;
    private scala.collection.immutable.Map<String, QuartzSchedule> schedules;
    private final scala.collection.mutable.Map<String, JobKey> runningJobs;
    private SimpleThreadPool threadPool;
    private RAMJobStore jobStore;
    private Scheduler scheduler;
    private volatile byte bitmap$0;

    public static QuartzSchedulerExtension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static Extension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.apply(actorSystem);
    }

    public static Extension createExtension(ExtendedActorSystem extendedActorSystem) {
        return QuartzSchedulerExtension$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ExtensionId<QuartzSchedulerExtension> lookup() {
        return QuartzSchedulerExtension$.MODULE$.lookup();
    }

    private Config defaultConfig$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.defaultConfig = ConfigFactory.parseString((String)new StringOps(Predef$.MODULE$.augmentString("\n    akka.quartz {\n      threadPool {\n        threadCount = 1\n        threadPriority = 5\n        daemonThreads = true\n      }\n      defaultTimezone = UTC\n    }\n                                                      ")).stripMargin());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.defaultConfig;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SimpleThreadPool threadPool$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                SimpleThreadPool _tp = new SimpleThreadPool(this.threadCount(), this.threadPriority());
                _tp.setThreadNamePrefix("AKKA_QRTZ_");
                _tp.setMakeThreadsDaemons(this.daemonThreads_$qmark());
                this.threadPool = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.threadPool;
        }
    }

    private RAMJobStore jobStore$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.jobStore = new RAMJobStore();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.jobStore;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Scheduler scheduler$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                void var2_2;
                DirectSchedulerFactory.getInstance().createScheduler(this.schedulerName(), this.system.name(), (ThreadPool)this.threadPool(), (JobStore)this.jobStore());
                Scheduler scheduler2 = DirectSchedulerFactory.getInstance().getScheduler(this.schedulerName());
                this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().debug("Initialized a Quartz Scheduler '{}'", (Object)scheduler2);
                this.system.registerOnTermination((Function0)new Serializable(this, scheduler2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ QuartzSchedulerExtension $outer;
                    private final Scheduler scheduler$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Shutting down Quartz Scheduler with ActorSystem Termination (Any jobs awaiting completion will end as well, as actors are ending)...");
                        this.scheduler$1.shutdown(false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.scheduler$1 = scheduler$1;
                    }
                });
                this.scheduler = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.scheduler;
        }
    }

    public LoggingAdapter com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log() {
        return this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log;
    }

    public String schedulerName() {
        return new StringOps(Predef$.MODULE$.augmentString("QuartzScheduler~%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.system.name()}));
    }

    public Config config() {
        return this.config;
    }

    public Config defaultConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.defaultConfig$lzycompute() : this.defaultConfig;
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int threadPriority() {
        return this.threadPriority;
    }

    public boolean daemonThreads_$qmark() {
        return this.daemonThreads_$qmark;
    }

    public TimeZone defaultTimezone() {
        return this.defaultTimezone;
    }

    public scala.collection.immutable.Map<String, QuartzSchedule> schedules() {
        return this.schedules;
    }

    public void schedules_$eq(scala.collection.immutable.Map<String, QuartzSchedule> x$1) {
        this.schedules = x$1;
    }

    public scala.collection.mutable.Map<String, JobKey> runningJobs() {
        return this.runningJobs;
    }

    public void standby() {
        this.scheduler().standby();
    }

    public boolean isInStandbyMode() {
        return this.scheduler().isInStandbyMode();
    }

    public boolean start() {
        boolean bl;
        block4: {
            boolean bl2;
            block3: {
                block2: {
                    bl = this.isStarted();
                    if (!bl) break block2;
                    this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().warning("Cannot start scheduler, already started.");
                    bl2 = false;
                    break block3;
                }
                if (bl) break block4;
                this.scheduler().start();
                bl2 = true;
            }
            return bl2;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public boolean isStarted() {
        return this.scheduler().isStarted();
    }

    public Option<Date> nextTrigger(String name) {
        return this.runningJobs().get((Object)name).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuartzSchedulerExtension $outer;

            public final Option<Date> apply(JobKey jobKey) {
                return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.$outer.scheduler().getTriggersOfJob(jobKey)).asScala()).headOption().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Date apply(Trigger trigger) {
                        return trigger.getNextFireTime();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void suspendAll() {
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Suspending all Quartz jobs.");
        this.scheduler().pauseAll();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.scheduler().shutdown(waitForJobsToComplete);
    }

    public boolean shutdown$default$1() {
        return false;
    }

    public boolean suspendJob(String name) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.runningJobs().get((Object)name);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    JobKey job = (JobKey)some.x();
                    this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Suspending Quartz Job '{}'", (Object)name);
                    this.scheduler().pauseJob(job);
                    bl = true;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().warning("No running Job named '{}' found: Cannot suspend", (Object)name);
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public boolean resumeJob(String name) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.runningJobs().get((Object)name);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    JobKey job = (JobKey)some.x();
                    this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Resuming Quartz Job '{}'", (Object)name);
                    this.scheduler().resumeJob(job);
                    bl = true;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().warning("No running Job named '{}' found: Cannot unpause", (Object)name);
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public void resumeAll() {
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Resuming all Quartz jobs.");
        this.scheduler().resumeAll();
    }

    public boolean cancelJob(String name) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.runningJobs().get((Object)name);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    JobKey job = (JobKey)some.x();
                    this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Cancelling Quartz Job '{}'", (Object)name);
                    boolean result = this.scheduler().deleteJob(job);
                    this.runningJobs().$minus$eq((Object)name);
                    bl = result;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().warning("No running Job named '{}' found: Cannot cancel", (Object)name);
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public void createSchedule(String name, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        Option option = this.schedules().get((Object)name.toUpperCase());
        if (option instanceof Some) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A schedule with this name already exists: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        if (None$.MODULE$.equals(option)) {
            Either either = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class})).either((Function0)new Serializable(this, cronExpression){
                public static final long serialVersionUID = 0L;
                private final String cronExpression$1;

                public final CronExpression apply() {
                    return new CronExpression(this.cronExpression$1);
                }
                {
                    this.cronExpression$1 = cronExpression$1;
                }
            });
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.a();
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid 'expression' for Cron Schedule '", "'. Failed to validate CronExpression."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (either instanceof Right) {
                CronExpression expr;
                CronExpression cronExpression2;
                Right right = (Right)either;
                CronExpression expression = cronExpression2 = (expr = (CronExpression)right.b());
                QuartzCronSchedule quartzSchedule = new QuartzCronSchedule(name, description, expression, timezone, calendar);
                this.schedules_$eq((scala.collection.immutable.Map<String, QuartzSchedule>)this.schedules().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name.toUpperCase()), (Object)quartzSchedule)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new MatchError((Object)either);
        }
        throw new MatchError((Object)option);
    }

    public Option<String> createSchedule$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createSchedule$default$4() {
        return None$.MODULE$;
    }

    public TimeZone createSchedule$default$5() {
        return this.defaultTimezone();
    }

    public Date rescheduleJob(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.cancelJob(name);
        this.removeSchedule(name);
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Option<String> rescheduleJob$default$4() {
        return None$.MODULE$;
    }

    public Option<String> rescheduleJob$default$6() {
        return None$.MODULE$;
    }

    public TimeZone rescheduleJob$default$7() {
        return this.defaultTimezone();
    }

    private void removeSchedule(String name) {
        this.schedules_$eq((scala.collection.immutable.Map<String, QuartzSchedule>)((scala.collection.immutable.Map)this.schedules().$minus((Object)name.toUpperCase())));
    }

    public Date schedule(String name, ActorRef receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, EventStream receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorRef receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, EventStream receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    private Date scheduleInternal(String name, Object receiver, Object msg, Option<Date> startDate) {
        Option option = this.schedules().get((Object)name.toUpperCase());
        if (option instanceof Some) {
            Some some = (Some)option;
            QuartzSchedule schedule = (QuartzSchedule)some.x();
            Date date = this.scheduleJob(name, receiver, msg, startDate, schedule);
            return date;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("No matching quartz configuration found for schedule '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        throw new MatchError((Object)option);
    }

    public Date scheduleJob(String name, Object receiver, Object msg, Option<Date> startDate, QuartzSchedule schedule) {
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Setting up scheduled job '{}', with '{}'", (Object)name, (Object)schedule);
        scala.collection.immutable.Map jobDataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logBus"), (Object)this.system.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"receiver"), receiver), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), msg)}));
        JobDataMap jobData = JobDataMapSupport.newJobDataMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)jobDataMap).asJava()));
        JobDetail job = JobBuilder.newJob(SimpleActorMessageJob.class).withIdentity(new StringBuilder().append((Object)name).append((Object)"_Job").toString()).usingJobData(jobData).withDescription((String)schedule.description().orNull(Predef$.MODULE$.$conforms())).build();
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().debug("Adding jobKey {} to runningJobs map.", (Object)job.getKey());
        this.runningJobs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)job.getKey()));
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().debug("Building Trigger with startDate '{}", startDate.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Date apply() {
                return new Date();
            }
        }));
        Trigger trigger = schedule.buildTrigger(name, startDate);
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().debug("Scheduling Job '{}' and Trigger '{}'. Is Scheduler Running? {}", (Object)job, (Object)trigger, (Object)BoxesRunTime.boxToBoolean((boolean)this.scheduler().isStarted()));
        return this.scheduler().scheduleJob(job, trigger);
    }

    public void initialiseCalendars() {
        QuartzCalendars$.MODULE$.apply(this.config(), this.defaultTimezone()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Calendar> check$ifrefutable$1) {
                Tuple2<String, Calendar> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuartzSchedulerExtension $outer;

            public final void apply(Tuple2<String, Calendar> x$1) {
                Tuple2<String, Calendar> tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Calendar calendar = (Calendar)tuple2._2();
                    this.$outer.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Configuring Calendar '{}'", (Object)name);
                    this.$outer.scheduler().addCalendar(name.toUpperCase(), calendar, true, true);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public SimpleThreadPool threadPool() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.threadPool$lzycompute() : this.threadPool;
    }

    public RAMJobStore jobStore() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.jobStore$lzycompute() : this.jobStore;
    }

    public Scheduler scheduler() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    public QuartzSchedulerExtension(ExtendedActorSystem system) {
        this.system = system;
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this, package$.MODULE$.quartzExtensionLoggerType());
        this.config = system.settings().config().withFallback((ConfigMergeable)this.defaultConfig()).getConfig("akka.quartz").root().toConfig();
        this.threadCount = this.config().getInt("threadPool.threadCount");
        this.threadPriority = this.config().getInt("threadPool.threadPriority");
        Predef$.MODULE$.require(this.threadPriority() >= 1 && this.threadPriority() <= 10, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Quartz Thread Priority (akka.quartz.threadPool.threadPriority) must be a positive integer between 1 (lowest) and 10 (highest).";
            }
        });
        this.daemonThreads_$qmark = this.config().getBoolean("threadPool.daemonThreads");
        this.defaultTimezone = TimeZone.getTimeZone(this.config().getString("defaultTimezone"));
        this.schedules = (scala.collection.immutable.Map)QuartzSchedules$.MODULE$.apply(this.config(), this.defaultTimezone()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, QuartzSchedule> apply(Tuple2<String, QuartzSchedule> kv) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((String)kv._1()).toUpperCase()), kv._2());
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        this.runningJobs = Map$.MODULE$.empty();
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().debug("Configured Schedules: {}", this.schedules());
        this.scheduler().start();
        this.initialiseCalendars();
    }
}

