/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import com.typesafe.akka.extension.quartz.QuartzCalendars$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.quartz.CronExpression;
import org.quartz.impl.calendar.AnnualCalendar;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.CronCalendar;
import org.quartz.impl.calendar.DailyCalendar;
import org.quartz.impl.calendar.HolidayCalendar;
import org.quartz.impl.calendar.MonthlyCalendar;
import org.quartz.impl.calendar.WeeklyCalendar;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class QuartzCalendars$ {
    public static final QuartzCalendars$ MODULE$;
    private final Exception.Catch<Nothing$> catchMissing;
    private final Exception.Catch<Nothing$> catchWrongType;
    private final Exception.Catch<Nothing$> catchParseErr;

    static {
        new QuartzCalendars$();
    }

    public Exception.Catch<Nothing$> catchMissing() {
        return this.catchMissing;
    }

    public Exception.Catch<Nothing$> catchWrongType() {
        return this.catchWrongType;
    }

    public Exception.Catch<Nothing$> catchParseErr() {
        return this.catchParseErr;
    }

    public scala.collection.immutable.Map<String, org.quartz.Calendar> apply(Config config, TimeZone defaultTimezone) {
        return (scala.collection.immutable.Map)this.catchMissing().opt((Function0)new Serializable(config, defaultTimezone){
            public static final long serialVersionUID = 0L;
            private final Config config$1;
            public final TimeZone defaultTimezone$1;

            public final scala.collection.immutable.Map<String, org.quartz.Calendar> apply() {
                return (scala.collection.immutable.Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.config$1.getConfig("calendars").root()).asScala()).toMap(Predef$.MODULE$.$conforms()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.apply.1 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Iterable<Tuple2<String, org.quartz.Calendar>> apply(Tuple2<String, ConfigValue> x0$1) {
                        Tuple2<String, ConfigValue> tuple2 = x0$1;
                        if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        String key = (String)tuple2._1();
                        ConfigValue value = (ConfigValue)tuple2._2();
                        if (!(value instanceof ConfigObject)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        ConfigObject configObject = (ConfigObject)value;
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)QuartzCalendars$.MODULE$.parseCalendar(key, configObject.toConfig(), this.$outer.defaultTimezone$1))));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            {
                this.config$1 = config$1;
                this.defaultTimezone$1 = defaultTimezone$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, org.quartz.Calendar> apply() {
                return Map$.MODULE$.empty();
            }
        });
    }

    public Calendar parseFmt(String raw, SimpleDateFormat fmt, TimeZone tz) {
        Calendar c = Calendar.getInstance(tz);
        c.setTime(fmt.parse(raw));
        return c;
    }

    public AnnualCalendar parseAnnualCalendar(String name, Config config, TimeZone tz) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("MM-dd");
        dateFmt.setTimeZone(tz);
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$3;

            public final List<String> apply() {
                return this.config$3.getStringList("excludeDates");
            }
            {
                this.config$3 = config$3;
            }
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.a();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDates' for Annual calendar '%s'. You must provide a list of ISO-8601 compliant dates ('YYYY-MM-DD').")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (either instanceof Right) {
            Buffer buffer;
            Right right = (Right)either;
            List dates = (List)right.b();
            Buffer excludeDates = buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dates).asScala()).map((Function1)new Serializable(name, tz, dateFmt){
                public static final long serialVersionUID = 0L;
                private final String name$1;
                public final TimeZone tz$1;
                public final SimpleDateFormat dateFmt$1;

                public final Calendar apply(String d) {
                    Either either = QuartzCalendars$.MODULE$.catchParseErr().either((Function0)new Serializable(this, d){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.5 $outer;
                        private final String d$1;

                        public final Calendar apply() {
                            return QuartzCalendars$.MODULE$.parseFmt(this.d$1, this.$outer.dateFmt$1, this.$outer.tz$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.d$1 = d$1;
                        }
                    });
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Throwable t = (Throwable)left.a();
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid date '%s' in Annual Calendar '%s' - 'excludeDates'. You must provide an ISO-8601 compliant date ('YYYY-MM-DD').")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d, this.name$1})), t);
                    }
                    if (either instanceof Right) {
                        Calendar dt;
                        Right right = (Right)either;
                        Calendar calendar = dt = (Calendar)right.b();
                        return calendar;
                    }
                    throw new MatchError((Object)either);
                }
                {
                    this.name$1 = name$1;
                    this.tz$1 = tz$1;
                    this.dateFmt$1 = dateFmt$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            AnnualCalendar cal = new AnnualCalendar();
            cal.setDaysExcluded(new ArrayList((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(excludeDates).asJava()));
            return cal;
        }
        throw new MatchError((Object)either);
    }

    public HolidayCalendar parseHolidayCalendar(String name, Config config, TimeZone tz) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        dateFmt.setTimeZone(tz);
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$4;

            public final List<String> apply() {
                return this.config$4.getStringList("excludeDates");
            }
            {
                this.config$4 = config$4;
            }
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.a();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDates' for Holiday Calendar '%s'. You must provide a list of ISO-8601 compliant dates ('YYYY-MM-DD').")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (either instanceof Right) {
            Buffer buffer;
            Right right = (Right)either;
            List dates = (List)right.b();
            Buffer excludeDates = buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dates).asScala()).map((Function1)new Serializable(name, tz, dateFmt){
                public static final long serialVersionUID = 0L;
                private final String name$2;
                public final TimeZone tz$2;
                public final SimpleDateFormat dateFmt$2;

                public final Date apply(String d) {
                    Either either = QuartzCalendars$.MODULE$.catchParseErr().either((Function0)new Serializable(this, d){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.8 $outer;
                        private final String d$2;

                        public final Date apply() {
                            return QuartzCalendars$.MODULE$.parseFmt(this.d$2, this.$outer.dateFmt$2, this.$outer.tz$2).getTime();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.d$2 = d$2;
                        }
                    });
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Throwable t = (Throwable)left.a();
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid date '%s' in Holiday Calendar '%s' - 'excludeDates'. You must provide an ISO-8601 compliant date ('YYYY-MM-DD').")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d, this.name$2})), t);
                    }
                    if (either instanceof Right) {
                        Date dt;
                        Right right = (Right)either;
                        Date date = dt = (Date)right.b();
                        return date;
                    }
                    throw new MatchError((Object)either);
                }
                {
                    this.name$2 = name$2;
                    this.tz$2 = tz$2;
                    this.dateFmt$2 = dateFmt$2;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            HolidayCalendar cal = new HolidayCalendar();
            excludeDates.foreach((Function1)new Serializable(cal){
                public static final long serialVersionUID = 0L;
                private final HolidayCalendar cal$1;

                public final void apply(Date x$1) {
                    this.cal$1.addExcludedDate(x$1);
                }
                {
                    this.cal$1 = cal$1;
                }
            });
            return cal;
        }
        throw new MatchError((Object)either);
    }

    public DailyCalendar parseDailyCalendar(String name, Config config) {
        String startTime = this.parseTimeEntry$1("exclude.startTime", name, config);
        String endTime = this.parseTimeEntry$1("exclude.endTime", name, config);
        return new DailyCalendar(startTime, endTime);
    }

    public WeeklyCalendar parseWeeklyCalendar(String name, Config config) {
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$6;

            public final List<Integer> apply() {
                return this.config$6.getIntList("excludeDays");
            }
            {
                this.config$6 = config$6;
            }
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.a();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDays' for Weekly Calendar '%s'. You must provide a list of Integers between 1 and 7.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (either instanceof Right) {
            Buffer buffer;
            Right right = (Right)either;
            List days = (List)right.b();
            Buffer excludeDays = buffer = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(days).asScala();
            boolean excludeWeekends = BoxesRunTime.unboxToBoolean((Object)this.catchMissing().opt((Function0)new Serializable(config){
                public static final long serialVersionUID = 0L;
                private final Config config$6;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.config$6.getBoolean("excludeWeekends");
                }
                {
                    this.config$6 = config$6;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return true;
                }
            }));
            Predef$.MODULE$.require(excludeDays.forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Integer d) {
                    return Predef$.MODULE$.Integer2int(d) <= 7 && Predef$.MODULE$.Integer2int(d) >= 1;
                }
            }), (Function0)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$4;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Weekly Calendar '%s' - 'excludeDays' must consist of a list of Integers between 1 and 7")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$4}));
                }
                {
                    this.name$4 = name$4;
                }
            });
            WeeklyCalendar cal = new WeeklyCalendar();
            excludeDays.foreach((Function1)new Serializable(cal){
                public static final long serialVersionUID = 0L;
                private final WeeklyCalendar cal$2;

                public final void apply(Integer x$1) {
                    this.cal$2.setDayExcluded(Predef$.MODULE$.Integer2int(x$1), true);
                }
                {
                    this.cal$2 = cal$2;
                }
            });
            if (!excludeWeekends) {
                if (excludeDays.contains((Object)BoxesRunTime.boxToInteger((int)7)) || excludeDays.contains((Object)BoxesRunTime.boxToInteger((int)1))) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Weekly Calendar '%s' - Cannot set 'excludeWeekends' to false when you have explicitly excluded Saturday (7) or Sunday (1)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
                cal.setDayExcluded(1, false);
                cal.setDayExcluded(7, false);
            }
            return cal;
        }
        throw new MatchError((Object)either);
    }

    public MonthlyCalendar parseMonthlyCalendar(String name, Config config) {
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$7;

            public final List<Integer> apply() {
                return this.config$7.getIntList("excludeDays");
            }
            {
                this.config$7 = config$7;
            }
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.a();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDays' for Monthly Calendar '%s'. You must provide a list of Integers between 1 and 31.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (either instanceof Right) {
            Buffer buffer;
            Right right = (Right)either;
            List days = (List)right.b();
            Buffer excludeDays = buffer = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(days).asScala();
            Predef$.MODULE$.require(excludeDays.forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Integer d) {
                    return Predef$.MODULE$.Integer2int(d) <= 31 && Predef$.MODULE$.Integer2int(d) >= 1;
                }
            }), (Function0)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$5;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Monthly Calendar '%s' - 'excludeDays' must consist of a list of Integers between 1 and 31")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$5}));
                }
                {
                    this.name$5 = name$5;
                }
            });
            MonthlyCalendar cal = new MonthlyCalendar();
            excludeDays.foreach((Function1)new Serializable(cal){
                public static final long serialVersionUID = 0L;
                private final MonthlyCalendar cal$3;

                public final void apply(Integer x$2) {
                    this.cal$3.setDayExcluded(Predef$.MODULE$.Integer2int(x$2), true);
                }
                {
                    this.cal$3 = cal$3;
                }
            });
            return cal;
        }
        throw new MatchError((Object)either);
    }

    public CronCalendar parseCronCalendar(String name, Config config) {
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$8;

            public final String apply() {
                return this.config$8.getString("excludeExpression");
            }
            {
                this.config$8 = config$8;
            }
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.a();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeExpression' for Cron Calendar '%s'. You must provide a valid Quartz CronExpression.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String expr = (String)right.b();
            Either either2 = this.catchParseErr().either((Function0)new Serializable(expr){
                public static final long serialVersionUID = 0L;
                private final String expr$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    CronExpression.validateExpression((String)this.expr$1);
                }
                {
                    this.expr$1 = expr$1;
                }
            });
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                Throwable t = (Throwable)left.a();
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid 'excludeExpression' for Cron Calendar '%s'. Failed to validate CronExpression.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (either2 instanceof Right) {
                String string;
                String string2;
                String exclude = string2 = (string = expr);
                CronCalendar cal = new CronCalendar(exclude);
                return cal;
            }
            throw new MatchError((Object)either2);
        }
        throw new MatchError((Object)either);
    }

    public org.quartz.Calendar parseCalendar(String name, Config config, TimeZone defaultTimezone) {
        Either either;
        block4: {
            String string;
            block11: {
                AnnualCalendar annualCalendar;
                Option description;
                TimeZone timezone;
                block6: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        timezone = (TimeZone)this.catchMissing().opt((Function0)new Serializable(config){
                                            public static final long serialVersionUID = 0L;
                                            private final Config config$2;

                                            public final TimeZone apply() {
                                                return TimeZone.getTimeZone(this.config$2.getString("timezone"));
                                            }
                                            {
                                                this.config$2 = config$2;
                                            }
                                        }).getOrElse((Function0)new Serializable(defaultTimezone){
                                            public static final long serialVersionUID = 0L;
                                            private final TimeZone defaultTimezone$2;

                                            public final TimeZone apply() {
                                                return this.defaultTimezone$2;
                                            }
                                            {
                                                this.defaultTimezone$2 = defaultTimezone$2;
                                            }
                                        });
                                        description = this.catchMissing().opt((Function0)new Serializable(config){
                                            public static final long serialVersionUID = 0L;
                                            private final Config config$2;

                                            public final String apply() {
                                                return this.config$2.getString("description");
                                            }
                                            {
                                                this.config$2 = config$2;
                                            }
                                        });
                                        either = this.catchMissing().either((Function0)new Serializable(config){
                                            public static final long serialVersionUID = 0L;
                                            private final Config config$2;

                                            public final String apply() {
                                                return this.config$2.getString("type");
                                            }
                                            {
                                                this.config$2 = config$2;
                                            }
                                        });
                                        if (either instanceof Left) {
                                            throw new IllegalArgumentException(new StringBuilder().append((Object)"Calendar Type must be defined for ").append((Object)name).toString());
                                        }
                                        if (!(either instanceof Right)) break block4;
                                        Right right = (Right)either;
                                        String typ = (String)right.b();
                                        string = typ.toUpperCase();
                                        if (!"ANNUAL".equals(string)) break block5;
                                        annualCalendar = this.parseAnnualCalendar(name, config, timezone);
                                        break block6;
                                    }
                                    if (!"HOLIDAY".equals(string)) break block7;
                                    annualCalendar = this.parseHolidayCalendar(name, config, timezone);
                                    break block6;
                                }
                                if (!"DAILY".equals(string)) break block8;
                                annualCalendar = this.parseDailyCalendar(name, config);
                                break block6;
                            }
                            if (!"MONTHLY".equals(string)) break block9;
                            annualCalendar = this.parseMonthlyCalendar(name, config);
                            break block6;
                        }
                        if (!"WEEKLY".equals(string)) break block10;
                        annualCalendar = this.parseWeeklyCalendar(name, config);
                        break block6;
                    }
                    if (!"CRON".equals(string)) break block11;
                    annualCalendar = this.parseCronCalendar(name, config);
                }
                AnnualCalendar cal = annualCalendar;
                description.foreach((Function1)new Serializable((BaseCalendar)cal){
                    public static final long serialVersionUID = 0L;
                    private final BaseCalendar cal$4;

                    public final void apply(String x$1) {
                        this.cal$4.setDescription(x$1);
                    }
                    {
                        this.cal$4 = cal$4;
                    }
                });
                cal.setTimeZone(timezone);
                AnnualCalendar annualCalendar2 = cal;
                return annualCalendar2;
            }
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Unknown Quartz Calendar type '%s' for calendar '%s'. Valid types are Annual, Holiday, Daily, Monthly, Weekly, and Cron.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, name})));
        }
        throw new MatchError((Object)either);
    }

    private final String parseTimeEntry$1(String entry, String name$3, Config config$5) {
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0)new Serializable(config$5, entry){
            public static final long serialVersionUID = 0L;
            private final Config config$5;
            private final String entry$1;

            public final String apply() {
                return this.config$5.getString(this.entry$1);
            }
            {
                this.config$5 = config$5;
                this.entry$1 = entry$1;
            }
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.a();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry '%s' for Daily Calendar '%s'. You must provide a time in the format 'HH:MM[:SS[:mmm]]'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entry, name$3})), t);
        }
        if (either instanceof Right) {
            String rawTime;
            Right right = (Right)either;
            String string = rawTime = (String)right.b();
            return string;
        }
        throw new MatchError((Object)either);
    }

    private QuartzCalendars$() {
        MODULE$ = this;
        this.catchMissing = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.Missing.class}));
        this.catchWrongType = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.WrongType.class}));
        this.catchParseErr = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class}));
    }
}

