/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;

public final class SecurityJackson2Modules {
    private static final Log logger = LogFactory.getLog(SecurityJackson2Modules.class);
    private static final List<String> securityJackson2ModuleClasses = Arrays.asList("org.springframework.security.jackson2.CoreJackson2Module", "org.springframework.security.cas.jackson2.CasJackson2Module", "org.springframework.security.web.jackson2.WebJackson2Module");

    private SecurityJackson2Modules() {
    }

    public static void enableDefaultTyping(ObjectMapper mapper) {
        TypeResolverBuilder typeBuilder;
        if (mapper != null && (typeBuilder = mapper.getDeserializationConfig().getDefaultTyper(null)) == null) {
            mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        }
    }

    private static Module loadAndGetInstance(String className, ClassLoader loader) {
        Module instance;
        block4: {
            instance = null;
            try {
                Class securityModule = ClassUtils.forName((String)className, (ClassLoader)loader);
                if (securityModule != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Loaded module " + className + ", now registering"));
                    }
                    instance = (Module)securityModule.newInstance();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)("Cannot load module " + className), (Throwable)e);
            }
        }
        return instance;
    }

    public static List<Module> getModules(ClassLoader loader) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (String className : securityJackson2ModuleClasses) {
            Module module = SecurityJackson2Modules.loadAndGetInstance(className, loader);
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }
}

