/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.crsh.ssh.util.KeyPairUtils;
import org.crsh.vfs.Resource;

public class URLKeyPairProvider
extends AbstractKeyPairProvider {
    private static final Logger log = Logger.getLogger(URLKeyPairProvider.class.getName());
    private final Resource key;

    public URLKeyPairProvider(Resource key) {
        this.key = key;
    }

    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>();
        if (this.key != null) {
            try {
                Object o = KeyPairUtils.readKey(new InputStreamReader(new ByteArrayInputStream(this.key.getContent())));
                if (o instanceof KeyPair) {
                    keys.add((KeyPair)o);
                } else if (o instanceof PEMKeyPair) {
                    JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                    keys.add(converter.getKeyPair((PEMKeyPair)o));
                }
            }
            catch (Exception e) {
                log.log(Level.INFO, "Unable to read key " + this.key + ": " + this.key, e);
            }
        }
        return keys;
    }
}

