/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.server.directives;

import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.directives.BasicDirectives$;
import akka.http.scaladsl.server.directives.CodingDirectives$;
import akka.http.scaladsl.server.directives.ContentTypeResolver;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives$class;
import akka.http.scaladsl.server.directives.RangeDirectives$;
import akka.http.scaladsl.server.util.TupleOps$Join$;
import akka.http.scaladsl.settings.RoutingSettings;
import java.io.File;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple1;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;

public final class FileAndResourceDirectives$
implements FileAndResourceDirectives {
    public static final FileAndResourceDirectives$ MODULE$;
    private final Directive<Tuple1<RoutingSettings>> akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupportAndExtractSettings;

    static {
        new FileAndResourceDirectives$();
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(String fileName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives$class.getFromFile((FileAndResourceDirectives)this, fileName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentTypeResolver resolver) {
        return FileAndResourceDirectives$class.getFromFile((FileAndResourceDirectives)this, file, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentType contentType) {
        return FileAndResourceDirectives$class.getFromFile((FileAndResourceDirectives)this, file, contentType);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives$class.getFromResource(this, resourceName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentType contentType, ClassLoader classLoader) {
        return FileAndResourceDirectives$class.getFromResource(this, resourceName, contentType, classLoader);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromDirectory(String directoryName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives$class.getFromDirectory(this, directoryName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> listDirectoryContents(Seq<String> directories, FileAndResourceDirectives.DirectoryRenderer renderer) {
        return FileAndResourceDirectives$class.listDirectoryContents(this, directories, renderer);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectory(String directory, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return FileAndResourceDirectives$class.getFromBrowseableDirectory(this, directory, renderer, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectories(Seq<String> directories, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return FileAndResourceDirectives$class.getFromBrowseableDirectories(this, directories, renderer, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResourceDirectory(String directoryName, ClassLoader classLoader, ContentTypeResolver resolver) {
        return FileAndResourceDirectives$class.getFromResourceDirectory(this, directoryName, classLoader, resolver);
    }

    @Override
    public ClassLoader _defaultClassLoader() {
        return FileAndResourceDirectives$class._defaultClassLoader(this);
    }

    @Override
    public ClassLoader getFromResource$default$3() {
        return FileAndResourceDirectives$class.getFromResource$default$3(this);
    }

    @Override
    public ClassLoader getFromResourceDirectory$default$2() {
        return FileAndResourceDirectives$class.getFromResourceDirectory$default$2(this);
    }

    public Directive<Tuple1<RoutingSettings>> akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupportAndExtractSettings() {
        return this.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupportAndExtractSettings;
    }

    public String akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withTrailingSlash(String path2) {
        return path2.endsWith("/") ? path2 : new scala.collection.mutable.StringBuilder().append((Object)path2).append((Object)BoxesRunTime.boxToCharacter((char)'/')).toString();
    }

    public String akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath(String basePath, Uri.Path path2, LoggingAdapter log, char separator) {
        String string = this.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(basePath, path2, log, separator);
        String string2 = "".equals(string) ? "" : this.checkIsSafeDescendant(basePath, string, log);
        return string2;
    }

    public char akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath$default$4() {
        return File.separatorChar;
    }

    public String akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(String base, Uri.Path path2, LoggingAdapter log, char separator) {
        return this.rec$1(path2.startsWithSlash() ? path2.tail() : path2, this.rec$default$2$1(base), base, path2, log, separator);
    }

    private char safeJoinPaths$default$4() {
        return File.separatorChar;
    }

    private String checkIsSafeDescendant(String basePath, String finalPath, LoggingAdapter log) {
        String string;
        File baseFile = new File(basePath);
        File finalFile = new File(finalPath);
        String canonicalFinalPath = finalFile.getCanonicalPath();
        if (canonicalFinalPath.startsWith(baseFile.getCanonicalPath())) {
            string = canonicalFinalPath;
        } else {
            log.warning(new scala.collection.mutable.StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] points to a location that is not part of [", "]. This might be a directory "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{finalFile, baseFile}))).append((Object)"traversal attempt.").toString());
            string = "";
        }
        return string;
    }

    private final String rec$1(Uri.Path p, StringBuilder result, String base$1, Uri.Path path$1, LoggingAdapter log$1, char separator$1) {
        Uri.Path path2;
        while (true) {
            Uri.Path.SlashOrEmpty tail;
            String head2;
            block8: {
                String string;
                block6: {
                    block7: {
                        block5: {
                            if (!Uri.Path$.Empty$.MODULE$.equals(path2 = p)) break block5;
                            string = result.toString();
                            break block6;
                        }
                        if (path2 instanceof Uri.Path$.Slash) {
                            Uri.Path$.Slash slash = (Uri.Path$.Slash)path2;
                            Uri.Path tail2 = slash.tail();
                            result = result.append(separator$1);
                            p = tail2;
                            continue;
                        }
                        if (!(path2 instanceof Uri.Path$.Segment)) break;
                        Uri.Path$.Segment segment = (Uri.Path$.Segment)path2;
                        head2 = segment.head();
                        tail = segment.tail();
                        if (head2.indexOf(47) >= 0 || head2.indexOf(92) >= 0) break block7;
                        String string2 = head2;
                        String string3 = "..";
                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block8;
                    }
                    log$1.warning("File-system path for base [{}] and Uri.Path [{}] contains suspicious path segment [{}], GET access was disallowed", (Object)base$1, (Object)path$1, (Object)head2);
                    string = "";
                }
                return string;
            }
            result = result.append(head2);
            p = tail;
        }
        throw new MatchError((Object)path2);
    }

    private final StringBuilder rec$default$2$1(String base$1) {
        return new StringBuilder(base$1);
    }

    private FileAndResourceDirectives$() {
        MODULE$ = this;
        FileAndResourceDirectives$class.$init$(this);
        this.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupportAndExtractSettings = (Directive)((Directive)RangeDirectives$.MODULE$.withRangeSupport().$amp(ConjunctionMagnet$.MODULE$.fromDirective(CodingDirectives$.MODULE$.withPrecompressedMediaTypeSupport(), TupleOps$Join$.MODULE$.join0P()))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(BasicDirectives$.MODULE$.extractSettings(), TupleOps$Join$.MODULE$.join0P()));
    }
}

