/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.jcr;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.util.DevNull;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import com.xebialabs.xlrelease.upgrade.Components;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.function.Supplier;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLRelease452AddFileUriFieldToAttachments
extends JcrUpgrade {
    private static final String VERSION = "4.6.0-alpha-2";
    private static final Logger logger = LoggerFactory.getLogger(XLRelease452AddFileUriFieldToAttachments.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Add fileUri field to all attachments ***", (Object)"XL Release", (Object)VERSION);
        logger.info("*** This upgrade can take several minutes depending on the amount of attachments you currently have in your repository ***");
        try {
            for (Type t : DescriptorRegistry.getSubtypes((Type)Type.valueOf((String)"udm.SourceArtifact"))) {
                logger.info("Searching all nodes of type {}", (Object)t);
                for (Node node : repository.findNodesByType(t)) {
                    String ciId = JcrPathHelper.getIdFromAbsolutePath((String)node.getPath());
                    if (!node.hasProperty("fileUri")) {
                        logger.debug("Updating {} property of {}", (Object)"fileUri", (Object)ciId);
                        String filename = node.getProperty("$filename").getString();
                        node.setProperty("fileUri", String.format("jcr:%s", URLEncoder.encode(filename, Charsets.UTF_8.name())));
                    }
                    if (node.hasProperty("checksum")) continue;
                    logger.debug("Updating {} property of {}", (Object)"checksum", (Object)ciId);
                    try {
                        String checksum = this.calculateChecksum(t, node);
                        node.setProperty("checksum", checksum);
                    }
                    catch (IOException e) {
                        logger.warn("An error occurred while calculating checksum for {}. {}", (Object)node.getPath(), (Object)e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new UpgradeException(String.format("Failed to run %s", ((Object)((Object)this)).getClass().getSimpleName()), e);
        }
        logger.info("*** Done {} {} upgrade -- Add fileUri field to all attachments ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)VERSION);
    }

    private String calculateChecksum(Type type, Node node) throws IOException {
        MessageDigest sha1 = JavaCryptoUtils.getSha1();
        Supplier<InputStream> inputSupplier = this.getDataInputSupplier(node);
        if (type.isSubTypeOf(Type.valueOf(FolderArtifact.class))) {
            Exploder.calculateCheckSum(inputSupplier, (MessageDigest)sha1);
        } else {
            try (InputStream is = inputSupplier.get();){
                ByteStreams.copy((InputStream)new DigestInputStream(is, sha1), (OutputStream)new DevNull());
            }
        }
        return JavaCryptoUtils.digest((MessageDigest)sha1);
    }

    private Supplier<InputStream> getDataInputSupplier(Node node) {
        return () -> {
            try {
                return node.getProperty("$data").getBinary().getStream();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

