/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.jcr;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.upgrade.Components;
import com.xebialabs.xlrelease.upgrade.jcr.XLRelease40CustomTasksUseServerCI;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XLRelease408AllowConcurrentReleasesFromTrigger
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease40CustomTasksUseServerCI.class);
    private static final String VERSION = "4.0.8";
    private RepositoryService repositoryService;

    @Autowired
    public XLRelease408AllowConcurrentReleasesFromTrigger(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean doUpgrade() throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Active concurrent releases from trigger on the templates ***", (Object)"XL Release", (Object)VERSION);
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Release.class)).addOrPropertiesExpression("status", (Set)Sets.newHashSet((Object[])new String[]{ReleaseStatus.TEMPLATE.name()}));
        List templates = this.repositoryService.listEntities(query);
        for (Release template : templates) {
            template.setAllowConcurrentReleasesFromTrigger(true);
            this.repositoryService.update((ConfigurationItem[])new Release[]{template});
        }
        logger.info("*** Done {} {} upgrade -- Active concurrent releases from trigger on the templates ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)VERSION);
    }
}

