/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.jcr;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.repository.Configurations;
import com.xebialabs.xlrelease.upgrade.Components;
import com.xebialabs.xlrelease.upgrade.jcr.FieldToServerCI;
import com.xebialabs.xlrelease.upgrade.jcr.XLRelease40CustomTasksUseServerCI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XLRelease407TriggersUseRepositoryCI
extends JcrUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease40CustomTasksUseServerCI.class);
    private static final String VERSION = "4.0.7";
    private RepositoryService repositoryService;
    private Configurations configurations;

    @Autowired
    public XLRelease407TriggersUseRepositoryCI(RepositoryService repositoryService, Configurations configurations) {
        this.repositoryService = repositoryService;
        this.configurations = configurations;
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Convert Svn triggers url / username / password into a repository CI ***", (Object)"XL Release", (Object)VERSION);
        new FieldToServerCI(repository, this.repositoryService, this.configurations, "url", "svnRepository", "svn.Repository", "SVN Repository").upgrade(Lists.newArrayList((Object[])new String[]{"svn.Poll"}));
        logger.info("*** Done {} {} upgrade -- Convert Svn triggers url / username / password into a repository CI ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)VERSION);
    }
}

