/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.jcr;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.upgrade.Components;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XLRelease4012DeletedSampleTemplatesShouldNotReturn
extends JcrUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease4012DeletedSampleTemplatesShouldNotReturn.class);
    private static final String VERSION = "4.0.12";
    private RepositoryService repositoryService;

    @Autowired
    public XLRelease4012DeletedSampleTemplatesShouldNotReturn(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Deleted sample templates should not return ***", (Object)"XL Release", (Object)VERSION);
        if (this.sampleTemplatesExists()) {
            Node configurationNode = repository.read("/$configuration");
            try {
                configurationNode.setProperty("welcomeTemplatesCreated", true);
            }
            catch (RepositoryException e) {
                logger.error("Error while setting the 'templates created' flag in the repository", (Throwable)e);
            }
        }
        logger.info("*** Done {} {} upgrade -- Deleted sample templates should not return ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    private boolean sampleTemplatesExists() {
        return this.repositoryService.exists("Applications/ReleaseTemplate_configure") || this.repositoryService.exists("Applications/ReleaseTemplate_sample") || this.repositoryService.exists("Applications/ReleaseTemplate_tour") || this.repositoryService.exists("Applications/ReleaseTemplate_welcome") || this.repositoryService.exists("Applications/ReleaseTemplate_sample_with_Deployit");
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)VERSION);
    }
}

