/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.jcr;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.upgrade.Components;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLRelease30AddEditLocalSecurityPermissions
extends JcrUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease30AddEditLocalSecurityPermissions.class);
    private static final String VERSION = "3.0.0";

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Add edit local security permissions ***", (Object)"XL Release", (Object)VERSION);
        List teams = repository.findNodesByType(Type.valueOf(Team.class));
        try {
            for (Node team : teams) {
                this.upgradeTeam(team);
            }
        }
        catch (RepositoryException e) {
            throw new UpgradeException("Upgrade failed due to", (Exception)((Object)e));
        }
        logger.info("*** Done {} {} upgrade -- Add edit local security permissions ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    private void upgradeTeam(Node team) throws RepositoryException {
        String teamName = team.getProperty("teamName").getString();
        if ("Release Admin".equals(teamName)) {
            this.addPermissionToTeam(team, XLReleasePermissions.EDIT_RELEASE_SECURITY);
        } else if ("Template Owner".equals(teamName)) {
            this.addPermissionToTeam(team, XLReleasePermissions.EDIT_TEMPLATE_SECURITY);
        }
    }

    private void addPermissionToTeam(Node node, Permission extraPermission) throws RepositoryException {
        ArrayList<String> permissions = new ArrayList<String>();
        if (node.hasProperty("permissions")) {
            permissions.addAll(this.toStrings(node.getProperty("permissions").getValues()));
        }
        permissions.add(extraPermission.getPermissionName());
        node.setProperty("permissions", permissions.toArray(new String[permissions.size()]));
    }

    private List<String> toStrings(Value[] values) throws RepositoryException {
        ArrayList permissions = Lists.newArrayList();
        for (Value value : values) {
            permissions.add(value.getString());
        }
        return permissions;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)VERSION);
    }
}

