/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.jcr;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.repository.Configurations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldToServerCI {
    private static final Logger logger = LoggerFactory.getLogger(FieldToServerCI.class);
    private RawRepository repository;
    private RepositoryService repositoryService;
    private int serverSuffix = 1;
    private Configurations configurations;
    private String previousUrlProperty;
    private String newServerProperty;
    private String serverType;
    private String serverNamePrefix;

    public FieldToServerCI(RawRepository repository, RepositoryService repositoryService, Configurations configurations, String previousUrlProperty, String newServerProperty, String serverType, String serverNamePrefix) {
        this.repository = repository;
        this.repositoryService = repositoryService;
        this.configurations = configurations;
        this.previousUrlProperty = previousUrlProperty;
        this.newServerProperty = newServerProperty;
        this.serverType = serverType;
        this.serverNamePrefix = serverNamePrefix;
    }

    public void upgrade(List<String> taskTypesToUpgrade) {
        this.ensureDirIsCreated(Configurations.CUSTOM_CONFIGURATION_ROOT);
        ArrayList tasks = Lists.newArrayList();
        for (String string : taskTypesToUpgrade) {
            tasks.addAll(this.repository.findNodesByType(Type.valueOf((String)string)));
        }
        HashMap servers = Maps.newHashMap();
        try {
            for (Node task : tasks) {
                if (!task.hasProperty(this.previousUrlProperty)) continue;
                String url = task.getProperty(this.previousUrlProperty).getString();
                if (servers.containsKey(url)) {
                    Node serverNode = (Node)servers.get(url);
                    this.linkServerToTask(task, serverNode);
                    continue;
                }
                String username = null;
                if (task.hasProperty("username")) {
                    username = task.getProperty("username").getString();
                }
                String password = null;
                if (task.hasProperty("password")) {
                    password = task.getProperty("password").getString();
                }
                Configuration server = this.createNewServer(url, username, password);
                logger.info("Created server {} with url {} of type {}", new Object[]{server.getId(), url, this.serverType});
                Node serverNode = this.repository.read("/" + server.getId());
                this.linkServerToTask(task, serverNode);
                servers.put(url, serverNode);
            }
        }
        catch (RepositoryException repositoryException) {
            throw new UpgradeException("Upgrade failed due to", (Exception)((Object)repositoryException));
        }
    }

    private Configuration createNewServer(String url, String username, String password) {
        String serverId = this.configurations.getUniqueId(Configurations.CUSTOM_CONFIGURATION_ROOT);
        Configuration server = (Configuration)Type.valueOf((String)this.serverType).getDescriptor().newInstance(serverId);
        server.setProperty("url", (Object)url);
        server.setProperty("title", (Object)this.getNextServerName());
        server.setProperty("username", (Object)username);
        server.setProperty("password", (Object)password);
        this.repositoryService.create((ConfigurationItem[])new Configuration[]{server});
        return server;
    }

    private void linkServerToTask(Node task, Node serverNode) throws RepositoryException {
        task.setProperty(this.newServerProperty, serverNode);
        task.getProperty(this.previousUrlProperty).remove();
        logger.info("Linked server {} to {}", (Object)serverNode.getPath(), (Object)task.getPath());
    }

    private String getNextServerName() {
        String nextServerName = this.serverSuffix > 1 ? this.serverNamePrefix + " " + this.serverSuffix : this.serverNamePrefix;
        ++this.serverSuffix;
        return nextServerName;
    }

    public void ensureDirIsCreated(String dirID) {
        if (!this.repositoryService.exists(dirID)) {
            Directory directory = new Directory();
            directory.setId(dirID);
            this.repositoryService.create((ConfigurationItem[])new Directory[]{directory});
        }
    }
}

