/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.jcr;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.upgrade.Components;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddXLReleaseRepositoryVersion
extends JcrUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(AddXLReleaseRepositoryVersion.class);
    private static final String VERSION = "3.0.0";

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Create XL Release version node ***", (Object)"XL Release", (Object)VERSION);
        Node node = repository.read("/$configuration/versions");
        try {
            if (!node.hasProperty(Components.XL_RELEASE_COMPONENT)) {
                String currentVersion = node.getProperty("deployit").getString();
                logger.info("Creating XL Release version node with version {} ", (Object)currentVersion);
                node.setProperty(Components.XL_RELEASE_COMPONENT, currentVersion);
            } else {
                logger.info("Your repository already has XL Release version node");
            }
        }
        catch (RepositoryException e) {
            throw new UpgradeException("Upgrade failed due to", (Exception)((Object)e));
        }
        logger.info("*** Done {} {} upgrade -- Create XL Release version node ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)VERSION);
    }
}

