/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.common;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.query.JcrPredicate;
import com.xebialabs.xlrelease.repository.query.JcrQueryBuilder;
import com.xebialabs.xlrelease.upgrade.Components;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XLRelease4014AddReleaseRealFlagFieldStatus
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease4014AddReleaseRealFlagFieldStatus.class);
    private static final String VERSION = "4.5.0-alpha-3";
    private RepositoryService repositoryService;

    @Autowired
    public XLRelease4014AddReleaseRealFlagFieldStatus(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean doUpgrade() throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Add release real flag status ***", (Object)"XL Release", (Object)VERSION);
        logger.info("*** This upgrade can take several minutes depending on the amount of releases you currently have in your repository ***");
        int pageNumber = 0;
        List releases = this.repositoryService.listEntities(this.getSearchParameters(pageNumber));
        while (releases.size() > 0) {
            logger.info("Upgrading {} releases for page {}", (Object)releases.size(), (Object)pageNumber);
            this.upgradeReleases(releases);
            logger.info("Fetching page " + ++pageNumber);
            releases = this.repositoryService.listEntities(this.getSearchParameters(pageNumber));
        }
        logger.info("*** Done {} {} upgrade -- Add release real flag status ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    private void upgradeReleases(List<Release> releases) {
        ChangeSet changes = new ChangeSet();
        for (Release release : releases) {
            release.updateRealFlagStatus();
            changes.update((ConfigurationItem)release);
        }
        this.repositoryService.execute(changes);
    }

    private QueryTemplate getSearchParameters(int pageNumber) {
        QueryTemplate queryTemplate = JcrQueryBuilder.select("*").from("ci").where(JcrPredicate.as("ci", Release.class)).build();
        queryTemplate.setResultsPerPage(500L);
        queryTemplate.setPage((long)pageNumber);
        return queryTemplate;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)VERSION);
    }
}

