/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.config;

import com.xebialabs.deployit.core.rest.resteasy.OpenJcrSessionDuringRequestInterceptor;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.ScalaJcrTemplate;
import com.xebialabs.deployit.repository.HistoryService;
import com.xebialabs.deployit.repository.JcrHistoryService;
import com.xebialabs.deployit.repository.JcrQueryTemplateFactory;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.QueryTemplateFactory;
import com.xebialabs.deployit.repository.RepositoryAdapterFactory;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.JcrPermissionChecker;
import com.xebialabs.deployit.security.JcrPermissionEditor;
import com.xebialabs.deployit.security.JcrPermissionLister;
import com.xebialabs.deployit.security.JcrRoleService;
import com.xebialabs.deployit.security.PermissionChecker;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.TeamService;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.upgrade.InitializationStrategy;
import com.xebialabs.deployit.upgrade.JcrInitializationStrategy;
import com.xebialabs.deployit.upgrade.JcrUpgradeStrategy;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlplatform.repository.AdvancedRepositoryService;
import com.xebialabs.xlplatform.repository.JcrAdvancedRepositoryService;
import com.xebialabs.xlplatform.repository.JcrRepositoryMetadataService;
import com.xebialabs.xlplatform.security.JcrTeamService;
import com.xebialabs.xlplatform.upgrade.JcrRepositoryVersionService;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.repository.CalendarSearchStrategy;
import com.xebialabs.xlrelease.repository.JcrCalendarSearchStrategy;
import com.xebialabs.xlrelease.repository.JcrTaskBackup;
import com.xebialabs.xlrelease.repository.JcrUserCountStrategy;
import com.xebialabs.xlrelease.repository.JcrXlrQueries;
import com.xebialabs.xlrelease.repository.JcrXlrRepository;
import com.xebialabs.xlrelease.repository.TaskBackup;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.UserCountStrategy;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.repository.query.ArchivingReleasesStrategy;
import com.xebialabs.xlrelease.repository.spi.RepositoryQueries;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyArchivingStrategy;
import com.xebialabs.xlrelease.service.JcrArchivingReleasesStrategy;
import com.xebialabs.xlrelease.service.JcrCiIdService;
import com.xebialabs.xlrelease.service.JcrDependencyArchivingStrategy;
import com.xebialabs.xlrelease.service.JcrDependencyCollectingStrategy;
import com.xebialabs.xlrelease.service.JcrReleaseSearchService;
import com.xebialabs.xlrelease.service.NonDecryptingPasswordEncrypter;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;

@Profile(value={"jackrabbit"})
@Configuration
public class JcrConfiguration {
    private final JcrTemplate jcrTemplate;

    @Autowired
    public JcrConfiguration(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    @Bean
    public ScalaJcrTemplate scalaJcrTemplate() {
        return new ScalaJcrTemplate(this.jcrTemplate);
    }

    @Bean
    public OpenJcrSessionDuringRequestInterceptor openJcrSessionDuringRequestInterceptor() {
        return new OpenJcrSessionDuringRequestInterceptor();
    }

    @Bean
    public JcrUpgradeStrategy upgradeStrategy() {
        return new JcrUpgradeStrategy(this.jcrTemplate);
    }

    @Bean
    public RoleService roleService() {
        return new JcrRoleService(this.jcrTemplate);
    }

    @Bean
    public TeamService teamService() {
        return new JcrTeamService(this.scalaJcrTemplate(), this.roleService());
    }

    @Bean
    public JcrRepositoryVersionService repositoryVersionService() {
        return new JcrRepositoryVersionService(this.jcrTemplate);
    }

    @Bean
    public RepositoryMetadataService repositoryMetadataService() {
        return new JcrRepositoryMetadataService(this.jcrTemplate);
    }

    @Bean
    public HistoryService historyService(PasswordEncrypter passwordEncrypter) {
        return new JcrHistoryService(this.jcrTemplate, passwordEncrypter);
    }

    @Bean
    public QueryTemplateFactory queryTemplateFactory() {
        return new JcrQueryTemplateFactory();
    }

    @Bean
    public InitializationStrategy initializationStrategy() {
        return new JcrInitializationStrategy(this.jcrTemplate);
    }

    @Bean
    public PermissionEditor permissionEditor() {
        return new JcrPermissionEditor(this.jcrTemplate, this.roleService(), this.teamService());
    }

    @Bean
    public PermissionChecker xlrPermissionChecker() {
        return new JcrPermissionChecker(this.jcrTemplate, this.teamService());
    }

    @Bean
    public PermissionLister permissionLister(RepositoryService repositoryService) {
        return new JcrPermissionLister(this.jcrTemplate, repositoryService, this.teamService());
    }

    @Profile(value={"!sql"})
    @Bean
    public TaskBackup taskBackup(RepositoryService repositoryService) {
        return new JcrTaskBackup(this.jcrTemplate, repositoryService);
    }

    @Profile(value={"!sql"})
    @Bean
    public CiIdService ciIdService(RepositoryService repositoryService, ArchivedReleases archivedReleases, RepositoryQueries repositoryQueries) {
        return new JcrCiIdService(repositoryService, archivedReleases, repositoryQueries);
    }

    @Bean
    public UserCountStrategy userCountStrategy() {
        return new JcrUserCountStrategy(this.jcrTemplate);
    }

    @Profile(value={"!sql"})
    @Bean
    public JcrDependencyCollectingStrategy dependencyCollectingStrategy(RepositoryService repositoryService) {
        return new JcrDependencyCollectingStrategy(this.jcrTemplate, repositoryService);
    }

    @Profile(value={"!sql"})
    @Bean
    public DependencyArchivingStrategy dependencyArchivingStrategy(RepositoryService repositoryService, JcrDependencyCollectingStrategy dependencyCollectingStrategy) {
        return new JcrDependencyArchivingStrategy(repositoryService, dependencyCollectingStrategy);
    }

    @Bean
    public CalendarSearchStrategy calendarSearchStrategy(RepositoryService repositoryService) {
        return new JcrCalendarSearchStrategy(repositoryService);
    }

    @Profile(value={"!sql"})
    @Bean
    public ReleaseSearchService releaseSearchService(RepositoryService repositoryService, ArchivingService archivingService, PermissionEnforcer permissionEnforcer, Teams teams, InternalMetadataDecoratorService decoratorService) {
        return new JcrReleaseSearchService(repositoryService, archivingService, permissionEnforcer, teams, decoratorService);
    }

    @Primary
    @Bean
    public RepositoryService repositoryService(JcrTemplate jcrTemplate, LicenseService licenseService) {
        NonDecryptingPasswordEncrypter passwordEncrypter = new NonDecryptingPasswordEncrypter();
        JcrRepositoryService jcrRepositoryService = new JcrRepositoryService(jcrTemplate, (PasswordEncrypter)passwordEncrypter, licenseService);
        jcrRepositoryService.setReuseNodeReaderContext(false);
        return jcrRepositoryService;
    }

    @Bean(value={"decryptingRepositoryService"})
    public RepositoryService decryptingRepositoryService(JcrTemplate jcrTemplate, LicenseService licenseService, PasswordEncrypter passwordEncrypter) {
        JcrRepositoryService jcrRepositoryService = new JcrRepositoryService(jcrTemplate, passwordEncrypter, licenseService);
        jcrRepositoryService.setReuseNodeReaderContext(false);
        return jcrRepositoryService;
    }

    @Profile(value={"!sql"})
    @Bean
    public AdvancedRepositoryService advancedRepositoryService(JcrTemplate jcrTemplate) {
        return new JcrAdvancedRepositoryService(jcrTemplate);
    }

    @Profile(value={"!sql"})
    @Bean
    public XlrRepository xlrRepository(RepositoryService repositoryService) {
        return new JcrXlrRepository(repositoryService);
    }

    @Profile(value={"!sql"})
    @Bean
    public XlrQueries xlrQueries(RepositoryService repositoryService, AdvancedRepositoryService advancedRepositoryService) {
        return new JcrXlrQueries(repositoryService, advancedRepositoryService);
    }

    @Primary
    @Profile(value={"!sql"})
    @Bean
    public RepositoryFactory repositoryFactory(RepositoryService repositoryService, Validator validator) {
        return new RepositoryAdapterFactory(repositoryService, validator);
    }

    @Profile(value={"!sql"})
    @Bean
    public ArchivingReleasesStrategy archivingReleasesStrategy(RepositoryService repositoryService, ReleaseActorService releaseActorService) {
        return new JcrArchivingReleasesStrategy(repositoryService, releaseActorService);
    }
}

