/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.customscripts.ScriptTypes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.TaskTypes;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskTypeConversion;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.service.DependencyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"!sql"})
@Component
public class JcrTaskTypeConversion
implements TaskTypeConversion {
    private static final String PROPERTY_CONFIGURATION_URI = "configurationUri";
    private final ScriptTypes scriptTypes;
    private final DependencyService dependencyService;
    private final RepositoryService repositoryService;
    private final Tasks tasks;

    @Autowired
    public JcrTaskTypeConversion(ScriptTypes scriptTypes, DependencyService dependencyService, RepositoryService repositoryService, Tasks tasks) {
        this.scriptTypes = scriptTypes;
        this.dependencyService = dependencyService;
        this.repositoryService = repositoryService;
        this.tasks = tasks;
    }

    public Task changeActiveTaskType(String taskId, Type taskOrScriptType) {
        Task updatedTask;
        Type scriptType;
        Type newType;
        boolean newTypeIsPythonScriptTask = this.scriptTypes.getPythonScriptTypes().contains(taskOrScriptType);
        if (newTypeIsPythonScriptTask) {
            newType = Type.valueOf(CustomScriptTask.class);
            scriptType = taskOrScriptType;
        } else {
            newType = taskOrScriptType;
            scriptType = null;
        }
        Task oldTask = this.tasks.findById(taskId);
        this.checkTaskIsPlanned(oldTask);
        Type typeTask = Type.valueOf(Task.class);
        boolean newTypeIsTaskInstance = newType.instanceOf(typeTask);
        Checks.checkArgument((newTypeIsPythonScriptTask || newTypeIsTaskInstance ? 1 : 0) != 0, (String)"Cannot change type of task '%s' to '%s' because it is not one of supported types: %s", (Object[])new Object[]{oldTask.getTitle(), newType, Joiner.on((String)", ").join(this.getAllSupportedTypes())});
        Type oldType = oldTask.getType();
        if (oldType.equals((Object)newType) && (scriptType == null || oldTask.getTaskType().equals((Object)scriptType))) {
            return oldTask;
        }
        if (oldType.isSubTypeOf(Type.valueOf(TaskGroup.class))) {
            String msg = String.format("Conversion of task '%s' from '%s' is not supported.", oldTask.getTitle(), oldType);
            throw new IllegalArgumentException(msg);
        }
        ArrayList excludedProperties = Lists.newArrayList((Object[])new String[]{PROPERTY_CONFIGURATION_URI});
        if (newType.instanceOf(Type.valueOf(CustomScriptTask.class))) {
            Checks.checkArgument((scriptType != null ? 1 : 0) != 0, (String)"Script type must be provided if new task type is CustomScriptTask", (Object[])new Object[0]);
            updatedTask = TaskBuilder.newCustomScript((String)scriptType.toString()).build();
            excludedProperties.add("pythonScript");
            this.copyPythonScriptProperties(oldTask, (CustomScriptTask)updatedTask);
        } else {
            updatedTask = Task.fromType((Type)newType);
        }
        this.copyNonContainmentProperties((ConfigurationItem)oldTask, (ConfigurationItem)updatedTask, excludedProperties);
        this.removeVariableMappingsForNonExistingProperties(oldTask, updatedTask);
        updatedTask = this.tasks.create(oldTask.getContainer(), null, updatedTask, null, createdTask -> new TaskUpdatedEvent(oldTask, createdTask));
        this.moveContainedCollectionProperties((ConfigurationItem)oldTask, (ConfigurationItem)updatedTask);
        this.updateGateTaskDependencies(oldTask, updatedTask);
        this.updateLinks(oldTask, updatedTask);
        this.updateInContainer(oldTask, updatedTask);
        this.repositoryService.delete(new String[]{oldTask.getId()});
        this.repositoryService.move(updatedTask.getId(), oldTask.getId());
        updatedTask = (Task)this.repositoryService.read(oldTask.getId(), false);
        return updatedTask;
    }

    private void removeVariableMappingsForNonExistingProperties(Task oldTask, Task updatedTask) {
        updatedTask.getVariableMapping().keySet().removeIf(fqPropertyName -> {
            Optional newProperty = CiProperty.of((ConfigurationItem)updatedTask, (String)fqPropertyName);
            Optional oldProperty = CiProperty.of((ConfigurationItem)oldTask, (String)fqPropertyName);
            return !oldProperty.isPresent() || !newProperty.isPresent() || !this.isSameKindOfProperty(((CiProperty)oldProperty.get()).getDescriptor(), ((CiProperty)newProperty.get()).getDescriptor());
        });
    }

    private void copyPythonScriptProperties(Task oldTask, CustomScriptTask updatedTask) {
        PythonScript newPythonScript = updatedTask.getPythonScript();
        if (oldTask.getType().instanceOf(Type.valueOf(CustomScriptTask.class))) {
            PythonScript propertySource = ((CustomScriptTask)oldTask).getPythonScript();
            this.copyNonContainmentProperties((ConfigurationItem)propertySource, (ConfigurationItem)newPythonScript, Lists.newArrayList((Object[])new String[]{"customScriptTask"}));
        }
    }

    private void updateInContainer(Task oldTask, Task newTask) {
        TaskContainer container = oldTask.getContainer();
        List tasks = container.getTasks();
        tasks.remove(newTask);
        for (int i = 0; i < tasks.size(); ++i) {
            if (!((Task)tasks.get(i)).equals((Object)oldTask)) continue;
            tasks.set(i, newTask);
        }
        this.repositoryService.update((ConfigurationItem[])new TaskContainer[]{container});
    }

    private void updateLinks(Task oldTask, Task newTask) {
        ChangeSet changeSet = new ChangeSet();
        TaskContainer container = oldTask.getContainer();
        if (container instanceof ParallelGroup) {
            ParallelGroup group = (ParallelGroup)container;
            List links = group.getLinksOf(oldTask);
            for (Link link : links) {
                if (link.hasTarget(oldTask)) {
                    link.setTarget(newTask);
                } else if (link.hasSource(oldTask)) {
                    link.setSource(newTask);
                }
                changeSet.update((ConfigurationItem)link);
            }
        }
        this.repositoryService.execute(changeSet);
    }

    private void updateGateTaskDependencies(Task oldTask, Task newTask) {
        ChangeSet changeSet = new ChangeSet();
        List dependencyIds = this.dependencyService.findAllIncomingDependencyIds((PlanItem)oldTask);
        for (String dependencyId : dependencyIds) {
            Dependency dependency = (Dependency)this.repositoryService.read(dependencyId, 0);
            dependency.setTarget((PlanItem)newTask);
            changeSet.update((ConfigurationItem)dependency);
        }
        this.repositoryService.execute(changeSet);
        this.dependencyService.replaceArchivedIncomingDependencies((PlanItem)oldTask, (PlanItem)newTask);
    }

    private void moveContainedCollectionProperties(ConfigurationItem from, ConfigurationItem to) {
        for (PropertyDescriptor newPd : to.getType().getDescriptor().getPropertyDescriptors()) {
            Type referencedType;
            boolean isContainedCollectionProperty;
            PropertyDescriptor oldPd;
            if (!this.isSameKindOfProperty(newPd, oldPd = from.getType().getDescriptor().getPropertyDescriptor(newPd.getName())) || !(isContainedCollectionProperty = oldPd.isAsContainment() && oldPd.getKind() != PropertyKind.CI) || !this.hasCopyableReferencedType(oldPd, newPd) || null == (referencedType = oldPd.getReferencedType())) continue;
            Collection oldCollection = (Collection)oldPd.get(from);
            for (ConfigurationItem ci : oldCollection) {
                String newId = to.getId() + "/" + Ids.getName((String)ci.getId());
                this.repositoryService.move(ci.getId(), newId);
                ci.setId(newId);
            }
            newPd.set(to, (Object)oldCollection);
        }
        this.repositoryService.update(new ConfigurationItem[]{to});
    }

    private void copyNonContainmentProperties(ConfigurationItem from, ConfigurationItem to, List<String> excludedProperties) {
        for (PropertyDescriptor newPd : to.getType().getDescriptor().getPropertyDescriptors()) {
            PropertyDescriptor oldPd;
            if (excludedProperties.contains(newPd.getName()) || !this.isSameKindOfProperty(newPd, oldPd = from.getType().getDescriptor().getPropertyDescriptor(newPd.getName()))) continue;
            if (oldPd.getKind().isSimple()) {
                newPd.set(to, oldPd.get(from));
                continue;
            }
            if (oldPd.isAsContainment() || !this.hasCopyableReferencedType(oldPd, newPd)) continue;
            newPd.set(to, oldPd.get(from));
        }
    }

    private boolean hasCopyableReferencedType(PropertyDescriptor oldPd, PropertyDescriptor newPd) {
        return oldPd.getReferencedType() == null && newPd.getReferencedType() == null || oldPd.getReferencedType() != null && oldPd.getReferencedType().instanceOf(newPd.getReferencedType());
    }

    private boolean isSameKindOfProperty(PropertyDescriptor newPd, PropertyDescriptor oldPd) {
        return oldPd != null && oldPd.getKind().equals((Object)newPd.getKind()) && oldPd.isPassword() == newPd.isPassword() && oldPd.isAsContainment() == newPd.isAsContainment();
    }

    private void checkTaskIsPlanned(Task task) {
        Checks.checkArgument((boolean)task.isPlanned(), (String)"Cannot change type of the task '%s' because it is in state %s and not %s", (Object[])new Object[]{task.getTitle(), task.getStatus(), TaskStatus.PLANNED});
    }

    private Collection<Type> getAllSupportedTypes() {
        ArrayList types = Lists.newArrayList();
        types.addAll(TaskTypes.getDefaultTaskTypes());
        types.addAll(this.scriptTypes.getPythonScriptTypes());
        return types;
    }
}

