/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperations$;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.JcrPhaseRestart$;
import com.xebialabs.xlrelease.repository.PhaseRestart;
import com.xebialabs.xlrelease.repository.PhaseRestart$;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.TaskBackup;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.RestartPhasesException;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

@Profile(value={"!sql"})
@Component
@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\u0001\u0003\u0001-\u0011qBS2s!\"\f7/\u001a*fgR\f'\u000f\u001e\u0006\u0003\u0007\u0011\t!B]3q_NLGo\u001c:z\u0015\t)a!A\u0005yYJ,G.Z1tK*\u0011q\u0001C\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!C\u0001\u0004G>l7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ta\u0001\u000b[1tKJ+7\u000f^1si\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0005sK2,\u0017m]3t!\t\u0019\u0012$\u0003\u0002\u001b\u0005\tA!+\u001a7fCN,7\u000f\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u0019\u0001\b.Y:fgB\u00111CH\u0005\u0003?\t\u0011a\u0001\u00155bg\u0016\u001c\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bCA\u0012*\u001b\u0005!#BA\u0011&\u0015\t1s%\u0001\u0005qYVl'-\u001b8h\u0015\tAc!\u0001\u0005eKBdw._5u\u0013\tQCEA\u0005TG\",G-\u001e7fe\"AA\u0006\u0001B\u0001B\u0003%Q&\u0001\u0006uCN\\')Y2lkB\u0004\"a\u0005\u0018\n\u0005=\u0012!A\u0003+bg.\u0014\u0015mY6va\"A\u0011\u0007\u0001B\u0001B\u0003%!'A\u0006qKJl\u0017n]:j_:\u001c\bCA\u001a7\u001b\u0005!$BA\u001b\u0005\u0003!\u0019XmY;sSRL\u0018BA\u001c5\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM\u001d\u0005\ts\u0001\u0011\t\u0011)A\u0005u\u0005\t\"/\u001a9pg&$xN]=TKJ4\u0018nY3\u0011\u0005mjT\"\u0001\u001f\u000b\u0005\r9\u0013B\u0001 =\u0005E\u0011V\r]8tSR|'/_*feZL7-\u001a\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\u0006Y1-[%e'\u0016\u0014h/[2f!\t\u0011U)D\u0001D\u0015\t!E!A\u0004tKJ4\u0018nY3\n\u0005\u0019\u001b%aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016D\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!S\u0001\u0012I\u0016\u0004XM\u001c3f]\u000eL8+\u001a:wS\u000e,\u0007C\u0001\"K\u0013\tY5IA\tEKB,g\u000eZ3oGf\u001cVM\u001d<jG\u0016D\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IAT\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u0012\ta!Y2u_J\u001c\u0018BA*Q\u0005M\u0011V\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f\u0011!)\u0006A!A!\u0002\u00171\u0016\u0001C3wK:$()^:\u0011\u0005]SV\"\u0001-\u000b\u0005e#\u0011AB3wK:$8/\u0003\u0002\\1\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\t\u000bu\u0003A\u0011\u00010\u0002\rqJg.\u001b;?))y&m\u00193fM\u001eD\u0017N\u001b\u000b\u0003A\u0006\u0004\"a\u0005\u0001\t\u000bUc\u00069\u0001,\t\u000b]a\u0006\u0019\u0001\r\t\u000bqa\u0006\u0019A\u000f\t\u000b\u0005b\u0006\u0019\u0001\u0012\t\u000b1b\u0006\u0019A\u0017\t\u000bEb\u0006\u0019\u0001\u001a\t\u000beb\u0006\u0019\u0001\u001e\t\u000b\u0001c\u0006\u0019A!\t\u000b!c\u0006\u0019A%\t\u000b5c\u0006\u0019\u0001()\u0005qc\u0007CA7y\u001b\u0005q'BA8q\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003cJ\fqAZ1di>\u0014\u0018P\u0003\u0002ti\u0006)!-Z1og*\u0011QO^\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq/A\u0002pe\u001eL!!\u001f8\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B>\u0001\t\u0003b\u0018!\u0004:fgR\f'\u000f\u001e)iCN,7\u000fF\u0004~\u0003\u000f\tI\"!\b\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t\u0001B\u0001\u0007I>l\u0017-\u001b8\n\u0007\u0005\u0015qPA\u0004SK2,\u0017m]3\t\u000f\u0005%!\u00101\u0001\u0002\f\u0005I!/\u001a7fCN,\u0017\n\u001a\t\u0005\u0003\u001b\t\u0019BD\u0002\u000e\u0003\u001fI1!!\u0005\u000f\u0003\u0019\u0001&/\u001a3fM&!\u0011QCA\f\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0003\b\t\u000f\u0005m!\u00101\u0001\u0002\f\u00059\u0001\u000f[1tK&#\u0007bBA\u0010u\u0002\u0007\u00111B\u0001\u0007i\u0006\u001c8.\u00133\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&\u0005i!/Z:u_J,\u0007\u000b[1tKN$B!a\n\u0002>A1\u0011\u0011FA\u001a\u0003oi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0005kRLGN\u0003\u0002\u00022\u0005!!.\u0019<b\u0013\u0011\t)$a\u000b\u0003\t1K7\u000f\u001e\t\u0004}\u0006e\u0012bAA\u001e\u007f\n)\u0001\u000b[1tK\"A\u0011qHA\u0011\u0001\u0004\t9#A\bqQ\u0006\u001cXm\u001d+p%\u0016\u001cHo\u001c:fQ\u0011\t\t#a\u0011\u0011\t\u0005\u0015\u00131K\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\ti%a\u0014\u0002\r\r|W.\\8o\u0015\r\t\t\u0006C\u0001\u0007O>|w\r\\3\n\t\u0005U\u0013q\t\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0007bBA-\u0001\u0011%\u00111L\u0001\re\u0016\u001cHo\u001c:f!\"\f7/\u001a\u000b\u0005\u0003o\ti\u0006\u0003\u0005\u0002`\u0005]\u0003\u0019AA\u001c\u0003\u0015\u0001\b.Y:f\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003K\nAB]3ti>\u0014X\rV1tWN$b!a\u001a\u0002n\u0005=\u0005cA\u0007\u0002j%\u0019\u00111\u000e\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003_\n\t\u00071\u0001\u0002r\u0005iqN]5hS:\fG\u000eV1tWN\u0004b!a\u001d\u0002\u0004\u0006%e\u0002BA;\u0003\u007frA!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003wR\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\r\t\tID\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t))a\"\u0003\u0007M+\u0017OC\u0002\u0002\u0002:\u00012A`AF\u0013\r\tii \u0002\u0005)\u0006\u001c8\u000e\u0003\u0005\u0002\u0012\u0006\u0005\u0004\u0019AA9\u0003!qWm\u001e+bg.\u001c\bbBAK\u0001\u0011%\u0011qS\u0001\fe\u0016\u0004H.Y2f)\u0006\u001c8\u000e\u0006\u0005\u0002\n\u0006e\u0015QTAT\u0011!\tY*a%A\u0002\u0005E\u0014aC2pa&,G\rV1tWND\u0001\"a(\u0002\u0014\u0002\u0007\u0011\u0011U\u0001\u0006S:$W\r\u001f\t\u0004\u001b\u0005\r\u0016bAAS\u001d\t\u0019\u0011J\u001c;\t\u0011\u0005%\u00161\u0013a\u0001\u0003\u0013\u000bAB]3ti>\u0014X\r\u001a+bg.Dq!!,\u0001\t\u0013\ty+A\u0003sKN,G\u000f\u0006\u0004\u0002h\u0005E\u00161\u0017\u0005\t\u0003S\u000bY\u000b1\u0001\u0002\n\"A\u0011QWAV\u0001\u0004\tI)\u0001\u0006d_BLW\r\u001a+bg.D\u0001\"!/\u0001\t\u0003\u0011\u00111X\u0001\u001dkB$\u0017\r^3HCR,7OU3gKJ,gnY5oOBC\u0017m]3t)\u0019\t9'!0\u0002@\"A\u0011qHA\\\u0001\u0004\t9\u0003\u0003\u0005\u0002B\u0006]\u0006\u0019AA\u0014\u00039\u0011Xm\u001d;pe\u0016$\u0007\u000b[1tKNDC!a.\u0002D!A\u0011q\u0019\u0001\u0005\u0002\t\tI-A\u0007va\u0012\fG/\u001a*fY\u0016\f7/\u001a\u000b\u0007\u0003O\nY-a4\t\u000f\u00055\u0017Q\u0019a\u0001{\u00069!/\u001a7fCN,\u0007\u0002CAa\u0003\u000b\u0004\r!a\n)\t\u0005\u0015\u00171\t\u0005\b\u0003+\u0004A\u0011BAl\u0003\u0015\u0019Gn\\:f)\u0011\t9'!7\t\u0011\u0005m\u00171\u001ba\u0001\u0003o\tAbY;se\u0016tG\u000f\u00155bg\u0016Dq!a8\u0001\t\u0013\t\t/A\btW&\u0004H+Y:lg\n+gm\u001c:f)!\t9'a9\u0002f\u0006%\b\u0002CA\u0010\u0003;\u0004\r!a\u0003\t\u0011\u0005\u001d\u0018Q\u001ca\u0001\u0003o\tQb\u001c:jO&t\u0017\r\u001c)iCN,\u0007\u0002CAv\u0003;\u0004\r!a\u000e\u0002\u001bI,7\u000f^8sK\u0012\u0004\u0006.Y:fQ\r\u0001\u0011q\u001e\t\u0005\u0003c\f90\u0004\u0002\u0002t*\u0019\u0011Q\u001f;\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002z\u0006M(!C\"p[B|g.\u001a8uQ\u001d\u0001\u0011Q B\u0006\u0005\u001b\u0001B!a@\u0003\b5\u0011!\u0011\u0001\u0006\u0004_\n\r!b\u0001B\u0003i\u000691m\u001c8uKb$\u0018\u0002\u0002B\u0005\u0005\u0003\u0011q\u0001\u0015:pM&dW-A\u0003wC2,X\r\f\u0002\u0003\u0010\u0005\u0012!\u0011C\u0001\u0005CM\fH\u000e")
public class JcrPhaseRestart
implements PhaseRestart {
    private final Releases releases;
    private final Phases phases;
    private final Scheduler scheduler;
    public final TaskBackup com$xebialabs$xlrelease$repository$JcrPhaseRestart$$taskBackup;
    private final PermissionChecker permissions;
    public final RepositoryService com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService;
    private final CiIdService ciIdService;
    public final DependencyService com$xebialabs$xlrelease$repository$JcrPhaseRestart$$dependencyService;
    public final ReleaseActorService com$xebialabs$xlrelease$repository$JcrPhaseRestart$$releaseActorService;
    private final XLReleaseEventBus eventBus;

    public Release restartPhases(String releaseId, String phaseId, String taskId) {
        Release release = this.releases.findById(releaseId);
        if (release.hasNoAutomatedTaskRunning()) {
            List phasesToRestore = PhaseRestart$.MODULE$.getPhasesToRestore(release, phaseId);
            PhaseRestart$.MODULE$.checkIfPhaseCanBeRestartedFrom(release.getTask(taskId), (Phase)phasesToRestore.get(0), this.permissions);
            List<Phase> restoredPhases = this.restorePhases(phasesToRestore);
            this.updateGatesReferencingPhases(phasesToRestore, restoredPhases);
            this.updateRelease(release, restoredPhases);
            this.close(release.getCurrentPhase());
            this.skipTasksBefore(taskId, (Phase)phasesToRestore.get(0), restoredPhases.get(0));
            return this.releases.findById(release.getId());
        }
        throw new RestartPhasesException(releaseId, phaseId, taskId, "You attempted to restart phases on a release with running automated tasks");
    }

    @VisibleForTesting
    public List<Phase> restorePhases(List<Phase> phasesToRestore) {
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(phasesToRestore).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JcrPhaseRestart $outer;

            /*
             * WARNING - void declaration
             */
            public final Phase apply(Phase originalPhase) {
                void var2_2;
                Phase restoredPhase = this.$outer.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$restorePhase(originalPhase);
                this.$outer.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$restoreTasks((Seq<Task>)JavaConversions$.MODULE$.asScalaBuffer(originalPhase.getTasks()), (Seq<Task>)JavaConversions$.MODULE$.asScalaBuffer(restoredPhase.getTasks()));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    /*
     * WARNING - void declaration
     */
    public Phase com$xebialabs$xlrelease$repository$JcrPhaseRestart$$restorePhase(Phase phase) {
        void var3_3;
        String restoredPhaseId = this.phases.getUniqueId(Ids.releaseIdFrom((String)phase.getId()));
        this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService.copy(phase.getId(), restoredPhaseId);
        Phase copiedPhase = (Phase)this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService.read(restoredPhaseId);
        copiedPhase.setTitle(RetryTitleGenerator.getNextTitle((String)phase.getTitle()));
        copiedPhase.setStatus(PhaseStatus.PLANNED);
        copiedPhase.setStartDate(null);
        copiedPhase.setEndDate(null);
        this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService.update((ConfigurationItem[])new Phase[]{copiedPhase});
        return var3_3;
    }

    public void com$xebialabs$xlrelease$repository$JcrPhaseRestart$$restoreTasks(Seq<Task> originalTasks, Seq<Task> newTasks) {
        originalTasks.indices().foreach((Function1)new Serializable(this, newTasks){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JcrPhaseRestart $outer;
            private final Seq newTasks$1;

            public final Task apply(int i) {
                Task restoredTask = this.$outer.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$taskBackup.restoreTask((Task)JavaConversions$.MODULE$.seqAsJavaList(this.newTasks$1).get(i), this.$outer.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$taskBackup.restoreTask$default$2(), this.$outer.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$taskBackup.restoreTask$default$3());
                return this.$outer.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$replaceTask((Seq<Task>)this.newTasks$1, i, restoredTask);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newTasks$1 = newTasks$1;
            }
        });
    }

    public Task com$xebialabs$xlrelease$repository$JcrPhaseRestart$$replaceTask(Seq<Task> copiedTasks, int index, Task restoredTask) {
        Task copiedTask = (Task)JavaConversions$.MODULE$.seqAsJavaList(copiedTasks).get(index);
        this.reset(restoredTask, copiedTask);
        CiHelper.eraseTokens((ConfigurationItem)restoredTask);
        this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService.update((ConfigurationItem[])new Task[]{restoredTask});
        return JavaConversions$.MODULE$.seqAsJavaList(copiedTasks).set(index, restoredTask);
    }

    private void reset(Task restoredTask, Task copiedTask) {
        restoredTask.setStatus(TaskStatus.PLANNED);
        Buffer commentIds = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(copiedTask.getComments()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Comment x$1) {
                return (String)CiHelper.TO_ID.apply(x$1);
            }
        }, Buffer$.MODULE$.canBuildFrom());
        this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService.delete((String[])commentIds.toArray(ClassTag$.MODULE$.apply(String.class)));
        restoredTask.clearComments();
        restoredTask.setStartDate(null);
        restoredTask.setEndDate(null);
        Task task = restoredTask;
        if (task instanceof GateTask) {
            GateTask gateTask = (GateTask)task;
            JavaConversions$.MODULE$.asScalaBuffer(gateTask.getConditions()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JcrPhaseRestart $outer;

                public final void apply(GateCondition condition) {
                    condition.setChecked(false);
                    this.$outer.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService.update((ConfigurationItem[])new GateCondition[]{condition});
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @VisibleForTesting
    public void updateGatesReferencingPhases(List<Phase> phasesToRestore, List<Phase> restoredPhases) {
        scala.collection.immutable.Map originToRestored = PhaseRestart$.MODULE$.buildOriginToRestored((Seq)JavaConversions$.MODULE$.asScalaBuffer(phasesToRestore), (Seq)JavaConversions$.MODULE$.asScalaBuffer(restoredPhases));
        this.scheduler.execute(new Runnable(this, phasesToRestore, originToRestored){
            private final /* synthetic */ JcrPhaseRestart $outer;
            private final List phasesToRestore$1;
            public final scala.collection.immutable.Map originToRestored$1;

            public void run() {
                ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(this.phasesToRestore$1).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final Buffer<String> apply(Phase phase) {
                        return JavaConversions$.MODULE$.asScalaBuffer(this.$outer.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$anon$$$outer().com$xebialabs$xlrelease$repository$JcrPhaseRestart$$dependencyService.findActiveIncomingGateIds(phase.getId()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final void apply(String x$2) {
                        this.$outer.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$anon$$$outer().com$xebialabs$xlrelease$repository$JcrPhaseRestart$$releaseActorService.updateGateReferencingPhases(x$2, JavaConversions$.MODULE$.mapAsJavaMap((Map)this.$outer.originToRestored$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ JcrPhaseRestart com$xebialabs$xlrelease$repository$JcrPhaseRestart$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.phasesToRestore$1 = phasesToRestore$1;
                this.originToRestored$1 = originToRestored$1;
            }
        });
    }

    @VisibleForTesting
    public void updateRelease(Release release, List<Phase> restoredPhases) {
        Changes changes = release.restorePhases(restoredPhases);
        VariablePersistenceHelper$.MODULE$.scanAndCreateNewVariables(release, this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService, this.ciIdService);
        XLReleaseOperations$.MODULE$.runActionInterceptors(changes.getOperations(), this.eventBus);
        this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService.update((ConfigurationItem[])new Release[]{release});
        XLReleaseOperations$.MODULE$.publishEvents(changes.getOperations(), this.eventBus);
    }

    private void close(Phase currentPhase) {
        Changes changes = currentPhase.close();
        XLReleaseOperations$.MODULE$.runActionInterceptors(changes.getOperations(), this.eventBus);
        this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService.update(changes.toUpdatedItemsArray());
        XLReleaseOperations$.MODULE$.publishEvents(changes.getOperations(), this.eventBus);
    }

    private void skipTasksBefore(String taskId, Phase originalPhase, Phase restoredPhase) {
        int taskIndexToRestartFrom = ((GenSeqLike)JavaConversions$.MODULE$.asScalaBuffer(originalPhase.getTasks()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Task x$3) {
                return x$3.getId();
            }
        }, Buffer$.MODULE$.canBuildFrom())).indexOf((Object)taskId);
        if (taskIndexToRestartFrom > 0) {
            Changes changes = new Changes();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), taskIndexToRestartFrom).foreach$mVc$sp((Function1)new Serializable(this, restoredPhase, changes){
                public static final long serialVersionUID = 0L;
                private final Phase restoredPhase$1;
                private final Changes changes$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Task task = (Task)this.restoredPhase$1.getTasks().get(i);
                    this.changes$1.addAll(task.markAsDone(task.getId(), TaskStatus.SKIPPED_IN_ADVANCE));
                }
                {
                    this.restoredPhase$1 = restoredPhase$1;
                    this.changes$1 = changes$1;
                }
            });
            XLReleaseOperations$.MODULE$.runActionInterceptors(changes.getOperations(), this.eventBus);
            this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService.update(changes.toUpdatedItemsArray());
            XLReleaseOperations$.MODULE$.publishEvents(changes.getOperations(), this.eventBus);
        }
    }

    @Autowired
    public JcrPhaseRestart(Releases releases, Phases phases, Scheduler scheduler, TaskBackup taskBackup, PermissionChecker permissions, RepositoryService repositoryService, CiIdService ciIdService, DependencyService dependencyService, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus) {
        this.releases = releases;
        this.phases = phases;
        this.scheduler = scheduler;
        this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$taskBackup = taskBackup;
        this.permissions = permissions;
        this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$repositoryService = repositoryService;
        this.ciIdService = ciIdService;
        this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$dependencyService = dependencyService;
        this.com$xebialabs$xlrelease$repository$JcrPhaseRestart$$releaseActorService = releaseActorService;
        this.eventBus = eventBus;
    }
}

