import React from 'react';
import { Provider, useDispatch } from 'react-redux';
import { DotEmptyFilterState, DotEmptyState, DotThemeProvider } from '@digital-ai/dot-components';
import { store } from '@xlr-ui/app/js/app-config';
import { navigation } from '@xlr-ui/app/features/main-navigation/ducks/navigation.reducer';

const { navigateTo } = navigation.actions;

export interface WorkflowTemplateListEmptyStateProps {
    filtered: boolean;
    folder?: { id: string };
    hasCreateTemplatePermission: boolean;
}

export const WorkflowTemplateListEmptyStateContent = ({ filtered = false, folder, hasCreateTemplatePermission }: WorkflowTemplateListEmptyStateProps) => {
    const dispatch = useDispatch();

    const onNewTemplate = () => {
        if (folder) {
            dispatch(navigateTo({ pathSuffix: `folders/${folder.id}/workflows/templates?action=create` }));
        } else {
            dispatch(navigateTo({ pathSuffix: 'workflow-templates/create' }));
        }
    };

    return (
        <DotThemeProvider>
            {filtered ? (
                <DotEmptyFilterState className="empty-state-top-margin" />
            ) : (
                <DotEmptyState
                    buttonProps={{
                        onClick: onNewTemplate,
                        children: 'New workflow template',
                        type: 'primary',
                        disabled: !hasCreateTemplatePermission,
                        tooltip: !hasCreateTemplatePermission ? 'You do not have permission to create a new workflow template.' : undefined,
                    }}
                    className="empty-state-top-margin"
                    illustrationId="add-new-grid"
                    subtitle="Create lightweight, step-by-step workflows to automate tasks and operations."
                    title="Workflow templates"
                />
            )}
        </DotThemeProvider>
    );
};

export const WorkflowTemplateListEmptyState = (props: WorkflowTemplateListEmptyStateProps) => (
    <Provider store={store}>
        <WorkflowTemplateListEmptyStateContent {...props} />
    </Provider>
);
