import React from 'react';
import classNames from 'classnames';
import { DotIconWrapper } from '../../../features/common/components/dot-icon-wrapper/dot-icon-wrapper';
import './menu-item.component.less';

interface MenuItemProps {
    className?: string;
    endIconId?: string;
    iconId?: string;
    label: string;
}

export const MenuItem = ({ className, endIconId, label, iconId }: MenuItemProps) => {
    return (
        <div className={classNames('menu-item-wrapper', className)}>
            {iconId && <DotIconWrapper iconId={iconId} />}
            {label}
            {endIconId && <DotIconWrapper iconId={endIconId} />}
        </div>
    );
};
