/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import com.xebialabs.xlrelease.domain.versioning.ascode.CiInfo;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.DuplicateTitle;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.HardcodedPassword;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.MissingPassword;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.NonVersionedRef;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.UnsupportedFolderNameCharacter;

public interface ValidationMessage {
    public static final String LEVEL_ERROR = "ERROR";
    public static final String LEVEL_WARN = "WARNING";

    public CiInfo getCi();

    public String getProperty();

    public String getMessage();

    public String getMessageType();

    public String getMessageLevel();

    public static ValidationMessage updateCiId(ValidationMessage msg, String id) {
        if (msg instanceof HardcodedPassword) {
            HardcodedPassword hp = (HardcodedPassword)msg;
            return new HardcodedPassword(hp.getCi().withCiId(id), hp.getProperty());
        }
        if (msg instanceof MissingPassword) {
            MissingPassword mp = (MissingPassword)msg;
            return new MissingPassword(mp.getCi().withCiId(id), mp.getProperty(), mp.getPlaceholder());
        }
        if (msg instanceof NonVersionedRef) {
            NonVersionedRef nv = (NonVersionedRef)msg;
            return new NonVersionedRef(nv.getCi().withCiId(id), nv.getProperty(), nv.getRef());
        }
        if (msg instanceof DuplicateTitle) {
            DuplicateTitle dt = (DuplicateTitle)msg;
            return new DuplicateTitle(dt.getCi().withCiId(id));
        }
        if (msg instanceof UnsupportedFolderNameCharacter) {
            UnsupportedFolderNameCharacter uc = (UnsupportedFolderNameCharacter)msg;
            return new UnsupportedFolderNameCharacter(uc.getCi().withCiId(id), uc.getProperty(), uc.getFolderName(), uc.getAbsoluteFolderPath(), uc.getUnsupportedCharacters());
        }
        throw new IllegalArgumentException("Unknown ValidationMessage type: " + String.valueOf(msg.getClass()));
    }
}

