/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import com.xebialabs.xlrelease.domain.versioning.ascode.CiInfo;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationMessage;
import java.util.List;
import java.util.Objects;

public class UnsupportedFolderNameCharacter
implements ValidationMessage {
    private final CiInfo ci;
    private final String property;
    private final String folderName;
    private final String absoluteFolderPath;
    private final List<String> unsupportedCharacters;

    public UnsupportedFolderNameCharacter(CiInfo ci, String property, String folderName, String absoluteFolderPath, List<String> unsupportedCharacters) {
        this.ci = ci;
        this.property = property;
        this.folderName = folderName;
        this.absoluteFolderPath = absoluteFolderPath;
        this.unsupportedCharacters = unsupportedCharacters;
    }

    @Override
    public CiInfo getCi() {
        return this.ci;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public String getMessage() {
        return "Folder name '" + this.folderName + "' contains the unsupported character(s) '" + String.join((CharSequence)", ", this.unsupportedCharacters) + "'. Folder path: " + this.absoluteFolderPath + ".";
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getAbsoluteFolderPath() {
        return this.absoluteFolderPath;
    }

    public List<String> getUnsupportedCharacters() {
        return this.unsupportedCharacters;
    }

    @Override
    public String getMessageType() {
        return "UNSUPPORTED_FOLDER_NAME_CHARACTER";
    }

    @Override
    public String getMessageLevel() {
        return "ERROR";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsupportedFolderNameCharacter that = (UnsupportedFolderNameCharacter)o;
        return Objects.equals(this.ci, that.ci) && Objects.equals(this.property, that.property) && Objects.equals(this.folderName, that.folderName) && Objects.equals(this.absoluteFolderPath, that.absoluteFolderPath) && Objects.equals(this.unsupportedCharacters, that.unsupportedCharacters);
    }

    public int hashCode() {
        return Objects.hash(this.ci, this.property, this.folderName, this.absoluteFolderPath, this.unsupportedCharacters);
    }
}

