/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.domain.UserTokenPermission;
import com.xebialabs.xlrelease.domain.events.UserTokenAboutToExpireEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenCreatedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenDeletedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokensDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.UserTokenRepository;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import com.xebialabs.xlrelease.utils.TokenTypes$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\t\u0013\u0001mA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003G\u0001\u0011\u0005q\tC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!a\u001c\u0001\t\u0003\t\t\bC\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u00111\u0012\u0001\u0005\n\u00055%\u0001E+tKJ$vn[3o'\u0016\u0014h/[2f\u0015\t\u0019B#A\u0004tKJ4\u0018nY3\u000b\u0005U1\u0012!\u0003=me\u0016dW-Y:f\u0015\t9\u0002$A\u0005yK\nL\u0017\r\\1cg*\t\u0011$A\u0002d_6\u001c\u0001aE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0013\u0001C4sSjTH.\u001a3\n\u0005%\"#a\u0002'pO\u001eLgnZ\u0001\tKZ,g\u000e\u001e\"vgB\u0011AfL\u0007\u0002[)\u0011a\u0006F\u0001\u0007KZ,g\u000e^:\n\u0005Aj#\u0001C#wK:$()^:\u0002'U\u001cXM\u001d+pW\u0016t'+\u001a9pg&$xN]=\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\"\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011q\u0007\u000e\u0002\u0014+N,'\u000fV8lK:\u0014V\r]8tSR|'/_\u0001\u001ba\u0016\u00148o\u001c8bY\u0006\u001b7-Z:t)>\\WM\u001c$fCR,(/\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003yQ\t\u0001BZ3biV\u0014Xm]\u0005\u0003}m\u0012!\u0004U3sg>t\u0017\r\\!dG\u0016\u001c8\u000fV8lK:4U-\u0019;ve\u0016\fa\u0001P5oSRtD\u0003B!D\t\u0016\u0003\"A\u0011\u0001\u000e\u0003IAQA\u000b\u0003A\u0002-BQ!\r\u0003A\u0002IBQ\u0001\u000f\u0003A\u0002e\nqb\u0019:fCR,Wk]3s)>\\WM\u001c\u000b\u0006\u0011:[Vl\u001a\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017R\ta\u0001Z8nC&t\u0017BA'K\u0005%)6/\u001a:U_.,g\u000eC\u0003P\u000b\u0001\u0007\u0001+\u0001\u0005vg\u0016\u0014h.Y7f!\t\t\u0006L\u0004\u0002S-B\u00111KH\u0007\u0002)*\u0011QKG\u0001\u0007yI|w\u000e\u001e \n\u0005]s\u0012A\u0002)sK\u0012,g-\u0003\u0002Z5\n11\u000b\u001e:j]\u001eT!a\u0016\u0010\t\u000bq+\u0001\u0019\u0001)\u0002\u0013Q|7.\u001a8O_R,\u0007\"\u00020\u0006\u0001\u0004y\u0016AC3ya&\u0014\u0018\u0010R1uKB\u0011\u0001-Z\u0007\u0002C*\u0011!mY\u0001\u0005kRLGNC\u0001e\u0003\u0011Q\u0017M^1\n\u0005\u0019\f'\u0001\u0002#bi\u0016DQ\u0001[\u0003A\u0002%\f\u0011c\u001a7pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8t!\r\t&\u000eU\u0005\u0003Wj\u00131aU3uQ\t)Q\u000e\u0005\u0002oo6\tqN\u0003\u0002qc\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005I\u001c\u0018\u0001B2pe\u0016T!\u0001^;\u0002\u00155L7M]8nKR,'OC\u0001w\u0003\tIw.\u0003\u0002y_\n)A+[7fI\u00061R\u000f\u001d3bi\u0016$vn[3o!\u0016\u0014X.[:tS>t7\u000f\u0006\u0003|}\u00065\u0001CA\u000f}\u0013\tihD\u0001\u0003V]&$\bBB@\u0007\u0001\u0004\t\t!A\u0003dSVKG\r\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9aY\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\f\u0005\u0015!aB%oi\u0016<WM\u001d\u0005\u0006Q\u001a\u0001\r!\u001b\u0015\u0003\r5\fq\u0002Z3mKR,Wk]3s)>\\WM\u001c\u000b\u0004w\u0006U\u0001BBA\f\u000f\u0001\u0007\u0001*A\u0005vg\u0016\u0014Hk\\6f]\"\u0012q!\\\u0001\u0013I\u0016dW\r^3BY2,6/\u001a:U_.,g\u000eF\u0002|\u0003?AQa\u0014\u0005A\u0002AC#\u0001C7\u0002\t\u0019Lg\u000e\u001a\u000b\u0007\u0003O\ti$a\u0010\u0011\u000b\u0005%\u0012\u0011\b%\u000e\u0005\u0005-\"bA&\u0002.)!\u0011qFA\u0019\u0003\u0011!\u0017\r^1\u000b\t\u0005M\u0012QG\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011qG\u0001\u0004_J<\u0017\u0002BA\u001e\u0003W\u0011A\u0001U1hK\")q*\u0003a\u0001!\"9\u0011\u0011I\u0005A\u0002\u0005\r\u0013\u0001\u00039bO\u0016\f'\r\\3\u0011\t\u0005%\u0012QI\u0005\u0005\u0003\u000f\nYC\u0001\u0005QC\u001e,\u0017M\u00197fQ\tIQ.A\u0006gS:$')_\"j+&$G\u0003BA(\u0003+\u0002B!HA)\u0011&\u0019\u00111\u000b\u0010\u0003\r=\u0003H/[8o\u0011\u0019y(\u00021\u0001\u0002\u0002!\u0012!\"\\\u0001\u0010M&tGMQ=Vg\u0016\u0014Hk\\6f]R!\u0011qJA/\u0011\u0019\tyf\u0003a\u0001!\u0006IAo\\6f]\"\u000b7\u000f\u001b\u0015\u0003\u00175\f\u0001CZ5oI\nK\b+\u001a:nSN\u001c\u0018n\u001c8\u0015\r\u0005\u001d\u0012qMA6\u0011\u0019\tI\u0007\u0004a\u0001!\u0006Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\t\u000f\u0005\u0005C\u00021\u0001\u0002D!\u0012A\"\\\u0001\u001a]>$\u0018NZ=U_.,gn]!c_V$Hk\\#ya&\u0014X\rF\u0001|Q\tiQ.A\bvg\u0016\u0014Hk\\6f]\u0016C\u0018n\u001d;t)\u0019\tI(a \u0002\u0002B\u0019Q$a\u001f\n\u0007\u0005udDA\u0004C_>dW-\u00198\t\u000b=s\u0001\u0019\u0001)\t\u000bqs\u0001\u0019\u0001))\u00059i\u0017\u0001\u0005<bY&$\u0017\r^3EkJ\fG/[8o)\rY\u0018\u0011\u0012\u0005\u0006=>\u0001\raX\u0001\u0019aV\u0014G.[:i)>\\WM\\\"sK\u0006$X\rZ#wK:$HcA>\u0002\u0010\"1\u0011q\u0003\tA\u0002!\u0003")
public class UserTokenService
implements Logging {
    private final EventBus eventBus;
    private final UserTokenRepository userTokenRepository;
    private final PersonalAccessTokenFeature personalAccessTokenFeature;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenService userTokenService = this;
        synchronized (userTokenService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public UserToken createUserToken(String username, String tokenNote, Date expiryDate, scala.collection.immutable.Set<String> globalPermissions) {
        this.validateDuration(expiryDate);
        String token = TokenGenerator$.MODULE$.generate(TokenTypes$.MODULE$.RPA());
        UserToken userToken = new UserToken();
        userToken.tokenNote_$eq(tokenNote);
        userToken.username_$eq(username);
        userToken.createdDate_$eq(new Date());
        userToken.expiryDate_$eq(expiryDate);
        UserTokenPermission userTokenPermission = (UserTokenPermission)Type.valueOf(UserTokenPermission.class).getDescriptor().newInstance(null);
        if (globalPermissions != null && globalPermissions.nonEmpty()) {
            userTokenPermission.globalPermissions_$eq(CollectionConverters$.MODULE$.SetHasAsJava((Set)globalPermissions.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PlatformPermissions.LOGIN.getPermissionName()})))).asJava());
        }
        userToken.userTokenPermission_$eq(userTokenPermission);
        Integer ciUid = this.userTokenRepository.create(userToken, TokenGenerator$.MODULE$.hash(token));
        userToken.ciUid_$eq(ciUid);
        userToken.token_$eq(token);
        this.publishTokenCreatedEvent(userToken);
        return userToken;
    }

    @Timed
    public void updateTokenPermissions(Integer ciUid, scala.collection.immutable.Set<String> globalPermissions) {
        Option<UserToken> userToken = this.userTokenRepository.findByCiUid(ciUid);
        Option<UserToken> option = userToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            UserToken userToken2 = (UserToken)some.value();
            UserTokenPermission userTokenPermission = (UserTokenPermission)Type.valueOf(UserTokenPermission.class).getDescriptor().newInstance(null);
            if (globalPermissions != null && globalPermissions.nonEmpty()) {
                userTokenPermission.globalPermissions_$eq(CollectionConverters$.MODULE$.SetHasAsJava((Set)globalPermissions.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PlatformPermissions.LOGIN.getPermissionName()})))).asJava());
            }
            this.userTokenRepository.updateTokenPermissions(ciUid, userTokenPermission);
            this.logger().info((Function0 & Serializable)() -> "Updated permissions for user token with ciUid[" + ciUid + "] for user[" + userToken2.username() + "]");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().warn((Function0 & Serializable)() -> "User token with ciUid[" + ciUid + "] not found for permission update");
            return;
        }
        throw new MatchError(option);
    }

    @Timed
    public void deleteUserToken(UserToken userToken) {
        this.userTokenRepository.delete(userToken.ciUid());
        this.eventBus.publish((XLReleaseEvent)new UserTokenDeletedEvent(userToken));
    }

    @Timed
    public void deleteAllUserToken(String username) {
        if (Strings.isNotBlank((String)username)) {
            this.userTokenRepository.delete(username);
            this.eventBus.publish((XLReleaseEvent)new UserTokensDeletedEvent(username));
            return;
        }
        throw new IllegalArgumentException("Username can't be blank");
    }

    @Timed
    public Page<UserToken> find(String username, Pageable pageable) {
        return this.userTokenRepository.query(new UserTokenRepository.ByUsername(username), pageable);
    }

    @Timed
    public Option<UserToken> findByCiUid(Integer ciUid) {
        return this.userTokenRepository.findByCiUid(ciUid);
    }

    @Timed
    public Option<UserToken> findByUserToken(String tokenHash) {
        return this.userTokenRepository.findByUserToken(tokenHash);
    }

    @Timed
    public Page<UserToken> findByPermission(String permission, Pageable pageable) {
        return this.userTokenRepository.findByPermission(permission, pageable);
    }

    @Timed
    public void notifyTokensAboutToExpire() {
        LocalDateTime localTime = Instant.now().atZone(ZoneId.of("UTC")).toLocalDate().atTime(LocalTime.MAX).plusDays(1L);
        Date expiryDate = Date.from(localTime.atZone(ZoneId.of("UTC")).toInstant());
        Buffer tokensAboutToExpire = CollectionConverters$.MODULE$.ListHasAsScala(this.userTokenRepository.query(new UserTokenRepository.TokensAboutToExpire(expiryDate), (Pageable)PageRequest.ofSize((int)1024)).getContent()).asScala();
        tokensAboutToExpire.foreach((Function1 & Serializable)userToken -> {
            UserTokenService.$anonfun$notifyTokensAboutToExpire$1(this, userToken);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public boolean userTokenExists(String username, String tokenNote) {
        Option<UserToken> option = this.userTokenRepository.findByUserAndNote(username, tokenNote);
        if (option instanceof Some) {
            this.logger().debug((Function0 & Serializable)() -> "Personal access token was found with user[" + username + "] and note[" + tokenNote + "]");
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Personal access token was not found with user[" + username + "] and note[" + tokenNote + "]");
            return false;
        }
        throw new MatchError(option);
    }

    private void validateDuration(Date expiryDate) {
        boolean noPresetExpirationLimit;
        int maximumPresetExpirationDays = this.personalAccessTokenFeature.maxTokenExpiry();
        boolean bl = noPresetExpirationLimit = maximumPresetExpirationDays == -1;
        if (!noPresetExpirationLimit) {
            boolean tokenReqExceedsPresetExpirationLimit;
            ZonedDateTime today = new Date().toInstant().atZone(ZoneId.systemDefault());
            Date maximumExpiryDate = Date.from(today.plusDays(maximumPresetExpirationDays).toInstant());
            boolean tokenReqHasExpiryDate = expiryDate != null;
            boolean tokenReqExceedsMaximumExpiryDate = tokenReqHasExpiryDate && expiryDate.after(maximumExpiryDate);
            boolean tokenReqIsNonExpiringButNotAllowed = !tokenReqHasExpiryDate && !noPresetExpirationLimit;
            boolean bl2 = tokenReqExceedsPresetExpirationLimit = tokenReqExceedsMaximumExpiryDate || tokenReqIsNonExpiringButNotAllowed;
            if (tokenReqExceedsPresetExpirationLimit) {
                throw new IllegalArgumentException("Personal access token expiration cannot exceed " + maximumPresetExpirationDays + " days.");
            }
            return;
        }
    }

    private void publishTokenCreatedEvent(UserToken userToken) {
        UserToken userTokenForEvent = CiCloneHelper.cloneCi(userToken);
        userTokenForEvent.token_$eq(PasswordVerificationUtils$.MODULE$.PASSWORD_MASK());
        this.eventBus.publish((XLReleaseEvent)new UserTokenCreatedEvent(userTokenForEvent));
    }

    public static final /* synthetic */ void $anonfun$notifyTokensAboutToExpire$1(UserTokenService $this, UserToken userToken) {
        $this.eventBus.publish((XLReleaseEvent)new UserTokenAboutToExpireEvent(userToken));
        $this.userTokenRepository.updateTokenExpiredNotified(userToken.ciUid());
    }

    public UserTokenService(EventBus eventBus, UserTokenRepository userTokenRepository, PersonalAccessTokenFeature personalAccessTokenFeature) {
        this.eventBus = eventBus;
        this.userTokenRepository = userTokenRepository;
        this.personalAccessTokenFeature = personalAccessTokenFeature;
        Logging.$init$((Logging)this);
    }
}

