/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.LineProperty;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class CompoundLineProperty
extends JETAProperty {
    static final long serialVersionUID = 8321803759018530163L;
    public static final int VERSION = 2;
    private LinkedList m_lines = new LinkedList();
    private int m_position;
    public static final String PROPERTY_ID = "lineDefinition";

    public CompoundLineProperty() {
        super(PROPERTY_ID);
    }

    public CompoundLineProperty(LineProperty lineProperty) {
        super(PROPERTY_ID);
        this.addLine(lineProperty);
    }

    public Collection getLines() {
        return this.m_lines;
    }

    public void addLine(LineProperty lineProperty) {
        if (lineProperty != null) {
            this.m_lines.addLast(lineProperty);
        }
    }

    public int getPosition() {
        return this.m_position;
    }

    public Iterator iterator() {
        return this.m_lines.iterator();
    }

    public void print() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            LineProperty lineProperty = (LineProperty)iterator.next();
            lineProperty.print();
        }
    }

    public void setLines(Collection collection) {
        this.m_lines.clear();
        this.m_lines.addAll(collection);
    }

    public void setPosition(int n) {
        this.m_position = n;
    }

    public void setValue(Object object) {
        if (object instanceof CompoundLineProperty) {
            CompoundLineProperty compoundLineProperty = (CompoundLineProperty)object;
            this.m_lines.clear();
            this.m_lines.addAll(compoundLineProperty.m_lines);
            this.m_position = compoundLineProperty.m_position;
        }
    }

    public void updateBean(JETABean jETABean) {
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        super.read(jETAObjectInput.getSuperClassInput());
        int n = jETAObjectInput.readVersion();
        this.m_lines = (LinkedList)jETAObjectInput.readObject("lines");
        if (n > 1) {
            this.m_position = jETAObjectInput.readInt("position");
        }
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        super.write(jETAObjectOutput.getSuperClassOutput(JETAProperty.class));
        jETAObjectOutput.writeVersion(2);
        jETAObjectOutput.writeObject("lines", this.m_lines);
        jETAObjectOutput.writeInt("position", this.m_position);
    }
}

