import React, { ChangeEventHandler, KeyboardEvent } from 'react';
import { DotIcon, DotInputText } from '@digital-ai/dot-components';
import classNames from 'classnames';

export interface SearchProps {
    defaultValue?: string;
    inputId?: string;
    inputPlaceholder?: string;
    inputRef?: React.RefObject<HTMLInputElement>;
    label?: string;
    oldFolderList?: boolean;
    onFilterChange?: ChangeEventHandler<HTMLInputElement | HTMLTextAreaElement>;
    onKeyDown?: (event: KeyboardEvent) => void;
    searchClassNames: string[];
}

export const Search = ({
    defaultValue = '',
    inputId = 'search-input',
    inputRef,
    label,
    oldFolderList = false,
    onFilterChange,
    onKeyDown,
    searchClassNames = [],
    inputPlaceholder = '',
}: SearchProps) => {
    return (
        <div className={classNames('search', ...searchClassNames)}>
            {!oldFolderList && <DotIcon iconId="search" />}
            <DotInputText
                autoFocus={true}
                className="search-input"
                defaultValue={defaultValue}
                disabled={false}
                fullWidth={true}
                id={inputId}
                inputRef={inputRef}
                label={label}
                name="search-input"
                onChange={onFilterChange}
                onKeyDown={onKeyDown}
                placeholder={inputPlaceholder}
                startIcon={oldFolderList && <DotIcon iconId="search" />}
            />
        </div>
    );
};
