/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.configuration.connector.Repository;
import com.xebialabs.xlrelease.domain.utils.ScmException;
import com.xebialabs.xlrelease.domain.utils.ScmException$;
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettingsUtil;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.scm.connector.JGitConnector$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import java.io.Serializable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\b\u0010\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007C\u00036\u0001\u0011\u0005a\u0007C\u0004=\u0001\t\u0007I\u0011B\u001f\t\r)\u0003\u0001\u0015!\u0003?\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015\t\b\u0001\"\u0001s\u0011\u0015)\b\u0001\"\u0001w\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!!\u0003\u0001\t\u0003\tYAA\u000fG_2$WM\u001d,feNLwN\\5oO\u000e{gNZ5h'\u0016\u0014h/[2f\u0015\t\u0001\u0012#A\u0002tG6T!AE\n\u0002\r\u0005\u001c8m\u001c3f\u0015\t!R#\u0001\u0006wKJ\u001c\u0018n\u001c8j]\u001eT!AF\f\u0002\u0013ad'/\u001a7fCN,'B\u0001\r\u001a\u0003%AXMY5bY\u0006\u00147OC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\fG&LEmU3sm&\u001cW\r\u0005\u0002&Q5\taE\u0003\u0002(+\u000591/\u001a:wS\u000e,\u0017BA\u0015'\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0016\u0003)\u0011X\r]8tSR|'/_\u0005\u0003a5\u0012qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002)\r|gNZ5hkJ\fG/[8o'\u0016\u0014h/[2f!\t)3'\u0003\u00025M\t!2i\u001c8gS\u001e,(/\u0019;j_:\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD\u0003B\u001c:um\u0002\"\u0001\u000f\u0001\u000e\u0003=AQa\t\u0003A\u0002\u0011BQA\u000b\u0003A\u0002-BQ!\r\u0003A\u0002I\naaY5UsB,W#\u0001 \u0011\u0005}BU\"\u0001!\u000b\u0005\u0005\u0013\u0015a\u0002:fM2,7\r\u001e\u0006\u0003\u0007\u0012\u000b1!\u00199j\u0015\t)e)\u0001\u0004qYV<\u0017N\u001c\u0006\u0003\u000f^\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003\u0013\u0002\u0013A\u0001V=qK\u000691-\u001b+za\u0016\u0004\u0013AF2sK\u0006$Xm\u0014:Va\u0012\fG/Z*fiRLgnZ:\u0015\u00055;\u0006C\u0001(V\u001b\u0005y%B\u0001)R\u0003!\u0019X\r\u001e;j]\u001e\u001c(B\u0001\nS\u0015\t!2K\u0003\u0002U+\u00051Am\\7bS:L!AV(\u00031\u0019{G\u000eZ3s-\u0016\u00148/[8oS:<7+\u001a;uS:<7\u000fC\u0003Y\u000f\u0001\u0007Q*A\u0005oK^\u001cuN\u001c4jO\u0006qA-\u001a7fi\u0016\u001cV\r\u001e;j]\u001e\u001cHCA._!\tqB,\u0003\u0002^?\t!QK\\5u\u0011\u0015y\u0006\u00021\u0001a\u0003!1w\u000e\u001c3fe&#\u0007CA1i\u001d\t\u0011g\r\u0005\u0002d?5\tAM\u0003\u0002f7\u00051AH]8pizJ!aZ\u0010\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003O~\tABZ5oIN+G\u000f^5oON$\"!\u001c9\u0011\u0007yqW*\u0003\u0002p?\t1q\n\u001d;j_:DQaX\u0005A\u0002\u0001\faCZ5oIN+G\u000f^5oON\u0014\u0015pQ8oM&<\u0017\n\u001a\u000b\u0003\u001bNDQ\u0001\u001e\u0006A\u0002\u0001\f\u0001bY8oM&<\u0017\nZ\u0001\u0015M&tGMV3sg&|g.\u001a3G_2$WM]:\u0016\u0003]\u00042\u0001_?N\u001d\tI8P\u0004\u0002du&\t\u0001%\u0003\u0002}?\u00059\u0001/Y2lC\u001e,\u0017B\u0001@\u0000\u0005\u0011a\u0015n\u001d;\u000b\u0005q|\u0012AF;qI\u0006$XmU3ui&twm\u001d#je\u0016\u001cG\u000f\\=\u0015\u00075\u000b)\u0001\u0003\u0004\u0002\b1\u0001\r!T\u0001\u0007G>tg-[4\u0002%Y\fG.\u001b3bi\u0016\u001cuN\u001c4jO\u0012\u000bG/\u0019\u000b\u00067\u00065\u0011q\u0002\u0005\u0007\u0003\u000fi\u0001\u0019A'\t\r\u0005EQ\u00021\u0001a\u0003-1w\u000e\u001c3feRKG\u000f\\3)\u0007\u0001\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0015RBAA\r\u0015\u0011\tY\"!\b\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002 \u0005\u0005\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005\r\u0012aA8sO&!\u0011qEA\r\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class FolderVersioningConfigService {
    private final CiIdService ciIdService;
    private final ConfigurationRepository configurationRepository;
    private final ConfigurationService configurationService;
    private final Type ciType;

    private Type ciType() {
        return this.ciType;
    }

    public FolderVersioningSettings createOrUpdateSettings(FolderVersioningSettings newConfig) {
        FolderVersioningSettings folderVersioningSettings;
        boolean deletedRepo = false;
        Option<FolderVersioningSettings> option = this.findSettings(newConfig.getFolderId());
        if (option instanceof Some) {
            Some some = (Some)option;
            FolderVersioningSettings existingConfig = (FolderVersioningSettings)some.value();
            String string = existingConfig.getGitConnection().getId();
            String string2 = newConfig.getGitConnection().getId();
            if (string == null ? string2 != null : !string.equals(string2)) {
                deletedRepo = true;
                JGitConnector$.MODULE$.deleteRepo(existingConfig.getFolderId());
            }
            existingConfig.updateWith(newConfig);
            if (deletedRepo) {
                existingConfig.setAppliedVersion("");
                existingConfig.setAppliedBy("");
                existingConfig.setAppliedDate(null);
                v1 = this.updateSettingsDirectly(existingConfig);
            } else {
                v1 = BoxedUnit.UNIT;
            }
            folderVersioningSettings = existingConfig;
        } else if (None$.MODULE$.equals(option)) {
            newConfig.setId(this.ciIdService.getUniqueId(this.ciType(), FolderVersioningSettingsUtil.FOLDER_VERSIONING_ID_ROOT));
            folderVersioningSettings = newConfig;
        } else {
            throw new MatchError(option);
        }
        FolderVersioningSettings config = folderVersioningSettings;
        this.configurationService.createOrUpdate((BaseConfiguration)config);
        return config;
    }

    public void deleteSettings(String folderId) {
        Option<FolderVersioningSettings> option = this.findSettings(folderId);
        if (option instanceof Some) {
            Some some = (Some)option;
            FolderVersioningSettings config = (FolderVersioningSettings)some.value();
            this.configurationService.delete(config.getId());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Option<FolderVersioningSettings> findSettings(String folderId) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByTypeAndTitle(this.ciType(), null, folderId, true)).asScala().headOption();
    }

    public FolderVersioningSettings findSettingsByConfigId(String configId) {
        Repository gitConnection = (Repository)this.configurationRepository.find(configId).getOrElse((Function0 & Serializable)() -> {
            throw new ScmException("Configuration with id " + configId + " not found", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        });
        FolderVersioningSettings folderVersioningSettings = new FolderVersioningSettings();
        folderVersioningSettings.setGitConnection(gitConnection);
        return folderVersioningSettings;
    }

    public List<FolderVersioningSettings> findVersionedFolders() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByType(this.ciType())).asScala().toList();
    }

    public FolderVersioningSettings updateSettingsDirectly(FolderVersioningSettings config) {
        return (FolderVersioningSettings)this.configurationRepository.update((BaseConfiguration)config);
    }

    public void validateConfigData(FolderVersioningSettings config, String folderTitle) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)config.getScmPath()), (String)("Failed to create folder Git versioning configuration for folder " + folderTitle + ". Repository path cannot be empty."), (Object[])new Object[0]);
    }

    public FolderVersioningConfigService(CiIdService ciIdService, ConfigurationRepository configurationRepository, ConfigurationService configurationService) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.configurationService = configurationService;
        this.ciType = Type.valueOf(FolderVersioningSettings.class);
    }
}

