/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.util.HashSet;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSemaphore
implements Semaphore {
    final ThreadLocal<HashSet<String>> lockOwners = new ThreadLocal();
    final HashSet<String> locks = new HashSet();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected Logger getLog() {
        return this.log;
    }

    private HashSet<String> getThreadLocks() {
        HashSet<String> threadLocks = this.lockOwners.get();
        if (threadLocks == null) {
            threadLocks = new HashSet();
            this.lockOwners.set(threadLocks);
        }
        return threadLocks;
    }

    @Override
    public synchronized boolean obtainLock(Connection conn, String lockName) {
        lockName = lockName.intern();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Lock '{}' is desired by: {}", (Object)lockName, (Object)Thread.currentThread().getName());
        }
        if (!this.isLockOwner(lockName)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock '{}' is being obtained: {}", (Object)lockName, (Object)Thread.currentThread().getName());
            }
            while (this.locks.contains(lockName)) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Lock '{}' was not obtained by: {}", (Object)lockName, (Object)Thread.currentThread().getName());
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock '{}' given to: {}", (Object)lockName, (Object)Thread.currentThread().getName());
            }
            this.getThreadLocks().add(lockName);
            this.locks.add(lockName);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Lock '{}' already owned by: {} -- but not owner!", new Object[]{lockName, Thread.currentThread().getName(), new Exception("stack-trace of wrongful returner")});
        }
        return true;
    }

    @Override
    public synchronized void releaseLock(String lockName) {
        if (this.isLockOwner(lockName = lockName.intern())) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Lock '{}' returned by: {}", (Object)lockName, (Object)Thread.currentThread().getName());
            }
            this.getThreadLocks().remove(lockName);
            this.locks.remove(lockName);
            this.notifyAll();
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Lock '{}' attempt to return by: {} -- but not owner!", new Object[]{lockName, Thread.currentThread().getName(), new Exception("stack-trace of wrongful returner")});
        }
    }

    public synchronized boolean isLockOwner(String lockName) {
        lockName = lockName.intern();
        return this.getThreadLocks().contains(lockName);
    }

    @Override
    public boolean requiresConnection() {
        return false;
    }
}

