import React from 'react';
import omit from 'lodash/omit';
import { Dashboard, DashboardAction, DashboardActionMenuItemProps } from '../types';
import { MenuItem } from '@xlr-ui/app/react/components/menu-item/menu-item.component';
import { AuthenticatorService } from '@xlr-ui/app/features/tasks/types/angular';

export const createMenuItem = (props: DashboardActionMenuItemProps) => ({
    children: <MenuItem iconId={props.iconId} label={props.label} />,
    disabled: props.action.disabled || false,
    key: props.action.actionId,
    divider: props.divider || false,
    items: props.items,
});

export const mapDashboardActions = (actions: DashboardAction[]) => {
    return actions.map((action) => {
        switch (action.actionId) {
            case 'DUPLICATE':
                return createMenuItem({ action, label: 'Duplicate', iconId: 'duplicate' });
            case 'DELETE':
                return createMenuItem({ action, label: 'Delete', iconId: 'delete' });
            default:
                throw new Error(`Wrong dashboard action [${action.actionId}]`);
        }
    });
};

export const checkIfDashboardHasEditPermission = (authenticator: AuthenticatorService, dashboard: Dashboard) =>
    authenticator.hasPermission('dashboard#edit', dashboard.metadata);

export const getDuplicatedDashboardFromOriginal = (dashboard: Dashboard, newDashboardTitle: string): Dashboard => {
    return { ...omit(dashboard, 'metadata'), id: null, tiles: dashboard.tiles.map((tile) => ({ ...tile, id: null })), title: newDashboardTitle };
};
