/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.inline;

import java.util.Set;
import org.commonmark.node.Code;
import org.commonmark.node.Text;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.beta.InlineContentParser;
import org.commonmark.parser.beta.InlineContentParserFactory;
import org.commonmark.parser.beta.InlineParserState;
import org.commonmark.parser.beta.ParsedInline;
import org.commonmark.parser.beta.Position;
import org.commonmark.parser.beta.Scanner;
import org.commonmark.text.Characters;

public class BackticksInlineParser
implements InlineContentParser {
    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        Position start = scanner.position();
        int openingTicks = scanner.matchMultiple('`');
        Position afterOpening = scanner.position();
        while (scanner.find('`') > 0) {
            Position beforeClosing = scanner.position();
            int count = scanner.matchMultiple('`');
            if (count != openingTicks) continue;
            Code node = new Code();
            String content = scanner.getSource(afterOpening, beforeClosing).getContent();
            if ((content = content.replace('\n', ' ')).length() >= 3 && content.charAt(0) == ' ' && content.charAt(content.length() - 1) == ' ' && Characters.hasNonSpace(content)) {
                content = content.substring(1, content.length() - 1);
            }
            node.setLiteral(content);
            return ParsedInline.of(node, scanner.position());
        }
        SourceLines source = scanner.getSource(start, afterOpening);
        Text text = new Text(source.getContent());
        return ParsedInline.of(text, afterOpening);
    }

    public static class Factory
    implements InlineContentParserFactory {
        @Override
        public Set<Character> getTriggerCharacters() {
            return Set.of(Character.valueOf('`'));
        }

        @Override
        public InlineContentParser create() {
            return new BackticksInlineParser();
        }
    }
}

