/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery;

import java.io.Serializable;
import org.apache.pekko.discovery.Lookup;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

public final class Lookup$
implements Product,
Serializable {
    public static final Lookup$ MODULE$ = new Lookup$();
    private static final Regex SrvQuery;
    private static final Regex DomainName;

    static {
        Product.$init$((Product)MODULE$);
        SrvQuery = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^_(.+?)\\._(.+?)\\.(.+?)$"));
        DomainName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^((?![0-9-])[A-Za-z0-9-]{1,63}(?<!-))((\\.(?![0-9-])[A-Za-z0-9-]{1,63}(?<!-)))*$"));
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Lookup apply(String serviceName) {
        return new Lookup(serviceName, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Lookup apply(String serviceName, Option<String> portName, Option<String> protocol) {
        return new Lookup(serviceName, portName, protocol);
    }

    public Lookup create(String serviceName) {
        return new Lookup(serviceName, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    private Regex SrvQuery() {
        return SrvQuery;
    }

    private Regex DomainName() {
        return DomainName;
    }

    public Lookup parseSrv(String str) {
        Option option;
        if (str != null && !(option = this.SrvQuery().unapplySeq((CharSequence)str)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
            String portName = (String)((LinearSeqOps)option.get()).apply(0);
            String protocol = (String)((LinearSeqOps)option.get()).apply(1);
            String serviceName = (String)((LinearSeqOps)option.get()).apply(2);
            if (this.validDomainName(serviceName)) {
                return new Lookup(serviceName, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$).withPortName(portName).withProtocol(protocol);
            }
        }
        if (str == null) {
            throw new NullPointerException("Unable to create Lookup from passed SRV string. Passed value is 'null'");
        }
        throw new IllegalArgumentException(new StringBuilder(64).append("Unable to create Lookup from passed SRV string, invalid format: ").append(str).toString());
    }

    public boolean isValidSrv(String srv) {
        Option option;
        if (srv != null && !(option = this.SrvQuery().unapplySeq((CharSequence)srv)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
            String serviceName = (String)((LinearSeqOps)option.get()).apply(2);
            return this.validDomainName(serviceName);
        }
        return false;
    }

    private boolean validDomainName(String name) {
        return this.DomainName().pattern().asPredicate().test(name);
    }

    public String productPrefix() {
        return "Lookup";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Lookup$;
    }

    public int hashCode() {
        return -2013227622;
    }

    public String toString() {
        return "Lookup";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Lookup$.class);
    }

    private Lookup$() {
    }
}

