/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.xlrelease.api.v1.views.TeamMemberView;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.builder.TeamBuilder;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.views.converters.TeamMemberViewConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TeamViewConverter {
    private final TeamMemberViewConverter teamMemberViewConverter;

    @Autowired
    public TeamViewConverter(TeamMemberViewConverter teamMemberViewConverter) {
        this.teamMemberViewConverter = teamMemberViewConverter;
    }

    public TeamView toView(Team team) {
        ArrayList members = new ArrayList();
        members.addAll(team.getMembers().stream().map(t -> this.teamMemberViewConverter.toView((String)t, TeamMemberView.MemberType.PRINCIPAL)).collect(Collectors.toList()));
        members.addAll(team.getRoles().stream().map(role -> this.teamMemberViewConverter.toView((String)role, TeamMemberView.MemberType.ROLE)).collect(Collectors.toList()));
        TeamView teamView = new TeamView();
        teamView.setId(team.getId());
        teamView.setTeamName(team.getTeamName());
        teamView.setMembers(members);
        teamView.setPermissions(team.getPermissions().stream().filter(p -> !XLReleasePermissions.DUMMY.getPermissionName().equals(p)).collect(Collectors.toList()));
        teamView.setSystemTeam(team.isSystemTeam());
        return teamView;
    }

    public Team toTeam(TeamView teamView) {
        List principals = teamView.getMembers().stream().filter(member -> member.getType() == TeamMemberView.MemberType.PRINCIPAL).map(TeamMemberView::getName).collect(Collectors.toList());
        List roles = teamView.getMembers().stream().filter(member -> member.getType() == TeamMemberView.MemberType.ROLE).map(TeamMemberView::getName).collect(Collectors.toList());
        return TeamBuilder.newTeam().withId(teamView.getId()).withTeamName(teamView.getTeamName()).withMembers(principals).withRoles(roles).withPermissions(teamView.getPermissions()).build();
    }
}

