/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.customscript;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class CustomScriptTaskUpdater
extends DefaultTaskUpdater {
    @Override
    public Class<? extends Task> getTaskClass() {
        return CustomScriptTask.class;
    }

    @Override
    public Changes update(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        Changes changes = super.update(original, updated, updateDirectives);
        boolean taskUpdated = false;
        if (this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            CustomScriptTask updatedCustomScriptTask = (CustomScriptTask)updated;
            PythonScript updatedPythonScript = updatedCustomScriptTask.getPythonScript();
            CustomScriptTask originalCustomScriptTask = (CustomScriptTask)original;
            PythonScript originalPythonScript = originalCustomScriptTask.getPythonScript();
            this.updateCustomScriptTaskConfiguration(originalPythonScript, updatedPythonScript);
            originalCustomScriptTask.setKeepPreviousOutputPropertiesOnRetry(updatedCustomScriptTask.isKeepPreviousOutputPropertiesOnRetry());
            changes.update((ConfigurationItem)originalPythonScript);
            taskUpdated = true;
        } else if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_CONFIGURATION)) {
            changes.update((ConfigurationItem)original);
            CustomScriptTask updatedCustomScriptTask = (CustomScriptTask)updated;
            PythonScript updatedPythonScript = updatedCustomScriptTask.getPythonScript();
            CustomScriptTask originalCustomScriptTask = (CustomScriptTask)original;
            PythonScript originalPythonScript = originalCustomScriptTask.getPythonScript();
            this.updateCustomScriptTaskConfiguration(originalPythonScript, updatedPythonScript);
            taskUpdated = true;
        }
        if (taskUpdated) {
            this.updateVariableMapping(original, updated);
            this.taskConcurrencyService.updateLastModifiedDetails(original);
        }
        return changes;
    }

    private void updateCustomScriptTaskConfiguration(PythonScript original, PythonScript updatedPythonScript) {
        this.updateInputProperties(original, updatedPythonScript);
        this.updateOutputProperties(original, updatedPythonScript);
    }

    private void updateInputProperties(PythonScript original, PythonScript updated) {
        for (PropertyDescriptor propertyDescriptor : original.getInputProperties()) {
            String name = propertyDescriptor.getName();
            if (propertyDescriptor.getKind() == PropertyKind.CI) {
                Configuration configuration = (Configuration)updated.getProperty(name);
                if (configuration != null) {
                    Preconditions.checkArgument((boolean)configuration.getType().getDescriptor().isAssignableTo(propertyDescriptor.getReferencedType()), (Object)("Type of CI must be " + propertyDescriptor.getReferencedType().getName() + " got " + configuration.getType().getName()));
                }
                original.setProperty(propertyDescriptor.getName(), (Object)configuration);
                continue;
            }
            if (propertyDescriptor.isPassword() && propertyDescriptor.getKind() == PropertyKind.STRING) {
                original.setProperty(propertyDescriptor.getName(), (Object)PasswordVerificationUtils.replacePasswordIfNeeded((String)original.getProperty(name), (String)updated.getProperty(name)));
                continue;
            }
            original.setProperty(propertyDescriptor.getName(), updated.getProperty(name));
        }
    }

    private void updateOutputProperties(PythonScript original, PythonScript updated) {
        for (PropertyDescriptor propertyDescriptor : original.getTransitionalAndOutputProperties()) {
            String name = propertyDescriptor.getName();
            Object value = updated.getProperty(name);
            original.setProperty(name, value);
        }
    }
}

