import React from 'react';
import { DotIllustration, DotTypography } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { EmptyData, EmptyDataProps } from './empty-data.component';

describe('EmptyData', () => {
    const message = 'No data found.';

    const defaultProps: EmptyDataProps = { message };

    const mount = (props: EmptyDataProps = defaultProps) => {
        return mountWithTheme(<EmptyData {...props} />);
    };

    const getMessage = (wrapper: ReactWrapper) => wrapper.find(DotTypography);
    const getIllustrationId = (wrapper: ReactWrapper) => wrapper.find(DotIllustration);

    it('should render properly', () => {
        const wrapper = mount();
        expect(getMessage(wrapper)).toHaveText(message);
        expect(getIllustrationId(wrapper)).not.toExist();
    });

    it('should render illustration if illustrationId is defined', () => {
        const wrapper = mount({ ...defaultProps, illustrationId: 'test-illustration' });
        expect(getIllustrationId(wrapper).props().illustrationId).toBe('test-illustration');
    });
});
