/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.jaxb;

import com.xebialabs.deployit.core.api.jaxb.CollectionOfStringsMapElement;
import com.xebialabs.deployit.core.api.jaxb.MapElement;
import com.xebialabs.deployit.core.api.jaxb.MapMapElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapAdapter
extends XmlAdapter<MapElement[], Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(MapAdapter.class);

    /*
     * Enabled aggressive block sorting
     */
    public MapElement[] marshal(Map<String, Object> map) throws Exception {
        ArrayList<MapElement> elements = new ArrayList<MapElement>();
        if (map != null) {
            for (Map.Entry<String, Object> each : map.entrySet()) {
                Object mapValue;
                Object eachValue = each.getValue();
                if (eachValue == null) continue;
                if (eachValue instanceof Map) {
                    mapValue = new MapMapElement((Map)eachValue);
                } else if (eachValue instanceof Collection) {
                    Collection c = (Collection)eachValue;
                    if (c.isEmpty()) {
                        mapValue = null;
                    } else {
                        Object object = c.iterator().next();
                        if (!(object instanceof String)) {
                            String message = each.getKey() + " is a collection but the contents " + String.valueOf(object) + " is not String";
                            logger.error(message);
                            throw new IllegalArgumentException(message);
                        }
                        mapValue = new CollectionOfStringsMapElement(c);
                    }
                } else if (eachValue instanceof String) {
                    mapValue = eachValue;
                } else {
                    String className = eachValue != null ? eachValue.getClass().getCanonicalName() : null;
                    String message = String.format("Property %s is not a Collection, String or RepositoryObject, but a %s", each.getKey(), className);
                    logger.error(message);
                    throw new IllegalArgumentException(message);
                }
                if (mapValue == null) continue;
                elements.add(new MapElement(each.getKey(), mapValue));
            }
        }
        return elements.toArray(new MapElement[elements.size()]);
    }

    public Map<String, Object> unmarshal(MapElement[] values) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (MapElement each : values) {
            Object mapValue;
            Object eachValue = each.getValue();
            if (eachValue instanceof CollectionOfStringsMapElement) {
                mapValue = ((CollectionOfStringsMapElement)eachValue).getStrings();
            } else if (eachValue instanceof MapMapElement) {
                mapValue = ((MapMapElement)eachValue).getMap();
            } else if (eachValue instanceof String) {
                mapValue = eachValue;
            } else {
                String message = "Property " + each.getKey() + " is not of a recognized type but it is: " + String.valueOf(eachValue);
                logger.error(message);
                throw new IllegalArgumentException(message);
            }
            map.put(each.getKey(), mapValue);
        }
        return map;
    }
}

