/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import jakarta.persistence.AccessType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.AccessStrategyHelper;
import org.hibernate.property.access.spi.EnhancedGetterFieldImpl;
import org.hibernate.property.access.spi.EnhancedSetterImpl;
import org.hibernate.property.access.spi.EnhancedSetterMethodImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterFieldImpl;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessBuildingException;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class PropertyAccessEnhancedImpl
implements PropertyAccess {
    private final @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy strategy;
    private final @UnknownKeyFor @NonNull @Initialized Getter getter;
    private final @UnknownKeyFor @NonNull @Initialized Setter setter;

    public PropertyAccessEnhancedImpl(@UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy strategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, @Nullable @UnknownKeyFor @Initialized AccessType classAccessType) {
        this.strategy = strategy;
        AccessType propertyAccessType = classAccessType == null ? AccessStrategyHelper.getAccessType(containerJavaType, propertyName) : classAccessType;
        switch (propertyAccessType) {
            case FIELD: {
                Field field = AccessStrategyHelper.fieldOrNull(containerJavaType, propertyName);
                if (field == null) {
                    throw new PropertyAccessBuildingException("Could not locate field for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
                }
                this.getter = new GetterFieldImpl(containerJavaType, propertyName, field);
                this.setter = new EnhancedSetterImpl(containerJavaType, propertyName, field);
                break;
            }
            case PROPERTY: {
                Method getterMethod = ReflectHelper.getterMethodOrNull(containerJavaType, propertyName);
                if (getterMethod == null) {
                    throw new PropertyAccessBuildingException("Could not locate getter for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
                }
                this.getter = PropertyAccessEnhancedImpl.propertyGetter(classAccessType, containerJavaType, propertyName, getterMethod);
                this.setter = PropertyAccessEnhancedImpl.propertySetter(classAccessType, containerJavaType, propertyName, getterMethod.getReturnType());
                break;
            }
            default: {
                throw new PropertyAccessBuildingException("Invalid access type " + propertyAccessType + " for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Getter propertyGetter(@Nullable @UnknownKeyFor @Initialized AccessType classAccessType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method getterMethod) {
        AccessType explicitAccessType;
        if (classAccessType != null && (explicitAccessType = AccessStrategyHelper.getAccessType(containerJavaType, propertyName)) == AccessType.FIELD) {
            Field field = ReflectHelper.findField(containerJavaType, propertyName);
            return new EnhancedGetterFieldImpl(containerJavaType, propertyName, field, getterMethod);
        }
        return new GetterMethodImpl(containerJavaType, propertyName, getterMethod);
    }

    private static @UnknownKeyFor @NonNull @Initialized Setter propertySetter(@Nullable @UnknownKeyFor @Initialized AccessType classAccessType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fieldType) {
        AccessType explicitAccessType;
        if (classAccessType != null && (explicitAccessType = AccessStrategyHelper.getAccessType(containerJavaType, propertyName)) == AccessType.FIELD) {
            Field field = ReflectHelper.findField(containerJavaType, propertyName);
            return new EnhancedSetterImpl(containerJavaType, propertyName, field);
        }
        Method setterMethod = ReflectHelper.findSetterMethod(containerJavaType, propertyName, fieldType);
        return new EnhancedSetterMethodImpl(containerJavaType, propertyName, setterMethod);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Getter getGetter() {
        return this.getter;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Setter getSetter() {
        return this.setter;
    }
}

