/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.kohsuke.github.EnterpriseManagedSupport;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHExternalGroup;
import org.kohsuke.github.GHExternalGroupPage;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;

class GHExternalGroupIterable
extends PagedIterable<GHExternalGroup> {
    private final GHOrganization owner;
    private final GitHubRequest request;
    private GHExternalGroupPage result;

    GHExternalGroupIterable(GHOrganization owner, GitHubRequest.Builder<?> requestBuilder) {
        this.owner = owner;
        this.request = requestBuilder.build();
    }

    @Override
    @Nonnull
    public PagedIterator<GHExternalGroup> _iterator(int pageSize) {
        return new PagedIterator<GHExternalGroup>(this.adapt(GitHubPageIterator.create(this.owner.root().getClient(), GHExternalGroupPage.class, this.request, pageSize)), null);
    }

    private Iterator<GHExternalGroup[]> adapt(final Iterator<GHExternalGroupPage> base) {
        return new Iterator<GHExternalGroup[]>(){

            @Override
            public boolean hasNext() {
                try {
                    return base.hasNext();
                }
                catch (GHException e) {
                    throw EnterpriseManagedSupport.forOrganization(GHExternalGroupIterable.this.owner).filterException(e).orElse(e);
                }
            }

            @Override
            public GHExternalGroup[] next() {
                GHExternalGroupPage v = (GHExternalGroupPage)base.next();
                if (GHExternalGroupIterable.this.result == null) {
                    GHExternalGroupIterable.this.result = v;
                }
                Arrays.stream(v.getGroups()).forEach(g -> g.wrapUp(GHExternalGroupIterable.this.owner));
                return v.getGroups();
            }
        };
    }
}

